/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.AbstractTask;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.DelayFilter;
import jp.hasc.hasctool.core.runtime.filter.MeanFilter;
import jp.hasc.hasctool.core.runtime.filter.SampleFilter1;
import jp.hasc.hasctool.core.runtime.filter.ScalarAdder;
import jp.hasc.hasctool.core.runtime.filter.ScalarMultiplier;
import jp.hasc.hasctool.core.runtime.filter.SignalTimeSorter;
import jp.hasc.hasctool.core.runtime.filter.SleepFilter;
import jp.hasc.hasctool.core.runtime.filter.VarianceFilter;
import jp.hasc.hasctool.core.runtime.filter.VectorAdder;
import jp.hasc.hasctool.core.runtime.filter.VectorConcatenater;
import jp.hasc.hasctool.core.runtime.filter.VectorElementFilter;
import jp.hasc.hasctool.core.runtime.filter.VectorIntegrator;
import jp.hasc.hasctool.core.runtime.filter.file.CSVToVectorFilter;
import jp.hasc.hasctool.core.runtime.filter.file.HascLogAccToVectorFilter;
import jp.hasc.hasctool.core.runtime.filter.file.VectorToCSVFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.ComplexToVectorFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.FFTFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.HighPassFilter;
import jp.hasc.hasctool.core.runtime.filter.frequency.LowPassFilter;
import jp.hasc.hasctool.core.runtime.filter.interpolator.VectorPeriodicSignalSampler;
import jp.hasc.hasctool.core.runtime.filter.window.HanningWindowFunctionFilter;
import jp.hasc.hasctool.core.runtime.sink.LineWriterSink;
import jp.hasc.hasctool.core.runtime.source.LineReaderSource;
import jp.hasc.hasctool.core.runtime.source.SinWaveGenerator;
import jp.hasc.hasctool.core.runtime.source.UDPStringReceiver;
import jp.hasc.hasctool.core.util.CoreUtil;
import jp.hasc.hasctool.ui.views.VectorView;
import jp.hasc.hasctool.ui.views.WaveView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class RuntimeSamplesView
extends ViewPart {
    public static final String ID = "jp.hasc.hasctool.ui.views.RuntimeSamplesView";
    private static final long TIME_10MS = SignalMessage.TIME_UNIT.convert(10L, TimeUnit.MILLISECONDS);
    private static final long TIME_30MS = SignalMessage.TIME_UNIT.convert(30L, TimeUnit.MILLISECONDS);
    private static final long TIME_1000MS = SignalMessage.TIME_UNIT.convert(1000L, TimeUnit.MILLISECONDS);
    protected WaveView waveView_;
    protected VectorView vectorView_;
    protected RuntimeContext context_ = null;
    protected static int waveViewIndex__ = 0;
    private MessageProcessor waveViewSink_;
    private MessageProcessor vectorViewSink_;
    protected String csvOutputFileName_ = null;
    protected Text csvOutputFileNameText_;
    private Text queueCapacityText_;
    private Text timeScaleText_;

    protected SinWaveGenerator createSinWaveGenerator(long cycle, long tickEnd, long tickInterval) {
        SinWaveGenerator sw = new SinWaveGenerator();
        sw.setCycle(cycle);
        sw.setTickEnd(tickEnd);
        sw.setTickInterval(tickInterval);
        sw.setup(this.context_);
        return sw;
    }

    protected SinWaveGenerator createSampleSinWaveGenerator() {
        return this.createSinWaveGenerator(SignalMessage.TIME_UNIT.convert(1000L, TimeUnit.MILLISECONDS), SignalMessage.TIME_UNIT.convert(10000L, TimeUnit.MILLISECONDS), TIME_10MS);
    }

    protected SinWaveGenerator createSampleSinWave2Generator() {
        return this.createSinWaveGenerator(SignalMessage.TIME_UNIT.convert(100L, TimeUnit.MILLISECONDS), SignalMessage.TIME_UNIT.convert(10000L, TimeUnit.MILLISECONDS), SignalMessage.TIME_UNIT.convert(7L, TimeUnit.MILLISECONDS));
    }

    protected SinWaveGenerator createSampleSinWave3Generator() {
        return this.createSinWaveGenerator(SignalMessage.TIME_UNIT.convert(2010L, TimeUnit.MILLISECONDS), SignalMessage.TIME_UNIT.convert(10000L, TimeUnit.MILLISECONDS), SignalMessage.TIME_UNIT.convert(77L, TimeUnit.MILLISECONDS));
    }

    protected SinWaveGenerator createSampleSinWave4Generator() {
        return this.createSinWaveGenerator(SignalMessage.TIME_UNIT.convert(6283185L, TimeUnit.MICROSECONDS), SignalMessage.TIME_UNIT.convert(10000L, TimeUnit.MILLISECONDS), SignalMessage.TIME_UNIT.convert(30L, TimeUnit.MILLISECONDS));
    }

    protected MessageProcessor getVectorViewSink() {
        if (this.vectorViewSink_ == null) {
            MessageConnector sink2 = new MessageConnector();
            this.vectorViewSink_ = sink2;
            if (!this.timeScaleText_.getText().isEmpty()) {
                SleepFilter sleeper = new SleepFilter();
                sleeper.setTimeScale(Double.parseDouble(this.timeScaleText_.getText()));
                sleeper.setup(this.context_);
                sink2.connect(sleeper.getInputPort());
                sleeper.getOutputPort().connect(this.getVectorView().getInputPort());
            } else {
                sink2.connect(this.getVectorView().getInputPort());
            }
        }
        return this.vectorViewSink_;
    }

    protected MessageProcessor getWaveViewSink() {
        if (this.waveViewSink_ == null) {
            MessageConnector sink = new MessageConnector();
            this.waveViewSink_ = sink;
            if (!this.timeScaleText_.getText().isEmpty()) {
                SleepFilter sleeper = new SleepFilter();
                sleeper.setTimeScale(Double.parseDouble(this.timeScaleText_.getText()));
                sleeper.setup(this.context_);
                sink.connect(sleeper.getInputPort());
                sleeper.getOutputPort().connect(this.getWaveView().getInputPort());
            } else {
                sink.connect(this.getWaveView().getInputPort());
            }
            if (this.csvOutputFileName_ != null) {
                try {
                    VectorToCSVFilter csvout = new VectorToCSVFilter();
                    csvout.setup(this.context_);
                    LineWriterSink lw = new LineWriterSink();
                    lw.setWriter(new FileWriter(this.csvOutputFileName_));
                    sink.connect(csvout.getInputPort());
                    csvout.getOutputPort().connect(lw.getInputPort());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.waveViewSink_;
    }

    protected void initTaskManager() {
        this.waveView_ = null;
        this.waveViewSink_ = null;
        this.vectorView_ = null;
        this.vectorViewSink_ = null;
        this.context_ = new RuntimeContext();
        if (!this.queueCapacityText_.getText().isEmpty()) {
            this.context_.setDefaultMessageQueueCapacity(Integer.parseInt(this.queueCapacityText_.getText()));
        }
    }

    protected VectorView getVectorView() {
        if (this.vectorView_ == null) {
            try {
                this.vectorView_ = (VectorView)this.getViewSite().getWorkbenchWindow().getActivePage().showView("jp.hasc.hasctool.ui.views.VectorView", null, 1);
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
                CoreUtil.throwAsRuntimeException(ex);
            }
        }
        return this.vectorView_;
    }

    protected WaveView getWaveView() {
        if (this.waveView_ == null) {
            try {
                this.waveView_ = (WaveView)this.getViewSite().getWorkbenchWindow().getActivePage().showView("jp.hasc.hasctool.ui.views.WaveView", null, 1);
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
                CoreUtil.throwAsRuntimeException(ex);
            }
        }
        return this.waveView_;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite pane1 = new Composite(parent, 0);
        pane1.setLayoutData((Object)new GridData(4, 1, true, false));
        pane1.setLayout((Layout)new RowLayout());
        Composite pane2 = new Composite(parent, 0);
        pane2.setLayoutData((Object)new GridData(4, 1, true, false));
        pane2.setLayout((Layout)new RowLayout());
        Composite pane3 = new Composite(parent, 0);
        pane3.setLayoutData((Object)new GridData(4, 1, true, false));
        pane3.setLayout((Layout)new RowLayout());
        Button b = new Button(pane1, 2048);
        b.setText("sin(t)");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWaveGenerator();
                sinGen.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("0.5 * (1 + sin(t))");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWaveGenerator();
                ScalarAdder add = new ScalarAdder();
                add.setOffset(1.0);
                add.setup(RuntimeSamplesView.this.context_);
                ScalarMultiplier mul = new ScalarMultiplier();
                mul.setScale(0.5);
                mul.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(add.getInputPort());
                add.getOutputPort().connect(mul.getInputPort());
                mul.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("sin(t), sin(t - 100ms)");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWaveGenerator();
                DelayFilter delay = new DelayFilter();
                delay.setDelay(SignalMessage.TIME_UNIT.convert(100L, TimeUnit.MILLISECONDS));
                delay.setup(RuntimeSamplesView.this.context_);
                VectorConcatenater concat = new VectorConcatenater();
                concat.setInputPortCount(2);
                concat.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(concat.getInputPort(0));
                sinGen.getOutputPort().connect(delay.getInputPort());
                delay.getOutputPort().connect(concat.getInputPort(1));
                concat.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("sin(t) - 0.5 * sin(t - 100ms)");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWaveGenerator();
                DelayFilter delay = new DelayFilter();
                delay.setDelay(SignalMessage.TIME_UNIT.convert(100L, TimeUnit.MILLISECONDS));
                delay.setup(RuntimeSamplesView.this.context_);
                ScalarMultiplier smul = new ScalarMultiplier();
                smul.setScale(-0.5);
                smul.setup(RuntimeSamplesView.this.context_);
                VectorAdder vadd = new VectorAdder();
                vadd.setInputPortCount(2);
                vadd.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(vadd.getInputPort(0));
                sinGen.getOutputPort().connect(delay.getInputPort());
                delay.getOutputPort().connect(smul.getInputPort());
                smul.getOutputPort().connect(vadd.getInputPort(1));
                vadd.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("sin(t) + 0.1 * sin(t2)");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWaveGenerator();
                SinWaveGenerator sinGen2 = RuntimeSamplesView.this.createSampleSinWave2Generator();
                ScalarMultiplier smul = new ScalarMultiplier();
                smul.setScale(0.1);
                smul.setup(RuntimeSamplesView.this.context_);
                VectorAdder vadd = new VectorAdder();
                vadd.setInputPortCount(2);
                vadd.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(vadd.getInputPort(0));
                sinGen2.getOutputPort().connect(smul.getInputPort());
                smul.getOutputPort().connect(vadd.getInputPort(1));
                vadd.setPrimaryInputPortIndex(0);
                vadd.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("sin(t3) + sin(t)");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen3 = RuntimeSamplesView.this.createSampleSinWave3Generator();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWaveGenerator();
                VectorAdder vadd = new VectorAdder();
                vadd.setInputPortCount(2);
                vadd.setPrimaryInputPortIndex(0);
                vadd.setup(RuntimeSamplesView.this.context_);
                sinGen3.getOutputPort().connect(vadd.getInputPort(0));
                sinGen.getOutputPort().connect(vadd.getInputPort(1));
                vadd.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("SampleFilter1");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWaveGenerator();
                SampleFilter1 filter = new SampleFilter1();
                filter.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(filter.getInputPort());
                filter.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("Periodic2");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWave2Generator();
                VectorPeriodicSignalSampler filter = new VectorPeriodicSignalSampler();
                filter.setTimeStep(TIME_30MS);
                filter.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(filter.getInputPort());
                filter.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("Periodic3");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWave3Generator();
                VectorPeriodicSignalSampler filter = new VectorPeriodicSignalSampler();
                filter.setTimeStep(TIME_30MS);
                filter.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(filter.getInputPort());
                filter.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("integrate(sin(t))");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWave4Generator();
                VectorIntegrator filter = new VectorIntegrator();
                filter.setInitialValue(VectorSignalMessages.createScalar(0L, 0.0));
                filter.setTimeStep(TIME_10MS);
                filter.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(filter.getInputPort());
                filter.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("Linear ODE");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                final long samplingTime = TIME_10MS;
                VectorIntegrator int0 = new VectorIntegrator();
                int0.setInitialValue(VectorSignalMessages.createScalar(0L, 0.0));
                int0.setTimeStep(samplingTime);
                int0.setup(RuntimeSamplesView.this.context_);
                ScalarMultiplier gain0 = new ScalarMultiplier();
                gain0.setScale(-3.0);
                gain0.setup(RuntimeSamplesView.this.context_);
                VectorIntegrator int1 = new VectorIntegrator();
                int1.setInitialValue(VectorSignalMessages.createScalar(0L, 0.0));
                int1.setTimeStep(samplingTime);
                int1.setup(RuntimeSamplesView.this.context_);
                ScalarMultiplier gain1 = new ScalarMultiplier();
                gain1.setScale(-10.0);
                gain1.setup(RuntimeSamplesView.this.context_);
                VectorAdder vadd = new VectorAdder();
                vadd.setInputPortCount(3);
                vadd.setPrimaryInputPortIndex(1);
                vadd.setup(RuntimeSamplesView.this.context_);
                final MessageProcessor stepInput = vadd.getInputPort(0);
                ScalarMultiplier mult10 = new ScalarMultiplier();
                mult10.setScale(10.0);
                mult10.setup(RuntimeSamplesView.this.context_);
                new AbstractTask(){

                    @Override
                    protected void run() throws InterruptedException {
                        stepInput.processMessage((Object)SignalMessage.BEGIN);
                        stepInput.processMessage(VectorSignalMessages.createScalar(0L, 0.0));
                        stepInput.processMessage(VectorSignalMessages.createScalar(TIME_1000MS - samplingTime, 0.0));
                        stepInput.processMessage(VectorSignalMessages.createScalar(TIME_1000MS, 1.0));
                        stepInput.processMessage(VectorSignalMessages.createScalar(5L * TIME_1000MS, 1.0));
                        stepInput.processMessage((Object)SignalMessage.END);
                    }
                }.setup(RuntimeSamplesView.this.context_);
                gain0.getOutputPort().connect(vadd.getInputPort(1));
                gain1.getOutputPort().connect(vadd.getInputPort(2));
                vadd.getOutputPort().connect(int0.getInputPort());
                int0.getOutputPort().connect(int1.getInputPort());
                int0.getOutputPort().connect(gain0.getInputPort());
                int1.getOutputPort().connect(mult10.getInputPort());
                int1.getOutputPort().connect(gain1);
                mult10.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("Hanning");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWaveGenerator();
                HanningWindowFunctionFilter wffilter = new HanningWindowFunctionFilter();
                wffilter.setSampleNum(256);
                wffilter.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(wffilter.getInputPort());
                wffilter.getOutputPort().connect(RuntimeSamplesView.this.getVectorViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane1, 2048);
        b.setText("FFTFilter");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.initTaskManager();
                SinWaveGenerator sinGen = RuntimeSamplesView.this.createSampleSinWaveGenerator();
                HanningWindowFunctionFilter wffilter = new HanningWindowFunctionFilter();
                wffilter.setSampleNum(256);
                wffilter.setup(RuntimeSamplesView.this.context_);
                FFTFilter fftfilter = new FFTFilter();
                fftfilter.setup(RuntimeSamplesView.this.context_);
                ComplexToVectorFilter cvfilter = new ComplexToVectorFilter();
                cvfilter.setup(RuntimeSamplesView.this.context_);
                sinGen.getOutputPort().connect(wffilter.getInputPort());
                wffilter.getOutputPort().connect(fftfilter.getInputPort());
                fftfilter.getOutputPort().connect(cvfilter.getInputPort());
                cvfilter.getOutputPort().connect(RuntimeSamplesView.this.getVectorViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        final FileDialog fileDialog = new FileDialog(parent.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc", "*"});
        Button b2 = new Button(pane2, 2048);
        b2.setText("CSV file source");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fname = fileDialog.open();
                if (fname != null) {
                    RuntimeSamplesView.this.stopTasks();
                    RuntimeSamplesView.this.initTaskManager();
                    try {
                        LineReaderSource reader = new LineReaderSource();
                        reader.setReader(new FileReader(fname));
                        reader.setup(RuntimeSamplesView.this.context_);
                        CSVToVectorFilter parser = new CSVToVectorFilter();
                        parser.setup(RuntimeSamplesView.this.context_);
                        reader.getOutputPort().connect(parser.getInputPort());
                        parser.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                        RuntimeSamplesView.this.context_.startTasks();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        fileDialog = new FileDialog(parent.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc", "*"});
        b2 = new Button(pane2, 2048);
        b2.setText("CSV file mean");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fname = fileDialog.open();
                if (fname != null) {
                    RuntimeSamplesView.this.stopTasks();
                    RuntimeSamplesView.this.initTaskManager();
                    try {
                        LineReaderSource reader = new LineReaderSource();
                        reader.setReader(new FileReader(fname));
                        reader.setup(RuntimeSamplesView.this.context_);
                        CSVToVectorFilter parser = new CSVToVectorFilter();
                        parser.setup(RuntimeSamplesView.this.context_);
                        MeanFilter mean = new MeanFilter();
                        mean.setSampleNum(10);
                        reader.getOutputPort().connect(parser.getInputPort());
                        parser.getOutputPort().connect(mean.getInputPort());
                        mean.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                        RuntimeSamplesView.this.context_.startTasks();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        fileDialog = new FileDialog(parent.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc", "*"});
        b2 = new Button(pane2, 2048);
        b2.setText("CSV file variance");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fname = fileDialog.open();
                if (fname != null) {
                    RuntimeSamplesView.this.stopTasks();
                    RuntimeSamplesView.this.initTaskManager();
                    try {
                        LineReaderSource reader = new LineReaderSource();
                        reader.setReader(new FileReader(fname));
                        reader.setup(RuntimeSamplesView.this.context_);
                        CSVToVectorFilter parser = new CSVToVectorFilter();
                        parser.setup(RuntimeSamplesView.this.context_);
                        VarianceFilter variance = new VarianceFilter();
                        variance.setSampleNum(10);
                        reader.getOutputPort().connect(parser.getInputPort());
                        parser.getOutputPort().connect(variance.getInputPort());
                        variance.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                        RuntimeSamplesView.this.context_.startTasks();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        fileDialog = new FileDialog(parent.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc", "*"});
        b2 = new Button(pane2, 2048);
        b2.setText("CSV file FFT");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fname = fileDialog.open();
                if (fname != null) {
                    RuntimeSamplesView.this.stopTasks();
                    RuntimeSamplesView.this.initTaskManager();
                    try {
                        LineReaderSource reader = new LineReaderSource();
                        reader.setReader(new FileReader(fname));
                        reader.setup(RuntimeSamplesView.this.context_);
                        CSVToVectorFilter parser = new CSVToVectorFilter();
                        parser.setup(RuntimeSamplesView.this.context_);
                        VectorElementFilter vsfilter = new VectorElementFilter();
                        vsfilter.setElementIndex(2);
                        vsfilter.setup(RuntimeSamplesView.this.context_);
                        HanningWindowFunctionFilter wffilter = new HanningWindowFunctionFilter();
                        wffilter.setSampleNum(256);
                        wffilter.setup(RuntimeSamplesView.this.context_);
                        FFTFilter fftfilter = new FFTFilter();
                        fftfilter.setup(RuntimeSamplesView.this.context_);
                        ComplexToVectorFilter cvfilter = new ComplexToVectorFilter();
                        cvfilter.setup(RuntimeSamplesView.this.context_);
                        reader.getOutputPort().connect(parser.getInputPort());
                        parser.getOutputPort().connect(vsfilter.getInputPort());
                        vsfilter.getOutputPort().connect(wffilter.getInputPort());
                        wffilter.getOutputPort().connect(fftfilter.getInputPort());
                        fftfilter.getOutputPort().connect(cvfilter.getInputPort());
                        cvfilter.getOutputPort().connect(RuntimeSamplesView.this.getVectorViewSink());
                        RuntimeSamplesView.this.context_.startTasks();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        fileDialog = new FileDialog(parent.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc", "*"});
        b2 = new Button(pane2, 2048);
        b2.setText("CSV file LowPass");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fname = fileDialog.open();
                if (fname != null) {
                    RuntimeSamplesView.this.stopTasks();
                    RuntimeSamplesView.this.initTaskManager();
                    try {
                        LineReaderSource reader = new LineReaderSource();
                        reader.setReader(new FileReader(fname));
                        reader.setup(RuntimeSamplesView.this.context_);
                        CSVToVectorFilter parser = new CSVToVectorFilter();
                        parser.setup(RuntimeSamplesView.this.context_);
                        VectorElementFilter vsfilter = new VectorElementFilter();
                        vsfilter.setElementIndex(2);
                        vsfilter.setup(RuntimeSamplesView.this.context_);
                        LowPassFilter lowpassfilter = new LowPassFilter();
                        lowpassfilter.setSampleNum(256);
                        lowpassfilter.setCutoffFrequency(2);
                        lowpassfilter.setup(RuntimeSamplesView.this.context_);
                        reader.getOutputPort().connect(parser.getInputPort());
                        parser.getOutputPort().connect(vsfilter.getInputPort());
                        vsfilter.getOutputPort().connect(lowpassfilter.getInputPort());
                        lowpassfilter.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                        RuntimeSamplesView.this.context_.startTasks();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        fileDialog = new FileDialog(parent.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc", "*"});
        b2 = new Button(pane2, 2048);
        b2.setText("CSV file HighPass");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fname = fileDialog.open();
                if (fname != null) {
                    RuntimeSamplesView.this.stopTasks();
                    RuntimeSamplesView.this.initTaskManager();
                    try {
                        LineReaderSource reader = new LineReaderSource();
                        reader.setReader(new FileReader(fname));
                        reader.setup(RuntimeSamplesView.this.context_);
                        CSVToVectorFilter parser = new CSVToVectorFilter();
                        parser.setup(RuntimeSamplesView.this.context_);
                        VectorElementFilter vsfilter = new VectorElementFilter();
                        vsfilter.setElementIndex(2);
                        vsfilter.setup(RuntimeSamplesView.this.context_);
                        HighPassFilter highpassfilter = new HighPassFilter();
                        highpassfilter.setSampleNum(256);
                        highpassfilter.setCutoffFrequency(2);
                        highpassfilter.setup(RuntimeSamplesView.this.context_);
                        reader.getOutputPort().connect(parser.getInputPort());
                        parser.getOutputPort().connect(vsfilter.getInputPort());
                        vsfilter.getOutputPort().connect(highpassfilter.getInputPort());
                        highpassfilter.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                        RuntimeSamplesView.this.context_.startTasks();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        fileDialog = new FileDialog(parent.getShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.log", "*"});
        b2 = new Button(pane2, 2048);
        b2.setText("Hasc log source");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fname = fileDialog.open();
                if (fname != null) {
                    RuntimeSamplesView.this.stopTasks();
                    RuntimeSamplesView.this.initTaskManager();
                    try {
                        LineReaderSource reader = new LineReaderSource();
                        reader.setReader(new FileReader(fname));
                        reader.setup(RuntimeSamplesView.this.context_);
                        HascLogAccToVectorFilter parser = new HascLogAccToVectorFilter();
                        parser.setup(RuntimeSamplesView.this.context_);
                        reader.getOutputPort().connect(parser.getInputPort());
                        parser.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                        RuntimeSamplesView.this.context_.startTasks();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        b = new Button(pane2, 2048);
        b.setText("CSV UDP source");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.timeScaleText_.setText("");
                RuntimeSamplesView.this.initTaskManager();
                UDPStringReceiver receiver = new UDPStringReceiver();
                receiver.setup(RuntimeSamplesView.this.context_);
                CSVToVectorFilter parser = new CSVToVectorFilter();
                parser.setup(RuntimeSamplesView.this.context_);
                SignalTimeSorter soreter = new SignalTimeSorter();
                soreter.setup(RuntimeSamplesView.this.context_);
                receiver.getOutputPort().connect(parser.getInputPort());
                parser.getOutputPort().connect(soreter.getInputPort());
                soreter.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane2, 2048);
        b.setText("CSV UDP FFT");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.timeScaleText_.setText("");
                RuntimeSamplesView.this.initTaskManager();
                UDPStringReceiver receiver = new UDPStringReceiver();
                receiver.setup(RuntimeSamplesView.this.context_);
                CSVToVectorFilter parser = new CSVToVectorFilter();
                parser.setup(RuntimeSamplesView.this.context_);
                SignalTimeSorter soreter = new SignalTimeSorter();
                soreter.setup(RuntimeSamplesView.this.context_);
                VectorElementFilter vsfilter = new VectorElementFilter();
                vsfilter.setElementIndex(2);
                vsfilter.setup(RuntimeSamplesView.this.context_);
                HanningWindowFunctionFilter wffilter = new HanningWindowFunctionFilter();
                wffilter.setSampleNum(256);
                wffilter.setup(RuntimeSamplesView.this.context_);
                FFTFilter fftfilter = new FFTFilter();
                fftfilter.setup(RuntimeSamplesView.this.context_);
                ComplexToVectorFilter cvfilter = new ComplexToVectorFilter();
                cvfilter.setup(RuntimeSamplesView.this.context_);
                receiver.getOutputPort().connect(parser.getInputPort());
                parser.getOutputPort().connect(soreter.getInputPort());
                soreter.getOutputPort().connect(vsfilter.getInputPort());
                vsfilter.getOutputPort().connect(wffilter.getInputPort());
                wffilter.getOutputPort().connect(fftfilter.getInputPort());
                fftfilter.getOutputPort().connect(cvfilter.getInputPort());
                cvfilter.getOutputPort().connect(RuntimeSamplesView.this.getVectorViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane2, 2048);
        b.setText("CSV UDP LowPass");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.timeScaleText_.setText("");
                RuntimeSamplesView.this.initTaskManager();
                UDPStringReceiver receiver = new UDPStringReceiver();
                receiver.setup(RuntimeSamplesView.this.context_);
                CSVToVectorFilter parser = new CSVToVectorFilter();
                parser.setup(RuntimeSamplesView.this.context_);
                SignalTimeSorter soreter = new SignalTimeSorter();
                soreter.setup(RuntimeSamplesView.this.context_);
                VectorElementFilter vsfilter = new VectorElementFilter();
                vsfilter.setElementIndex(2);
                vsfilter.setup(RuntimeSamplesView.this.context_);
                LowPassFilter lowpassfilter = new LowPassFilter();
                lowpassfilter.setSampleNum(256);
                lowpassfilter.setCutoffFrequency(2);
                lowpassfilter.setup(RuntimeSamplesView.this.context_);
                receiver.getOutputPort().connect(parser.getInputPort());
                parser.getOutputPort().connect(soreter.getInputPort());
                soreter.getOutputPort().connect(vsfilter.getInputPort());
                vsfilter.getOutputPort().connect(lowpassfilter.getInputPort());
                lowpassfilter.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane2, 2048);
        b.setText("CSV UDP HighPass");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
                RuntimeSamplesView.this.timeScaleText_.setText("");
                RuntimeSamplesView.this.initTaskManager();
                UDPStringReceiver receiver = new UDPStringReceiver();
                receiver.setup(RuntimeSamplesView.this.context_);
                CSVToVectorFilter parser = new CSVToVectorFilter();
                parser.setup(RuntimeSamplesView.this.context_);
                SignalTimeSorter soreter = new SignalTimeSorter();
                soreter.setup(RuntimeSamplesView.this.context_);
                VectorElementFilter vsfilter = new VectorElementFilter();
                vsfilter.setElementIndex(2);
                vsfilter.setup(RuntimeSamplesView.this.context_);
                HighPassFilter highpassfilter = new HighPassFilter();
                highpassfilter.setSampleNum(256);
                highpassfilter.setCutoffFrequency(2);
                highpassfilter.setup(RuntimeSamplesView.this.context_);
                receiver.getOutputPort().connect(parser.getInputPort());
                parser.getOutputPort().connect(soreter.getInputPort());
                soreter.getOutputPort().connect(vsfilter.getInputPort());
                vsfilter.getOutputPort().connect(highpassfilter.getInputPort());
                highpassfilter.getOutputPort().connect(RuntimeSamplesView.this.getWaveViewSink());
                RuntimeSamplesView.this.context_.startTasks();
            }
        });
        b = new Button(pane3, 2048);
        b.setText("stop");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.stopTasks();
            }
        });
        fileDialog = new FileDialog(parent.getShell(), 8192);
        fileDialog.setFilterExtensions(new String[]{"*.csv;*.acc", "*"});
        b2 = new Button(pane3, 2048);
        b2.setText("output CSV file:");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeSamplesView.this.csvOutputFileName_ = fileDialog.open();
                RuntimeSamplesView.this.csvOutputFileNameText_.setText(RuntimeSamplesView.this.csvOutputFileName_ != null ? RuntimeSamplesView.this.csvOutputFileName_ : "");
            }
        });
        this.csvOutputFileNameText_ = new Text(pane3, 2052);
        this.csvOutputFileNameText_.setLayoutData((Object)new RowData(50, -1));
        Label l = new Label(pane3, 0);
        l.setText("queue capacity:");
        this.queueCapacityText_ = new Text(pane3, 2052);
        this.queueCapacityText_.setLayoutData((Object)new RowData(50, -1));
        l = new Label(pane3, 0);
        l.setText("sleeper time scale:");
        this.timeScaleText_ = new Text(pane3, 2052);
        this.timeScaleText_.setText("1.0");
        this.timeScaleText_.setLayoutData((Object)new RowData(50, -1));
    }

    private void stopTasks() {
        if (this.context_ != null) {
            this.context_.stopTasks();
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.stopTasks();
    }
}

