/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views;

import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import jp.hasc.hasctool.core.data.DefaultVectorSignalComparator;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.ui.views.WaveViewWidget;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class VectorView
extends ViewPart {
    private static final int REFRESH_DELAY_MS = 33;
    public static final String ID = "jp.hasc.hasctool.ui.views.VectorView";
    private Canvas canvas_;
    private Slider slider_;
    private long sliderUnitTime_;
    private Label topLabel_;
    private Display display_;
    private boolean showScale_ = true;
    private ToolBar toolBar_;
    private int signalDataCapacity_ = 65536;
    private NavigableSet<VectorSignalMessage> waveData_ = new TreeSet<VectorSignalMessage>(new DefaultVectorSignalComparator());
    private long viewTime_ = 0L;
    private long waveDataTimeMin_ = 0L;
    private long waveDataTimeMax_ = 0L;
    private double valueMin_ = -2.0;
    private double valueHeight_ = -this.valueMin_ * 2.0;
    private Color[] waveColores_ = new Color[]{new Color(null, 0, 0, 255), new Color(null, 255, 0, 0), new Color(null, 0, 255, 0), new Color(null, 0, 255, 255), new Color(null, 255, 0, 255)};
    private boolean requestedUpdateTimeRangeAndRedraw = false;
    private boolean requestedRedraw_ = false;
    private MessageProcessor inputPort_ = new MessageProcessor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processMessage(Object message) {
            block4: {
                if (message instanceof VectorSignalMessage) {
                    VectorSignalMessage we = (VectorSignalMessage)message;
                    NavigableSet navigableSet = VectorView.this.waveData_;
                    synchronized (navigableSet) {
                        VectorView.this.waveData_.add(we);
                        VectorView.this.requestUpdateTimeRangeAndRedraw();
                    }
                }
                if (message != SignalMessage.BEGIN) break block4;
                VectorView.this.clearWaveData();
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.display_ = parent.getDisplay();
        parent.setLayout((Layout)new FormLayout());
        this.toolBar_ = new ToolBar(parent, 512);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.right = new FormAttachment(100, -1);
        fd.bottom = new FormAttachment(100, -1);
        this.toolBar_.setLayoutData((Object)fd);
        ToolItem ti = new ToolItem(this.toolBar_, 0);
        ti.setText("+v");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VectorView.this.setValueHeight(VectorView.this.getValueHeight() / 2.0);
                VectorView.this.setValueMin(VectorView.this.getValueMin() / 2.0);
                VectorView.this.requestRedraw();
            }
        });
        ti = new ToolItem(this.toolBar_, 0);
        ti.setText("-v");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VectorView.this.setValueHeight(VectorView.this.getValueHeight() * 2.0);
                VectorView.this.setValueMin(VectorView.this.getValueMin() * 2.0);
                VectorView.this.requestRedraw();
            }
        });
        this.topLabel_ = new Label(parent, 64);
        fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.left = new FormAttachment(0, 1);
        fd.right = new FormAttachment((Control)this.toolBar_, -1);
        this.topLabel_.setLayoutData((Object)fd);
        this.slider_ = new Slider(parent, 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment(100, -1);
        fd.right = new FormAttachment((Control)this.toolBar_, -1);
        this.sliderUnitTime_ = SignalMessage.TIME_UNIT.convert(1L, TimeUnit.MILLISECONDS);
        this.slider_.setLayoutData((Object)fd);
        this.slider_.setMinimum(0);
        this.slider_.setIncrement(10);
        this.slider_.addSelectionListener(new SelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                NavigableSet navigableSet = VectorView.this.waveData_;
                synchronized (navigableSet) {
                    if (!VectorView.this.waveData_.isEmpty()) {
                        int pos = VectorView.this.slider_.getSelection() + VectorView.this.slider_.getThumb();
                        VectorView.this.viewTime_ = (long)pos * VectorView.this.sliderUnitTime_ + VectorView.this.waveDataTimeMin_;
                    }
                }
                VectorView.this.doRedraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.canvas_ = new Canvas(parent, 0x20000800);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.topLabel_, 1);
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment((Control)this.slider_, -1);
        fd.right = new FormAttachment((Control)this.toolBar_, -1);
        this.canvas_.setLayoutData((Object)fd);
        this.canvas_.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                VectorView.this.onCanvasPaint(e);
            }
        });
        this.clearWaveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCanvasPaint(PaintEvent e) {
        this.requestedRedraw_ = false;
        GC gc = e.gc;
        Point csize = this.canvas_.getSize();
        int cw = csize.x - this.canvas_.getBorderWidth();
        int ch = csize.y - this.canvas_.getBorderWidth();
        gc.setBackground(new Color(null, 255, 255, 255));
        gc.fillRectangle(0, 0, cw, ch);
        gc.setForeground(new Color(null, 0, 0, 0));
        int zeroy = this.getWaveY(0.0, ch);
        gc.drawLine(0, zeroy, cw, zeroy);
        VectorSignalMessage last = null;
        NavigableSet<VectorSignalMessage> navigableSet = this.waveData_;
        synchronized (navigableSet) {
            if (this.waveData_.isEmpty()) {
            } else {
                last = this.waveData_.ceiling(VectorSignalMessages.createEmpty(this.viewTime_ + 1L));
                if (last == null) {
                    last = (VectorSignalMessage)this.waveData_.last();
                }
                int prevX = 0;
                int prevY = 0;
                Color color = this.waveColores_[0];
                gc.setForeground(color);
                gc.setBackground(color);
                VectorSignalMessage elem = last;
                int vectorSize = elem.getVectorSize();
                int idx = 0;
                while (idx < vectorSize) {
                    int x = this.getWaveX(idx, vectorSize, cw);
                    int y = this.getWaveY(elem.getVectorElement(idx), ch);
                    if (idx != 0) {
                        gc.drawLine(prevX, prevY, x, y);
                    }
                    gc.fillRectangle(x - 1, y - 1, 3, 3);
                    prevX = x;
                    prevY = y;
                    ++idx;
                }
            }
        }
        if (this.isShowScale()) {
            double valueMax;
            gc.setForeground(new Color(null, 0, 0, 0));
            FontMetrics fm = gc.getFontMetrics();
            if (last != null) {
                String s = "t=" + WaveViewWidget.getTimeString(last.getTime());
                gc.drawText(s, cw - gc.stringExtent((String)s).x - 4, 0, true);
            }
            if ((valueMax = this.valueMin_ + this.valueHeight_) != 0.0) {
                gc.drawText("" + valueMax, 0, 0, true);
            }
            if (this.valueMin_ != 0.0) {
                gc.drawText("" + this.valueMin_, 0, ch - fm.getHeight(), true);
            }
            gc.setForeground(new Color(null, 0, 0, 0));
            gc.setBackground(new Color(null, 255, 255, 255));
        }
    }

    private int getWaveX(int idx, int vectorSize, int canvasWidth) {
        int w = canvasWidth - 20;
        if (vectorSize > 1) {
            return 10 + w * idx / (vectorSize - 1);
        }
        return 10 + w / 2;
    }

    private int getWaveY(double d, int canvasHeight) {
        int h = canvasHeight - 3;
        return 1 + (int)((double)h - (double)h * (d - this.valueMin_) / this.valueHeight_);
    }

    public void setFocus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequestedUpdateTimeRange() {
        NavigableSet<VectorSignalMessage> navigableSet = this.waveData_;
        synchronized (navigableSet) {
            if (!this.waveData_.isEmpty()) {
                int trimmingNum = this.waveData_.size() - this.signalDataCapacity_;
                if (trimmingNum > 0) {
                    Iterator<VectorSignalMessage> it = this.waveData_.iterator();
                    while (it.hasNext() && trimmingNum > 0) {
                        it.next();
                        it.remove();
                        --trimmingNum;
                    }
                }
                boolean followSlider = true;
                this.waveDataTimeMin_ = ((VectorSignalMessage)this.waveData_.first()).getTime();
                this.waveDataTimeMax_ = ((VectorSignalMessage)this.waveData_.last()).getTime();
                if (followSlider) {
                    this.viewTime_ = this.waveDataTimeMax_;
                }
            }
        }
        if (!this.slider_.isDisposed()) {
            this.slider_.setMaximum((int)((this.waveDataTimeMax_ - this.waveDataTimeMin_) / this.sliderUnitTime_));
            this.slider_.setThumb(0);
            this.slider_.setSelection((int)((this.viewTime_ - this.waveDataTimeMin_) / this.sliderUnitTime_) - this.slider_.getThumb());
        }
    }

    private void requestUpdateTimeRangeAndRedraw() {
        if (this.requestedUpdateTimeRangeAndRedraw) {
            return;
        }
        this.requestedUpdateTimeRangeAndRedraw = true;
        this.asyncTimerExec(33, new Runnable(){

            @Override
            public void run() {
                VectorView.this.requestedUpdateTimeRangeAndRedraw = false;
                VectorView.this.doRequestedUpdateTimeRange();
                VectorView.this.doRedraw();
            }
        });
    }

    private void doRedraw() {
        if (!this.canvas_.isDisposed()) {
            this.canvas_.redraw();
        }
    }

    public void requestRedraw() {
        if (this.requestedRedraw_) {
            return;
        }
        this.requestedRedraw_ = true;
        this.asyncTimerExec(33, new Runnable(){

            @Override
            public void run() {
                VectorView.this.doRedraw();
            }
        });
    }

    private void asyncTimerExec(final int milliseconds, final Runnable runnable) {
        this.display_.asyncExec(new Runnable(){

            @Override
            public void run() {
                VectorView.this.display_.timerExec(milliseconds, runnable);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWaveData() {
        NavigableSet<VectorSignalMessage> navigableSet = this.waveData_;
        synchronized (navigableSet) {
            this.waveData_.clear();
            this.waveDataTimeMin_ = 0L;
            this.waveDataTimeMax_ = 0L;
            this.viewTime_ = 0L;
            this.requestUpdateTimeRangeAndRedraw();
        }
    }

    public MessageProcessor getInputPort() {
        return this.inputPort_;
    }

    private void onInit(IViewSite site) {
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.onInit(site);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.onInit(site);
    }

    public int getSignalDataCapacity() {
        return this.signalDataCapacity_;
    }

    public void setSignalDataCapacity(int signalDataCapacity) {
        this.signalDataCapacity_ = signalDataCapacity;
    }

    public double getValueMin() {
        return this.valueMin_;
    }

    public void setValueMin(double valueMin) {
        this.valueMin_ = valueMin;
    }

    public double getValueHeight() {
        return this.valueHeight_;
    }

    public void setValueHeight(double valueHeight) {
        this.valueHeight_ = valueHeight;
    }

    public boolean isShowScale() {
        return this.showScale_;
    }

    public void setShowScale(boolean showScale) {
        this.showScale_ = showScale;
    }

    public void setTitleName(String s) {
        this.topLabel_.setText(s);
    }
}

