/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views;

import java.io.StringReader;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.file.CSVToVectorFilter;
import jp.hasc.hasctool.core.runtime.source.LineReaderSource;
import jp.hasc.hasctool.ui.util.UIUtil;
import jp.hasc.hasctool.ui.views.AbstractWaveEditor;
import jp.hasc.hasctool.ui.views.CharPosLineReaderSource;
import jp.hasc.hasctool.ui.views.WaveViewWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class WaveEditor
extends AbstractWaveEditor {
    private static final Log LOG = LogFactory.getLog(WaveEditor.class);

    @Override
    protected void onUpdateWaveEditorViewContents(String editorText) throws Exception {
        long pos = this.waveViewWidget_.getViewTimeMax();
        this.waveViewWidget_.preventUpdates(true);
        RuntimeContext context = new RuntimeContext();
        LineReaderSource lr = new LineReaderSource();
        lr.setReader(new StringReader(editorText));
        lr.setup(context);
        CSVToVectorFilter csvToVector = new CSVToVectorFilter();
        csvToVector.setup(context);
        lr.getOutputPort().connect(csvToVector.getInputPort());
        csvToVector.getOutputPort().connect(this.waveViewWidget_.getInputPort());
        try {
            lr.runDirect();
        }
        catch (Throwable th) {
            UIUtil.showMessageDialog(this.getSite().getShell(), "[Error]\n" + th.toString());
            LOG.warn((Object)"Throwable", th);
        }
        this.waveViewWidget_.preventUpdates(false);
        this.waveViewWidget_.setViewTimeMax(pos);
    }

    @Override
    protected void createWaveEditorPage() {
        super.createWaveEditorPage();
        final WaveViewWidget wv = this.getWaveViewWidget();
        ToolBar toolBar = wv.getToolBar();
        ToolItem ti = new ToolItem(toolBar, 0);
        ti.setText("?t");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wv.getTimeMarkerBegin() == null) {
                    UIUtil.showMessageDialog(WaveEditor.this.getSite().getShell(), "Please select a time or a time range.");
                    return;
                }
                long t0 = wv.getTimeMarkerBegin();
                long t1 = wv.getTimeMarkerEnd() != null ? wv.getTimeMarkerEnd() : t0;
                SourceViewer tv = (SourceViewer)WaveEditor.this.textEditor_.getAdapter(ITextOperationTarget.class);
                StyledText tw = tv.getTextWidget();
                try {
                    int[] pos = this.searchCharPos(tw, new long[]{t0, t1});
                    tw.setSelection(pos[0], pos[1]);
                }
                catch (Throwable th) {
                    UIUtil.showMessageDialog(WaveEditor.this.getSite().getShell(), "[Error]\n" + th.toString());
                    LOG.warn((Object)"Throwable", th);
                }
                WaveEditor.this.setActivePage(WaveEditor.this.textEditorPageIndex_);
            }

            private int[] searchCharPos(StyledText tw, final long[] ts) throws InterruptedException {
                final int[] result = new int[ts.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = -1;
                    ++i;
                }
                RuntimeContext context = new RuntimeContext();
                final CharPosLineReaderSource lr = new CharPosLineReaderSource();
                lr.setSourceText(tw.getText());
                lr.setup(context);
                CSVToVectorFilter csvToVector = new CSVToVectorFilter();
                csvToVector.setup(context);
                MessageProcessor sink = new MessageProcessor(){

                    @Override
                    public void processMessage(Object message) throws InterruptedException {
                        if (message instanceof VectorSignalMessage) {
                            VectorSignalMessage sig = (VectorSignalMessage)message;
                            int i = 0;
                            while (i < result.length) {
                                if (result[i] == -1 && sig.getTime() >= ts[i]) {
                                    result[i] = lr.getPosCurrentLineBegins();
                                }
                                ++i;
                            }
                        }
                    }
                };
                lr.getOutputPort().connect(csvToVector.getInputPort());
                csvToVector.getOutputPort().connect(sink);
                lr.runDirect();
                int i2 = 0;
                while (i2 < result.length) {
                    if (result[i2] == -1) {
                        result[i2] = tw.getCharCount();
                    }
                    ++i2;
                }
                return result;
            }
        });
    }
}

