/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import jp.hasc.hasctool.core.data.DefaultVectorSignalComparator;
import jp.hasc.hasctool.core.data.LabelInfo;
import jp.hasc.hasctool.core.data.LabelSignalMessage;
import jp.hasc.hasctool.core.data.NullSignalMessage;
import jp.hasc.hasctool.core.data.ObjectSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.AbstractRuntimeBean;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class WaveImageWidget
extends AbstractRuntimeBean {
    private String filePath_;
    private int height_ = 200;
    private int width_ = 600;
    private boolean showScale_ = true;
    private Long timeMarkerBegin_ = null;
    private Long timeMarkerEnd_ = null;
    private NavigableSet<VectorSignalMessage> waveData_ = new TreeSet<VectorSignalMessage>(new DefaultVectorSignalComparator());
    private NavigableSet<LabelSignalMessage> labelData_ = new TreeSet<LabelSignalMessage>();
    private long viewTimeMax_ = 0L;
    private long viewTimeWidth_ = SignalMessage.TIME_UNIT.convert(1000L, TimeUnit.MILLISECONDS);
    private long viewTimeOffset_ = 0L;
    private double valueMin_ = -2.0;
    private double valueMax_ = -2.0;
    private Color[] waveColores_ = new Color[]{new Color(null, 0, 0, 255), new Color(null, 255, 0, 0), new Color(null, 0, 255, 0), new Color(null, 0, 255, 255), new Color(null, 255, 0, 255)};
    private Color[] labelColors_ = new Color[]{new Color(null, 255, 255, 128), new Color(null, 200, 255, 255), new Color(null, 255, 200, 255), new Color(null, 255, 200, 128), new Color(null, 200, 200, 255), new Color(null, 200, 255, 128), new Color(null, 200, 200, 200)};
    private Map<String, Color> labelColorMap_ = new HashMap<String, Color>();
    private MessageProcessor inputPort_ = new MessageProcessor(){

        @Override
        public void processMessage(Object message) {
            if (message instanceof VectorSignalMessage) {
                VectorSignalMessage vecMsg = (VectorSignalMessage)message;
                this.processVectorSignalMessage(vecMsg);
            } else if (message instanceof LabelSignalMessage) {
                this.processLabelMessage((LabelSignalMessage)message);
            } else if (message instanceof ObjectSignalMessage) {
                ObjectSignalMessage osm = (ObjectSignalMessage)message;
                SignalMessage[] sigs = (SignalMessage[])osm.getValue();
                if (sigs.length == 2 && sigs[0] instanceof VectorSignalMessage && sigs[1] instanceof ObjectSignalMessage) {
                    SignalMessage[] lbls;
                    VectorSignalMessage vecMsg = (VectorSignalMessage)sigs[0];
                    this.processVectorSignalMessage(vecMsg);
                    ObjectSignalMessage labelMsgs = (ObjectSignalMessage)sigs[1];
                    SignalMessage[] signalMessageArray = lbls = (SignalMessage[])labelMsgs.getValue();
                    int n = lbls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SignalMessage lbl = signalMessageArray[n2];
                        if (lbl instanceof LabelSignalMessage) {
                            this.processLabelMessage((LabelSignalMessage)lbl);
                        } else {
                            boolean cfr_ignored_0 = lbl instanceof NullSignalMessage;
                        }
                        ++n2;
                    }
                }
            } else if (message != SignalMessage.BEGIN && message == SignalMessage.END) {
                WaveImageWidget.this.imageCapture();
            }
        }

        private void processLabelMessage(LabelSignalMessage lbl) {
            WaveImageWidget.this.labelData_.add(lbl);
        }

        private void processVectorSignalMessage(VectorSignalMessage we) {
            WaveImageWidget.this.waveData_.add(we);
        }
    };

    public static double timeToSecond(Long time) {
        return (double)SignalMessage.TIME_UNIT.toMillis(time) / 1000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image onCanvasPaint(Image img) {
        Object last;
        GC gc = new GC((Drawable)img);
        gc.setBackground(new Color(null, 255, 255, 255));
        gc.fillRectangle(0, 0, this.width_, this.height_);
        NavigableSet<LabelSignalMessage> labels = null;
        NavigableSet<LabelSignalMessage> navigableSet = this.labelData_;
        synchronized (navigableSet) {
            if (!this.labelData_.isEmpty()) {
                LabelSignalMessage first = this.labelData_.lower(LabelSignalMessage.createEmpty(this.viewTimeMax_ - this.viewTimeWidth_));
                if (first == null) {
                    first = (LabelSignalMessage)this.labelData_.first();
                }
                if ((last = this.labelData_.ceiling(LabelSignalMessage.createEmpty(this.viewTimeMax_ + 1L))) == null) {
                    last = (LabelSignalMessage)this.labelData_.last();
                }
                labels = this.labelData_.subSet(first, true, (LabelSignalMessage)last, true);
            }
        }
        if (labels != null) {
            HashMap<LabelInfo, LabelSignalMessage> beginSigs = new HashMap<LabelInfo, LabelSignalMessage>();
            for (LabelSignalMessage lblSig : labels) {
                gc.setBackground(this.getLabelBgColor(lblSig.getLabelInfo()));
                switch (lblSig.getType()) {
                    case BEGIN: {
                        beginSigs.put(lblSig.getLabelInfo(), lblSig);
                        break;
                    }
                    case END: {
                        LabelSignalMessage beginSig = (LabelSignalMessage)beginSigs.get(lblSig.getLabelInfo());
                        int x0 = 0;
                        int x1 = this.getWaveX(lblSig.getTime(), this.width_);
                        if (beginSig != null) {
                            beginSigs.remove(lblSig.getLabelInfo());
                            x0 = this.getWaveX(beginSig.getTime(), this.width_);
                        }
                        gc.fillRectangle(x0, 0, x1 - x0, this.height_);
                    }
                }
            }
            last = beginSigs.values().iterator();
            while (last.hasNext()) {
                LabelSignalMessage beginSig = (LabelSignalMessage)last.next();
                gc.setBackground(this.getLabelBgColor(beginSig.getLabelInfo()));
                int x0 = this.getWaveX(beginSig.getTime(), this.width_);
                gc.fillRectangle(x0, 0, this.width_ - x0, this.height_);
            }
            beginSigs.clear();
        }
        gc.setBackground(new Color(null, 200, 200, 200));
        if (this.timeMarkerBegin_ != null && this.timeMarkerEnd_ != null) {
            int x0 = this.getWaveX(this.timeMarkerBegin_, this.width_);
            int x1 = this.getWaveX(this.timeMarkerEnd_, this.width_);
            gc.fillRectangle(x0, 0, x1 - x0, this.height_);
        }
        NavigableSet<VectorSignalMessage> x0 = this.waveData_;
        synchronized (x0) {
            if (this.waveData_.isEmpty()) {
            } else {
                VectorSignalMessage first = this.waveData_.lower(VectorSignalMessages.createEmpty(this.viewTimeMax_ - this.viewTimeWidth_));
                if (first == null) {
                    first = (VectorSignalMessage)this.waveData_.first();
                }
                if ((last = this.waveData_.ceiling(VectorSignalMessages.createEmpty(this.viewTimeMax_ + 1L))) == null) {
                    last = (VectorSignalMessage)this.waveData_.last();
                }
                int maxVectorSize = 1;
                int idx = 0;
                while (idx < maxVectorSize) {
                    VectorSignalMessage prevElem = null;
                    int prevX = 0;
                    int prevY = 0;
                    Color color = this.waveColores_[idx % this.waveColores_.length];
                    gc.setForeground(color);
                    gc.setBackground(color);
                    for (VectorSignalMessage elem : this.waveData_.subSet(first, true, (VectorSignalMessage)last, true)) {
                        int vsize = elem.getVectorSize();
                        if (vsize <= idx) continue;
                        if (maxVectorSize < vsize) {
                            maxVectorSize = vsize;
                        }
                        int x = this.getWaveX(elem.getTime(), this.width_);
                        int y = this.getWaveY(elem.getVectorElement(idx), this.height_);
                        if (prevElem != null) {
                            gc.drawLine(prevX, prevY, x, y);
                        }
                        gc.fillRectangle(x - 1, y - 1, 3, 3);
                        prevElem = elem;
                        prevX = x;
                        prevY = y;
                    }
                    ++idx;
                }
            }
        }
        gc.setForeground(new Color(null, 0, 0, 0));
        int zeroy = this.getWaveY(0.0, this.height_);
        gc.drawLine(0, zeroy, this.width_, zeroy);
        if (this.isShowScale()) {
            gc.setForeground(new Color(null, 0, 0, 0));
            FontMetrics fm = gc.getFontMetrics();
            String s = WaveImageWidget.getTimeString(this.viewTimeMax_ - this.viewTimeWidth_ - this.viewTimeOffset_);
            int zeroty = zeroy + 1;
            gc.drawText(s, 0, zeroty, true);
            s = WaveImageWidget.getTimeString(this.viewTimeMax_ - this.viewTimeOffset_);
            gc.drawText(s, this.width_ - gc.stringExtent((String)s).x - 4, zeroty, true);
            if (this.valueMax_ != 0.0) {
                gc.drawText("" + this.valueMax_, 0, 0, true);
            }
            if (this.valueMin_ != 0.0) {
                gc.drawText("" + this.valueMin_, 0, this.height_ - fm.getHeight(), true);
            }
        }
        if (labels != null) {
            gc.setForeground(new Color(null, 0, 0, 0));
            for (LabelSignalMessage lblSig : labels) {
                gc.setBackground(this.getLabelBgColor(lblSig.getLabelInfo()));
                int x1 = this.getWaveX(lblSig.getTime(), this.width_);
                int h = gc.getFontMetrics().getHeight() + 4;
                gc.drawLine(x1, 0, x1, this.height_);
                String lblStr = lblSig.getLabelInfo().getLabel();
                switch (lblSig.getType()) {
                    case BEGIN: {
                        gc.drawText(lblStr, x1 + 2, this.height_ - h + 2, false);
                        break;
                    }
                    case END: {
                        int w = gc.stringExtent((String)lblStr).x;
                        gc.drawText(lblStr, x1 - 2 - w, this.height_ - h + 2, false);
                    }
                }
            }
        }
        return img;
    }

    private Color getLabelBgColor(LabelInfo labelInfo) {
        String lblstr = labelInfo.getLabel();
        Color c = this.labelColorMap_.get(lblstr);
        if (c != null) {
            return c;
        }
        c = this.labelColors_[this.labelColorMap_.size() % this.labelColors_.length];
        this.labelColorMap_.put(lblstr, c);
        return c;
    }

    public static String getTimeString(long t) {
        return String.valueOf((float)TimeUnit.MILLISECONDS.convert(t, SignalMessage.TIME_UNIT) / 1000.0f) + "s";
    }

    private int getWaveX(long time, int canvasWidth) {
        int w = canvasWidth - 3;
        return 1 + (int)((long)w + (long)w * (time - this.viewTimeMax_) / this.viewTimeWidth_);
    }

    private int getWaveY(double d, int canvasHeight) {
        int h = canvasHeight - 3;
        return 1 + (int)((double)h - (double)h * (d - this.valueMin_) / (this.valueMax_ - this.valueMin_));
    }

    private void imageCapture() {
        Display display = new Display();
        Image image = new Image((Device)display, this.width_, this.height_);
        image = this.onCanvasPaint(image);
        ImageData data = image.getImageData();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{data};
        OutputStream outs = this.getRuntimeContext().getFileStreamProvider().openOutputStream(this.filePath_);
        loader.save(outs, 5);
        try {
            outs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        display.dispose();
    }

    public MessageProcessor getInputPort() {
        return this.inputPort_;
    }

    public boolean isShowScale() {
        return this.showScale_;
    }

    public void setFilePath(String filePath) {
        this.filePath_ = filePath;
    }

    public void setViewTimeMax(long viewTimeMax) {
        this.viewTimeMax_ = viewTimeMax;
    }

    public void setViewTimeWidth(long viewTimeWidth) {
        this.viewTimeWidth_ = viewTimeWidth;
    }

    public void setMaxValue(double maxValue) {
        this.valueMax_ = maxValue;
    }

    public void setMinValue(double minValue) {
        this.valueMin_ = minValue;
    }
}

