/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import jp.hasc.hasctool.core.data.DefaultVectorSignalComparator;
import jp.hasc.hasctool.core.data.LabelInfo;
import jp.hasc.hasctool.core.data.LabelSignalMessage;
import jp.hasc.hasctool.core.data.NullSignalMessage;
import jp.hasc.hasctool.core.data.ObjectSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessages;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.util.CoreUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class WaveViewWidget
extends Composite {
    private static final Log LOG = LogFactory.getLog(WaveViewWidget.class);
    private static final int REFRESH_DELAY_MS = 33;
    private Canvas canvas_;
    private Slider slider_;
    private long sliderUnitTime_;
    private Label topLabel_;
    private Link timeLabel_;
    private ToolBar toolBar_;
    private boolean showScale_ = true;
    private Long timeMarkerBegin_ = null;
    private Long timeMarkerEnd_ = null;
    private int signalDataCapacity_ = -1;
    private NavigableSet<VectorSignalMessage> waveData_ = new TreeSet<VectorSignalMessage>(new DefaultVectorSignalComparator());
    private NavigableSet<LabelSignalMessage> labelData_ = new TreeSet<LabelSignalMessage>();
    private long viewTimeMax_ = 0L;
    private long viewTimeWidth_ = SignalMessage.TIME_UNIT.convert(1000L, TimeUnit.MILLISECONDS);
    private long viewTimeOffset_ = 0L;
    private long waveDataTimeMin_ = 0L;
    private long waveDataTimeMax_ = 0L;
    private double valueMin_ = -2.0;
    private double valueHeight_ = -this.valueMin_ * 2.0;
    private Color[] waveColores_ = new Color[]{new Color(null, 0, 0, 255), new Color(null, 255, 0, 0), new Color(null, 0, 255, 0), new Color(null, 0, 255, 255), new Color(null, 255, 0, 255)};
    private Color[] labelColors_ = new Color[]{new Color(null, 255, 255, 128), new Color(null, 200, 255, 255), new Color(null, 255, 200, 255), new Color(null, 255, 200, 128), new Color(null, 200, 200, 255), new Color(null, 200, 255, 128), new Color(null, 200, 200, 200)};
    private Map<String, Color> labelColorMap_ = new HashMap<String, Color>();
    private boolean requestedUpdateTimeRangeAndRedraw = false;
    private boolean requestedRedraw_ = false;
    private boolean followSlider_ = true;
    private MessageProcessor inputPort_ = new MessageProcessor(){

        @Override
        public void processMessage(Object message) {
            if (message instanceof VectorSignalMessage) {
                VectorSignalMessage vecMsg = (VectorSignalMessage)message;
                this.processVectorSignalMessage(vecMsg);
            } else if (message instanceof LabelSignalMessage) {
                this.processLabelMessage((LabelSignalMessage)message);
            } else if (message instanceof ObjectSignalMessage) {
                ObjectSignalMessage osm = (ObjectSignalMessage)message;
                SignalMessage[] sigs = (SignalMessage[])osm.getValue();
                if (sigs.length == 2 && sigs[0] instanceof VectorSignalMessage && sigs[1] instanceof ObjectSignalMessage) {
                    SignalMessage[] lbls;
                    VectorSignalMessage vecMsg = (VectorSignalMessage)sigs[0];
                    this.processVectorSignalMessage(vecMsg);
                    ObjectSignalMessage labelMsgs = (ObjectSignalMessage)sigs[1];
                    SignalMessage[] signalMessageArray = lbls = (SignalMessage[])labelMsgs.getValue();
                    int n = lbls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SignalMessage lbl = signalMessageArray[n2];
                        if (lbl instanceof LabelSignalMessage) {
                            this.processLabelMessage((LabelSignalMessage)lbl);
                        } else if (!(lbl instanceof NullSignalMessage)) {
                            LOG.warn((Object)("Unknown signal:" + lbl));
                        }
                        ++n2;
                    }
                }
            } else if (message == SignalMessage.BEGIN) {
                WaveViewWidget.this.clearData(WaveViewWidget.this.clearingDataWhenBeginMessage_);
            } else if (message == SignalMessage.END) {
                LOG.debug((Object)"got END message.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processLabelMessage(LabelSignalMessage lbl) {
            NavigableSet navigableSet = WaveViewWidget.this.labelData_;
            synchronized (navigableSet) {
                WaveViewWidget.this.labelData_.add(lbl);
                WaveViewWidget.this.requestUpdateTimeRangeAndRedraw();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processVectorSignalMessage(VectorSignalMessage we) {
            NavigableSet navigableSet = WaveViewWidget.this.waveData_;
            synchronized (navigableSet) {
                WaveViewWidget.this.waveData_.add(we);
                WaveViewWidget.this.requestUpdateTimeRangeAndRedraw();
            }
        }
    };
    public static final int DATA_BIT_LABEL = 2;
    public static final int DATA_BIT_WAVE = 1;
    public static final int DATA_BITS_ALL = 3;
    private int clearingDataWhenBeginMessage_ = 3;

    public WaveViewWidget(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.toolBar_ = new ToolBar((Composite)this, 512);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.right = new FormAttachment(100, -1);
        fd.bottom = new FormAttachment(100, -1);
        this.toolBar_.setLayoutData((Object)fd);
        ToolItem ti = new ToolItem(this.toolBar_, 0);
        ti.setText("+t");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long pos = WaveViewWidget.this.getViewTimeMax();
                WaveViewWidget.this.setViewTimeWidth(WaveViewWidget.this.getViewTimeWidth() / 2L);
                WaveViewWidget.this.doRequestedUpdateTimeRange();
                WaveViewWidget.this.setViewTimeMax(pos);
                WaveViewWidget.this.doRedraw();
            }
        });
        ti = new ToolItem(this.toolBar_, 0);
        ti.setText("-t");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long pos = WaveViewWidget.this.getViewTimeMax();
                WaveViewWidget.this.setViewTimeWidth(WaveViewWidget.this.getViewTimeWidth() * 2L);
                WaveViewWidget.this.doRequestedUpdateTimeRange();
                WaveViewWidget.this.setViewTimeMax(pos);
                WaveViewWidget.this.doRedraw();
            }
        });
        ti = new ToolItem(this.toolBar_, 0);
        ti.setText("+v");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewWidget.this.setValueHeight(WaveViewWidget.this.getValueHeight() / 2.0);
                WaveViewWidget.this.setValueMin(WaveViewWidget.this.getValueMin() / 2.0);
                WaveViewWidget.this.requestRedraw();
            }
        });
        ti = new ToolItem(this.toolBar_, 0);
        ti.setText("-v");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewWidget.this.setValueHeight(WaveViewWidget.this.getValueHeight() * 2.0);
                WaveViewWidget.this.setValueMin(WaveViewWidget.this.getValueMin() * 2.0);
                WaveViewWidget.this.requestRedraw();
            }
        });
        ti = new ToolItem(this.toolBar_, 0);
        ti.setText("rt");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WaveViewWidget.this.viewTimeOffset_ == 0L) {
                    WaveViewWidget.this.viewTimeOffset_ = WaveViewWidget.this.waveDataTimeMin_;
                } else {
                    WaveViewWidget.this.viewTimeOffset_ = 0L;
                }
                WaveViewWidget.this.requestRedraw();
            }
        });
        this.topLabel_ = new Label((Composite)this, 64);
        fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.left = new FormAttachment(0, 1);
        fd.right = new FormAttachment(70, -1);
        this.topLabel_.setLayoutData((Object)fd);
        this.timeLabel_ = new Link((Composite)this, 64);
        fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.left = new FormAttachment((Control)this.topLabel_, 1);
        fd.right = new FormAttachment((Control)this.toolBar_, -1);
        this.timeLabel_.setText("time:");
        this.timeLabel_.setLayoutData((Object)fd);
        this.timeLabel_.addSelectionListener((SelectionListener)new CopyLinkSelectionListener());
        this.slider_ = new Slider((Composite)this, 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment(100, -1);
        fd.right = new FormAttachment((Control)this.toolBar_, -1);
        this.sliderUnitTime_ = SignalMessage.TIME_UNIT.convert(1L, TimeUnit.MILLISECONDS);
        this.slider_.setLayoutData((Object)fd);
        this.slider_.setMinimum(0);
        this.slider_.setIncrement(10);
        this.slider_.addSelectionListener(new SelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                NavigableSet navigableSet = WaveViewWidget.this.waveData_;
                synchronized (navigableSet) {
                    NavigableSet navigableSet2 = WaveViewWidget.this.labelData_;
                    synchronized (navigableSet2) {
                        int pos = WaveViewWidget.this.slider_.getSelection() + WaveViewWidget.this.slider_.getThumb();
                        WaveViewWidget.this.viewTimeMax_ = (long)pos * WaveViewWidget.this.sliderUnitTime_ + WaveViewWidget.this.waveDataTimeMin_;
                    }
                }
                WaveViewWidget.this.doRedraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.canvas_ = new Canvas((Composite)this, 0x20000800);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.topLabel_, 1);
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment((Control)this.slider_, -1);
        fd.right = new FormAttachment((Control)this.toolBar_, -1);
        this.canvas_.setLayoutData((Object)fd);
        this.canvas_.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                WaveViewWidget.this.onCanvasPaint(e);
            }
        });
        this.canvas_.addMouseListener(new MouseListener(){
            int downX_;
            int downY_;

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && (Math.abs(this.downX_ - e.x) > 2 || Math.abs(this.downY_ - e.y) > 2)) {
                    WaveViewWidget.this.timeMarkerEnd_ = WaveViewWidget.this.getTimeAtCanvasX(e.x, WaveViewWidget.this.getCanvasWidth());
                    if (WaveViewWidget.this.timeMarkerEnd_ < WaveViewWidget.this.timeMarkerBegin_) {
                        Long tmp = WaveViewWidget.this.timeMarkerBegin_;
                        WaveViewWidget.this.timeMarkerBegin_ = WaveViewWidget.this.timeMarkerEnd_;
                        WaveViewWidget.this.timeMarkerEnd_ = tmp;
                    }
                    WaveViewWidget.this.timeLabel_.setText("time:<a>" + (WaveViewWidget.this.viewTimeOffset_ != 0L ? "r " : "") + WaveViewWidget.timeToSecond(WaveViewWidget.this.timeMarkerBegin_ - WaveViewWidget.this.viewTimeOffset_) + "," + WaveViewWidget.timeToSecond(WaveViewWidget.this.timeMarkerEnd_ - WaveViewWidget.this.viewTimeOffset_) + "</a>");
                    WaveViewWidget.this.requestRedraw();
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.downX_ = e.x;
                    this.downY_ = e.y;
                    WaveViewWidget.this.timeMarkerBegin_ = WaveViewWidget.this.getTimeAtCanvasX(this.downX_, WaveViewWidget.this.getCanvasWidth());
                    WaveViewWidget.this.timeMarkerEnd_ = null;
                    WaveViewWidget.this.timeLabel_.setText("time:<a>" + (WaveViewWidget.this.viewTimeOffset_ != 0L ? "r " : "") + WaveViewWidget.timeToSecond(WaveViewWidget.this.timeMarkerBegin_ - WaveViewWidget.this.viewTimeOffset_) + "</a>");
                    WaveViewWidget.this.requestRedraw();
                } else {
                    WaveViewWidget.this.timeMarkerEnd_ = null;
                    WaveViewWidget.this.timeMarkerBegin_ = null;
                    WaveViewWidget.this.timeLabel_.setText("time:");
                    WaveViewWidget.this.requestRedraw();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.clearData(3);
    }

    public static double timeToSecond(Long time) {
        return (double)SignalMessage.TIME_UNIT.toMillis(time) / 1000.0;
    }

    private int getCanvasWidth() {
        return this.canvas_.getSize().x - this.canvas_.getBorderWidth() * 2;
    }

    private int getCanvasHeight() {
        return this.canvas_.getSize().y - this.canvas_.getBorderWidth() * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCanvasPaint(PaintEvent e) {
        Object last;
        this.requestedRedraw_ = false;
        GC gc = e.gc;
        int cw = this.getCanvasWidth();
        int ch = this.getCanvasHeight();
        gc.setBackground(new Color(null, 255, 255, 255));
        gc.fillRectangle(0, 0, cw, ch);
        NavigableSet<LabelSignalMessage> labels = null;
        NavigableSet<LabelSignalMessage> navigableSet = this.labelData_;
        synchronized (navigableSet) {
            if (!this.labelData_.isEmpty()) {
                LabelSignalMessage first = this.labelData_.lower(LabelSignalMessage.createEmpty(this.viewTimeMax_ - this.viewTimeWidth_));
                if (first == null) {
                    first = (LabelSignalMessage)this.labelData_.first();
                }
                if ((last = this.labelData_.ceiling(LabelSignalMessage.createEmpty(this.viewTimeMax_ + 1L))) == null) {
                    last = (LabelSignalMessage)this.labelData_.last();
                }
                labels = this.labelData_.subSet(first, true, (LabelSignalMessage)last, true);
            }
        }
        if (labels != null) {
            HashMap<LabelInfo, LabelSignalMessage> beginSigs = new HashMap<LabelInfo, LabelSignalMessage>();
            for (LabelSignalMessage lblSig : labels) {
                gc.setBackground(this.getLabelBgColor(lblSig.getLabelInfo()));
                switch (lblSig.getType()) {
                    case BEGIN: {
                        beginSigs.put(lblSig.getLabelInfo(), lblSig);
                        break;
                    }
                    case END: {
                        LabelSignalMessage beginSig = (LabelSignalMessage)beginSigs.get(lblSig.getLabelInfo());
                        int x0 = 0;
                        int x1 = this.getWaveX(lblSig.getTime(), cw);
                        if (beginSig != null) {
                            beginSigs.remove(lblSig.getLabelInfo());
                            x0 = this.getWaveX(beginSig.getTime(), cw);
                        }
                        gc.fillRectangle(x0, 0, x1 - x0, ch);
                    }
                }
            }
            last = beginSigs.values().iterator();
            while (last.hasNext()) {
                LabelSignalMessage beginSig = (LabelSignalMessage)last.next();
                gc.setBackground(this.getLabelBgColor(beginSig.getLabelInfo()));
                int x0 = this.getWaveX(beginSig.getTime(), cw);
                gc.fillRectangle(x0, 0, cw - x0, ch);
            }
            beginSigs.clear();
        }
        gc.setBackground(new Color(null, 200, 200, 200));
        if (this.timeMarkerBegin_ != null && this.timeMarkerEnd_ != null) {
            int x0 = this.getWaveX(this.timeMarkerBegin_, cw);
            int x1 = this.getWaveX(this.timeMarkerEnd_, cw);
            gc.fillRectangle(x0, 0, x1 - x0, ch);
        }
        NavigableSet<VectorSignalMessage> x0 = this.waveData_;
        synchronized (x0) {
            if (this.waveData_.isEmpty()) {
            } else {
                VectorSignalMessage first = this.waveData_.lower(VectorSignalMessages.createEmpty(this.viewTimeMax_ - this.viewTimeWidth_));
                if (first == null) {
                    first = (VectorSignalMessage)this.waveData_.first();
                }
                if ((last = this.waveData_.ceiling(VectorSignalMessages.createEmpty(this.viewTimeMax_ + 1L))) == null) {
                    last = (VectorSignalMessage)this.waveData_.last();
                }
                int maxVectorSize = 1;
                int idx = 0;
                while (idx < maxVectorSize) {
                    VectorSignalMessage prevElem = null;
                    int prevX = 0;
                    int prevY = 0;
                    Color color = this.waveColores_[idx % this.waveColores_.length];
                    gc.setForeground(color);
                    gc.setBackground(color);
                    for (VectorSignalMessage elem : this.waveData_.subSet(first, true, (VectorSignalMessage)last, true)) {
                        int vsize = elem.getVectorSize();
                        if (vsize <= idx) continue;
                        if (maxVectorSize < vsize) {
                            maxVectorSize = vsize;
                        }
                        int x = this.getWaveX(elem.getTime(), cw);
                        int y = this.getWaveY(elem.getVectorElement(idx), ch);
                        if (prevElem != null) {
                            gc.drawLine(prevX, prevY, x, y);
                        }
                        gc.fillRectangle(x - 1, y - 1, 3, 3);
                        prevElem = elem;
                        prevX = x;
                        prevY = y;
                    }
                    ++idx;
                }
            }
        }
        gc.setForeground(new Color(null, 0, 0, 0));
        int zeroy = this.getWaveY(0.0, ch);
        gc.drawLine(0, zeroy, cw, zeroy);
        if (this.isShowScale()) {
            gc.setForeground(new Color(null, 0, 0, 0));
            FontMetrics fm = gc.getFontMetrics();
            String s = WaveViewWidget.getTimeString(this.viewTimeMax_ - this.viewTimeWidth_ - this.viewTimeOffset_);
            int zeroty = zeroy + 1;
            gc.drawText(s, 0, zeroty, true);
            s = WaveViewWidget.getTimeString(this.viewTimeMax_ - this.viewTimeOffset_);
            gc.drawText(s, cw - gc.stringExtent((String)s).x - 4, zeroty, true);
            double valueMax = this.valueMin_ + this.valueHeight_;
            if (valueMax != 0.0) {
                gc.drawText("" + valueMax, 0, 0, true);
            }
            if (this.valueMin_ != 0.0) {
                gc.drawText("" + this.valueMin_, 0, ch - fm.getHeight(), true);
            }
        }
        if (labels != null) {
            gc.setForeground(new Color(null, 0, 0, 0));
            for (LabelSignalMessage lblSig : labels) {
                gc.setBackground(this.getLabelBgColor(lblSig.getLabelInfo()));
                int x1 = this.getWaveX(lblSig.getTime(), cw);
                int h = gc.getFontMetrics().getHeight() + 4;
                gc.drawLine(x1, 0, x1, ch);
                String lblStr = lblSig.getLabelInfo().getLabel();
                switch (lblSig.getType()) {
                    case BEGIN: {
                        gc.drawText(lblStr, x1 + 2, ch - h + 2, false);
                        break;
                    }
                    case END: {
                        int w = gc.stringExtent((String)lblStr).x;
                        gc.drawText(lblStr, x1 - 2 - w, ch - h + 2, false);
                    }
                }
            }
        }
        gc.setForeground(new Color(null, 64, 64, 128));
        if (this.timeMarkerBegin_ != null) {
            int x = this.getWaveX(this.timeMarkerBegin_, cw);
            gc.drawLine(x, 0, x, ch);
        }
        if (this.timeMarkerEnd_ != null) {
            int x = this.getWaveX(this.timeMarkerEnd_, cw);
            gc.drawLine(x, 0, x, ch);
        }
    }

    private Color getLabelBgColor(LabelInfo labelInfo) {
        String lblstr = labelInfo.getLabel();
        Color c = this.labelColorMap_.get(lblstr);
        if (c != null) {
            return c;
        }
        c = this.labelColors_[this.labelColorMap_.size() % this.labelColors_.length];
        this.labelColorMap_.put(lblstr, c);
        return c;
    }

    public static String getTimeString(long t) {
        return String.valueOf((float)TimeUnit.MILLISECONDS.convert(t, SignalMessage.TIME_UNIT) / 1000.0f) + "s";
    }

    private long getTimeAtCanvasX(int x, int canvasWidth) {
        int w = canvasWidth - 3;
        return (long)(x - 1 - w) * this.viewTimeWidth_ / (long)w + this.viewTimeMax_;
    }

    private int getWaveX(long time, int canvasWidth) {
        int w = canvasWidth - 3;
        return 1 + (int)((long)w + (long)w * (time - this.viewTimeMax_) / this.viewTimeWidth_);
    }

    private int getWaveY(double d, int canvasHeight) {
        int h = canvasHeight - 3;
        return 1 + (int)((double)h - (double)h * (d - this.valueMin_) / this.valueHeight_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequestedUpdateTimeRange() {
        NavigableSet<SignalMessage> navigableSet = this.waveData_;
        synchronized (navigableSet) {
            if (!this.waveData_.isEmpty()) {
                int trimmingNum;
                if (this.signalDataCapacity_ >= 0 && (trimmingNum = this.waveData_.size() - this.signalDataCapacity_) > 0) {
                    Iterator<VectorSignalMessage> it = this.waveData_.iterator();
                    while (it.hasNext() && trimmingNum > 0) {
                        it.next();
                        it.remove();
                        --trimmingNum;
                    }
                }
                this.waveDataTimeMin_ = ((VectorSignalMessage)this.waveData_.first()).getTime();
                this.waveDataTimeMax_ = ((VectorSignalMessage)this.waveData_.last()).getTime();
            }
        }
        navigableSet = this.labelData_;
        synchronized (navigableSet) {
            if (!this.labelData_.isEmpty()) {
                long labelTimeMin = ((LabelSignalMessage)this.labelData_.first()).getTime();
                long labelTimeMax = ((LabelSignalMessage)this.labelData_.last()).getTime();
                if (this.waveDataTimeMin_ > labelTimeMin) {
                    this.waveDataTimeMin_ = labelTimeMin;
                }
                if (this.waveDataTimeMax_ < labelTimeMax) {
                    this.waveDataTimeMax_ = labelTimeMax;
                }
            }
        }
        if (this.followSlider_) {
            this.viewTimeMax_ = this.waveDataTimeMax_;
        }
        if (!this.slider_.isDisposed()) {
            this.slider_.setMaximum((int)((this.waveDataTimeMax_ - this.waveDataTimeMin_) / this.sliderUnitTime_));
            this.slider_.setThumb((int)(this.viewTimeWidth_ / this.sliderUnitTime_));
        }
        this.setViewTimeMax(this.viewTimeMax_);
    }

    public void preventUpdates(boolean b) {
        if (b) {
            this.requestedUpdateTimeRangeAndRedraw = true;
            this.requestedRedraw_ = true;
        } else {
            this.requestedUpdateTimeRangeAndRedraw = false;
            this.doRequestedUpdateTimeRange();
            this.doRedraw();
        }
    }

    public void requestUpdateTimeRangeAndRedraw() {
        if (this.requestedUpdateTimeRangeAndRedraw) {
            return;
        }
        this.requestedUpdateTimeRangeAndRedraw = true;
        this.requestedRedraw_ = true;
        this.asyncTimerExec(33, new Runnable(){

            @Override
            public void run() {
                WaveViewWidget.this.requestedUpdateTimeRangeAndRedraw = false;
                WaveViewWidget.this.doRequestedUpdateTimeRange();
                WaveViewWidget.this.doRedraw();
            }
        });
    }

    private void doRedraw() {
        if (!this.canvas_.isDisposed()) {
            this.canvas_.redraw();
        }
    }

    public void requestRedraw() {
        if (this.requestedRedraw_) {
            return;
        }
        this.requestedRedraw_ = true;
        this.asyncTimerExec(33, new Runnable(){

            @Override
            public void run() {
                WaveViewWidget.this.doRedraw();
            }
        });
    }

    private void asyncTimerExec(final int milliseconds, final Runnable runnable) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WaveViewWidget.this.getDisplay().timerExec(milliseconds, runnable);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setVectorData(Collection<VectorSignalMessage> waveData) {
        NavigableSet<VectorSignalMessage> navigableSet = this.waveData_;
        synchronized (navigableSet) {
            this.waveData_.clear();
            this.waveData_.addAll(waveData);
            this.requestUpdateTimeRangeAndRedraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLabelData(Collection<LabelSignalMessage> labelData) {
        NavigableSet<LabelSignalMessage> navigableSet = this.labelData_;
        synchronized (navigableSet) {
            this.labelData_.clear();
            this.labelData_.addAll(labelData);
            this.requestUpdateTimeRangeAndRedraw();
        }
    }

    public MessageProcessor getInputPort() {
        return this.inputPort_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(int dataToClear) {
        NavigableSet<SignalMessage> navigableSet;
        if ((dataToClear & 2) != 0) {
            navigableSet = this.labelData_;
            synchronized (navigableSet) {
                this.labelData_.clear();
            }
        }
        if ((dataToClear & 1) != 0) {
            navigableSet = this.waveData_;
            synchronized (navigableSet) {
                this.waveData_.clear();
                this.waveDataTimeMin_ = 0L;
                this.waveDataTimeMax_ = 0L;
                this.requestUpdateTimeRangeAndRedraw();
            }
        }
    }

    public int getSignalDataCapacity() {
        return this.signalDataCapacity_;
    }

    public void setSignalDataCapacity(int signalDataCapacity) {
        this.signalDataCapacity_ = signalDataCapacity;
    }

    public long getViewTimeWidth() {
        return this.viewTimeWidth_;
    }

    public void setViewTimeWidth(long viewTimeWidth) {
        this.viewTimeWidth_ = viewTimeWidth;
    }

    public double getValueMin() {
        return this.valueMin_;
    }

    public void setValueMin(double valueMin) {
        this.valueMin_ = valueMin;
    }

    public double getValueHeight() {
        return this.valueHeight_;
    }

    public void setValueHeight(double valueHeight) {
        this.valueHeight_ = valueHeight;
    }

    public boolean isShowScale() {
        return this.showScale_;
    }

    public void setShowScale(boolean showGraduations) {
        this.showScale_ = showGraduations;
    }

    public void setTitleName(String s) {
        this.topLabel_.setText(s);
    }

    public boolean isFollowSlider() {
        return this.followSlider_;
    }

    public void setFollowSlider(boolean followSlider) {
        this.followSlider_ = followSlider;
    }

    public long getViewTimeMax() {
        return this.viewTimeMax_;
    }

    public void setViewTimeMax(long viewTimeMax) {
        this.viewTimeMax_ = viewTimeMax;
        if (this.viewTimeMax_ < this.waveDataTimeMin_ + this.viewTimeWidth_) {
            this.viewTimeMax_ = this.waveDataTimeMin_ + this.viewTimeWidth_;
        }
        if (this.viewTimeMax_ > this.waveDataTimeMax_) {
            this.viewTimeMax_ = this.waveDataTimeMax_;
        }
        if (!this.slider_.isDisposed()) {
            this.slider_.setSelection((int)((this.viewTimeMax_ - this.waveDataTimeMin_) / this.sliderUnitTime_) - this.slider_.getThumb());
        }
    }

    public long getViewTimeMin() {
        return this.viewTimeMax_ - this.viewTimeWidth_;
    }

    public void setViewTimeMin(long viewTimeMin) {
        this.setViewTimeMax(viewTimeMin + this.viewTimeWidth_);
    }

    public ToolBar getToolBar() {
        return this.toolBar_;
    }

    public Long getTimeMarkerBegin() {
        return this.timeMarkerBegin_;
    }

    public Long getTimeMarkerEnd() {
        return this.timeMarkerEnd_;
    }

    public int getClearingDataWhenBeginMessage() {
        return this.clearingDataWhenBeginMessage_;
    }

    public void setClearingDataWhenBeginMessage(int clearDataWhenBeginMessage) {
        this.clearingDataWhenBeginMessage_ = clearDataWhenBeginMessage;
    }

    private final class CopyLinkSelectionListener
    implements SelectionListener {
        private CopyLinkSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String text = e.text;
            LOG.debug((Object)("toClipboard: " + text));
            CoreUtil.copyToClipboard(WaveViewWidget.this.getShell().getDisplay(), text);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

