/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views.grapheditor;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import jp.hasc.hasctool.core.blockdiagram.model.AbstractBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BeanBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.blockdiagram.model.Connection;
import jp.hasc.hasctool.ui.views.grapheditor.BlockDiagramGraphWidget;
import jp.hasc.hasctool.ui.views.grapheditor.IBlockObject;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class BeanBlockObject
implements IPropertySource,
IBlockObject {
    private static final Log LOG = LogFactory.getLog(BeanBlockObject.class);
    private BlockDiagramGraphWidget bdg_;
    private BeanBlock block_;
    private HashMap<String, PropertyInfo> propertyInfos_ = new HashMap();
    private static final String CAT_TYPE = "_block";
    private static final String CAT_PROPERTIES = "bean properties";
    private static final String P_NAME = "P_NAME";
    private static final String P_TYPE = "P_TYPE";
    private static final String P_CLASS = "P_CLASS";
    private static final String P_COMMENT = "P_COMMENT";
    private static final String P_PROPERTIES_PRIFIX = "P_PROPERTIES_";

    public BeanBlockObject(BlockDiagramGraphWidget bdg, BeanBlock block) {
        this.bdg_ = bdg;
        this.block_ = block;
        this.buildPropertyInfos();
    }

    private void buildPropertyInfos() {
        this.propertyInfos_.clear();
        for (String key : this.block_.properties().keySet()) {
            Object value = this.block_.getProperty(key);
            if (value == null || !this.isPropetyValueClassSupported(value.getClass())) continue;
            PropertyInfo pi = new PropertyInfo(key, value.getClass());
            this.propertyInfos_.put(key, pi);
        }
        try {
            Class<?> c = Class.forName(this.block_.getRuntimeClassName());
            this.buildPropertyInfosFromClass(c);
        }
        catch (ClassNotFoundException ex) {
            LOG.info((Object)"ClassNotFoundException", (Throwable)ex);
        }
    }

    private void buildPropertyInfosFromClass(Class<?> c) {
        PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors(c);
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getWriteMethod() != null) {
                String key = pd.getName();
                Class<?> vt = BeanBlockObject.covertPrimitiveToClass(pd.getPropertyType());
                if (this.isPropetyValueClassSupported(vt)) {
                    PropertyInfo pi = new PropertyInfo(key, vt);
                    this.propertyInfos_.put(key, pi);
                }
            }
            ++n2;
        }
        Class<?> sc = c.getSuperclass();
        if (sc != null && !sc.equals(Object.class)) {
            this.buildPropertyInfosFromClass(sc);
        }
    }

    public static Class<?> covertPrimitiveToClass(Class<?> propertyType) {
        if (propertyType == null || !propertyType.isPrimitive()) {
            return propertyType;
        }
        if (propertyType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (propertyType == Character.TYPE) {
            return Character.class;
        }
        if (propertyType == Byte.TYPE) {
            return Byte.class;
        }
        if (propertyType == Short.TYPE) {
            return Short.class;
        }
        if (propertyType == Integer.TYPE) {
            return Integer.class;
        }
        if (propertyType == Long.TYPE) {
            return Long.class;
        }
        if (propertyType == Float.TYPE) {
            return Float.class;
        }
        if (propertyType == Double.TYPE) {
            return Double.class;
        }
        if (propertyType == Void.TYPE) {
            return Void.class;
        }
        throw new RuntimeException("Unknown class: " + propertyType.getName());
    }

    @Override
    public AbstractBlock getBlock() {
        return this.block_;
    }

    public BeanBlock getBeanBlock() {
        return this.block_;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> descriptors = new ArrayList<TextPropertyDescriptor>();
        descriptors.add(new TextPropertyDescriptor((Object)P_TYPE, "_Type"));
        descriptors.add(new TextPropertyDescriptor((Object)P_NAME, "Name"));
        descriptors.add(new TextPropertyDescriptor((Object)P_CLASS, "Class"));
        descriptors.add(new TextPropertyDescriptor((Object)P_COMMENT, "Comment"));
        for (IPropertyDescriptor iPropertyDescriptor : descriptors) {
            ((TextPropertyDescriptor)iPropertyDescriptor).setCategory(CAT_TYPE);
        }
        for (PropertyInfo propertyInfo : this.propertyInfos_.values()) {
            TextPropertyDescriptor pd = new TextPropertyDescriptor((Object)(P_PROPERTIES_PRIFIX + propertyInfo.getName()), propertyInfo.getName());
            pd.setCategory(CAT_PROPERTIES);
            descriptors.add(pd);
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    private String getPropertyKey(Object id) {
        String idStr;
        if (id instanceof String && (idStr = (String)id).startsWith(P_PROPERTIES_PRIFIX) && this.block_.properties() != null) {
            String key = idStr.substring(P_PROPERTIES_PRIFIX.length());
            return key;
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        if (P_TYPE.equals(id)) {
            return "BeanBlock";
        }
        if (P_NAME.equals(id)) {
            return this.block_.getName();
        }
        if (P_CLASS.equals(id)) {
            return this.block_.getRuntimeClassName();
        }
        if (P_COMMENT.equals(id)) {
            return this.block_.getComment() != null ? this.block_.getComment() : "";
        }
        String key = this.getPropertyKey(id);
        if (key != null) {
            PropertyInfo pi = this.propertyInfos_.get(key);
            return this.propertyValueToString(pi.getValue());
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean isPropertySet(Object id) {
        String key = this.getPropertyKey(id);
        if (key != null) {
            PropertyInfo pi = this.propertyInfos_.get(key);
            return pi.getValue() != null;
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        String key = this.getPropertyKey(id);
        if (key != null) {
            PropertyInfo pi = this.propertyInfos_.get(key);
            pi.setValue(null);
            this.bdg_.updateText();
        }
    }

    public void setPropertyValue(Object id, Object value) {
        String valueStr;
        LOG.debug((Object)("setPropertyValue: " + id + "=" + value));
        String string = valueStr = value != null ? value.toString() : "";
        if (P_COMMENT.equals(id)) {
            this.block_.setComment(valueStr.isEmpty() ? null : valueStr);
            this.bdg_.updateText();
        } else if (P_NAME.equals(id)) {
            if (!valueStr.isEmpty()) {
                String oldName = this.block_.getName();
                String newName = valueStr;
                BlockDiagram bd = this.bdg_.getBlockDiagram();
                for (AbstractBlock blk : bd.getBlocks()) {
                    if (!blk.getName().equals(newName)) continue;
                    LOG.info((Object)("block name duplicated: " + newName));
                    return;
                }
                this.block_.setName(newName);
                for (Connection c : bd.getConnections()) {
                    if (c.getInputPortReference().getBlockName().equals(oldName)) {
                        c.setInputPortReference(this.block_.getPortByName(c.getInputPortReference().getPortName()));
                    }
                    if (!c.getOutputPortReference().getBlockName().equals(oldName)) continue;
                    c.setOutputPortReference(this.block_.getPortByName(c.getOutputPortReference().getPortName()));
                }
                this.bdg_.updateText();
                this.bdg_.updateDiagram();
            }
        } else if (P_CLASS.equals(id)) {
            try {
                Class.forName(valueStr);
                this.block_.setRuntimeClassName(valueStr);
                this.buildPropertyInfos();
            }
            catch (ClassNotFoundException ex) {
                LOG.info((Object)"ClassNotFoundException", (Throwable)ex);
                return;
            }
            this.bdg_.updateText();
        } else {
            String key = this.getPropertyKey(id);
            if (key != null) {
                PropertyInfo pi = this.propertyInfos_.get(key);
                try {
                    Class<?> c = pi.getValueClass();
                    Object v = this.stringToPropertyValue(valueStr, c);
                    pi.setValue(v);
                }
                catch (Exception ex) {
                    LOG.info((Object)"Exception", (Throwable)ex);
                    return;
                }
            } else {
                LOG.warn((Object)("Unknown property id:" + id));
            }
            this.bdg_.updateText();
        }
    }

    private boolean isPropetyValueClassSupported(Class<?> c) {
        return c.equals(String.class) || c.equals(Integer.class) || c.equals(Long.class) || c.equals(Float.class) || c.equals(Double.class) || c.equals(Boolean.class) || c.equals(Character.class) || c.equals(Byte.class) || c.equals(Short.class);
    }

    private String propertyValueToString(Object value) {
        return value == null ? "" : value.toString();
    }

    private Object stringToPropertyValue(String valueStr, Class<?> c) throws Exception {
        if (valueStr.isEmpty()) {
            return null;
        }
        if (c.equals(String.class)) {
            return valueStr;
        }
        if (c.equals(Integer.class)) {
            return Integer.parseInt(valueStr);
        }
        if (c.equals(Long.class)) {
            return Long.parseLong(valueStr);
        }
        if (c.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(valueStr));
        }
        if (c.equals(Double.class)) {
            return Double.parseDouble(valueStr);
        }
        if (c.equals(Boolean.class)) {
            return Boolean.parseBoolean(valueStr);
        }
        if (c.equals(Character.class)) {
            return new Character(valueStr.length() > 0 ? valueStr.charAt(0) : (char)'\u0000');
        }
        if (c.equals(Byte.class)) {
            return Byte.parseByte(valueStr);
        }
        if (c.equals(Short.class)) {
            return Short.parseShort(valueStr);
        }
        throw new RuntimeException("Value class not supported: " + c.getName());
    }

    class PropertyInfo {
        private String name_;
        private Class<?> valueClass_;

        public PropertyInfo(String name, Class<?> valueClass) {
            this.name_ = name;
            this.valueClass_ = valueClass;
        }

        public String getName() {
            return this.name_;
        }

        public Class<?> getValueClass() {
            return this.valueClass_;
        }

        public Object getValue() {
            return BeanBlockObject.this.block_.getProperty(this.name_);
        }

        public void setValue(Object value) {
            BeanBlockObject.this.block_.setProperty(this.name_, value);
        }
    }
}

