/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views.grapheditor;

import java.util.ArrayList;
import java.util.HashMap;
import jp.hasc.hasctool.core.blockdiagram.model.AbstractBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BeanBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.blockdiagram.model.Connection;
import jp.hasc.hasctool.core.util.Pair;
import jp.hasc.hasctool.ui.views.grapheditor.BeanBlockObject;
import jp.hasc.hasctool.ui.views.grapheditor.BlockDiagramGraphWidget;
import jp.hasc.hasctool.ui.views.grapheditor.ConnectionObject;
import jp.hasc.hasctool.ui.views.grapheditor.IBlockObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.zest.core.viewers.IGraphEntityRelationshipContentProvider;

public class BlockDiagramContentProvider
implements IGraphEntityRelationshipContentProvider {
    private BlockDiagramGraphWidget bdg_;
    private BlockDiagram bd_;
    private HashMap<String, IBlockObject> blockObjMap_;
    private HashMap<Pair<String, String>, ArrayList<ConnectionObject>> connectionsMap_;

    public BlockDiagramContentProvider(BlockDiagramGraphWidget bdg) {
        this.bdg_ = bdg;
    }

    public Object[] getElements(Object input) {
        ArrayList<BeanBlockObject> al = new ArrayList<BeanBlockObject>();
        if (input instanceof BlockDiagram) {
            this.bd_ = (BlockDiagram)input;
            this.blockObjMap_ = new HashMap();
            for (AbstractBlock b : this.bd_.getBlocks()) {
                if (b instanceof BeanBlock) {
                    BeanBlockObject bbo = new BeanBlockObject(this.bdg_, (BeanBlock)b);
                    this.blockObjMap_.put(b.getName(), bbo);
                    al.add(bbo);
                    continue;
                }
                throw new RuntimeException("not supported: " + b.getClass());
            }
            this.connectionsMap_ = new HashMap();
            for (Connection c : this.bd_.getConnections()) {
                Pair<String, String> sdn = new Pair<String, String>(c.getOutputPortReference().getBlockName(), c.getInputPortReference().getBlockName());
                ArrayList<ConnectionObject> m = this.connectionsMap_.get(sdn);
                if (m == null) {
                    m = new ArrayList();
                    this.connectionsMap_.put(sdn, m);
                }
                m.add(new ConnectionObject(this.bdg_, c));
            }
            return al.toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public HashMap<String, IBlockObject> getBlockObjMap() {
        return this.blockObjMap_;
    }

    public Object[] getRelationships(Object source, Object dest) {
        Pair<String, String> sdn = new Pair<String, String>(((IBlockObject)source).getBlock().getName(), ((IBlockObject)dest).getBlock().getName());
        ArrayList<ConnectionObject> m = this.connectionsMap_.get(sdn);
        if (m == null) {
            return null;
        }
        return m.toArray();
    }
}

