/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views.grapheditor;

import java.beans.PropertyDescriptor;
import java.util.Iterator;
import jp.hasc.hasctool.core.blockdiagram.model.AbstractBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BeanBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.blockdiagram.model.Connection;
import jp.hasc.hasctool.core.blockdiagram.model.PortReference;
import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.ui.util.UIUtil;
import jp.hasc.hasctool.ui.views.grapheditor.BlockDiagramContentProvider;
import jp.hasc.hasctool.ui.views.grapheditor.BlockDiagramEditor;
import jp.hasc.hasctool.ui.views.grapheditor.BlockDiagramLabelProvider;
import jp.hasc.hasctool.ui.views.grapheditor.ConnectionObject;
import jp.hasc.hasctool.ui.views.grapheditor.IBlockObject;
import jp.hasc.hasctool.ui.views.grapheditor.Messages;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;

public class BlockDiagramGraphWidget
extends Composite {
    private static final Log LOG = LogFactory.getLog(BlockDiagramGraphWidget.class);
    private GraphViewer graphView_;
    private BlockDiagram blockDiagram_;
    private BlockDiagramContentProvider contentProvider_;
    private BlockDiagramLabelProvider labelProvider_;
    private BlockDiagramEditor editor_;
    private ToolBar toolBar_;
    private String prevInputClassName_ = "";

    public BlockDiagramGraphWidget(BlockDiagramEditor editor, Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.toolBar_ = new ToolBar((Composite)this, 512);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.right = new FormAttachment(100, -1);
        fd.bottom = new FormAttachment(100, -1);
        this.toolBar_.setLayoutData((Object)fd);
        ToolItem ti = new ToolItem(this.toolBar_, 0);
        ti.setText("+B");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Class<?> cls;
                InputDialog dlg = new InputDialog(BlockDiagramGraphWidget.this.getShell(), Messages.BlockDiagramGraphWidget_NewBlock, Messages.BlockDiagramGraphWidget_NewBlockMsg, BlockDiagramGraphWidget.this.prevInputClassName_, null);
                if (dlg.open() != 0) {
                    return;
                }
                String clsName = dlg.getValue();
                try {
                    cls = Class.forName(clsName);
                }
                catch (ClassNotFoundException ex) {
                    UIUtil.showMessageDialog(BlockDiagramGraphWidget.this.getShell(), ex.toString());
                    return;
                }
                String name = "";
                int i = 1;
                while (i < 1000) {
                    name = String.valueOf(cls.getSimpleName()) + i;
                    if (!BlockDiagramGraphWidget.this.contentProvider_.getBlockObjMap().containsKey(name)) break;
                    ++i;
                }
                BeanBlock bb = new BeanBlock();
                bb.setName(name);
                bb.setRuntimeClassName(clsName);
                BlockDiagramGraphWidget.this.blockDiagram_.addBlock(bb);
                BlockDiagramGraphWidget.this.editor_.updateText();
                BlockDiagramGraphWidget.this.updateDiagram();
                IBlockObject bbo = BlockDiagramGraphWidget.this.contentProvider_.getBlockObjMap().get(name);
                if (bbo != null) {
                    BlockDiagramGraphWidget.this.selectObjects(new Object[]{bbo});
                }
                BlockDiagramGraphWidget.this.prevInputClassName_ = clsName;
            }
        });
        ti = new ToolItem(this.toolBar_, 0);
        ti.setText("+C");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)BlockDiagramGraphWidget.this.graphView_.getSelection();
                Object[] objs = sel.toArray();
                if (objs.length == 2 && objs[0] instanceof IBlockObject && objs[1] instanceof IBlockObject) {
                    Connection c2;
                    IBlockObject blk0 = (IBlockObject)objs[0];
                    IBlockObject blk1 = (IBlockObject)objs[1];
                    LOG.debug((Object)(String.valueOf(blk0.getBlock().getName()) + " to " + blk1.getBlock().getName()));
                    String pname0 = "outputPort";
                    String pname1 = "inputPort";
                    StringBuilder msgs = new StringBuilder();
                    try {
                        Class<?> cls1;
                        Object desc1;
                        Class<?> cls0 = Class.forName(((BeanBlock)blk0.getBlock()).getRuntimeClassName());
                        PropertyDescriptor desc0 = PropertyUtils.getPropertyDescriptor(cls0.newInstance(), (String)pname0);
                        if (desc0 == null || desc0.getPropertyType() == null || !MessageConnector.class.isAssignableFrom(desc0.getPropertyType())) {
                            pname0 = "";
                            msgs.append(String.format(Messages.BlockDiagramGraphWidget_NoDefaultOutputPort, blk0.getBlock().getName()));
                            msgs.append("\n");
                        }
                        if ((desc1 = PropertyUtils.getPropertyDescriptor((cls1 = Class.forName(((BeanBlock)blk1.getBlock()).getRuntimeClassName())).newInstance(), (String)pname1)) == null || ((PropertyDescriptor)desc1).getPropertyType() == null || !MessageProcessor.class.isAssignableFrom(((PropertyDescriptor)desc1).getPropertyType())) {
                            pname1 = "";
                            msgs.append(String.format(Messages.BlockDiagramGraphWidget_NoDefaultInputPort, blk1.getBlock().getName()));
                            msgs.append("\n");
                        }
                    }
                    catch (Exception ex) {
                        msgs.append(ex.toString());
                        msgs.append("\n");
                    }
                    PortReference pr0 = blk0.getBlock().getPortByName(pname0);
                    PortReference pr1 = blk1.getBlock().getPortByName(pname1);
                    for (Connection c2 : BlockDiagramGraphWidget.this.blockDiagram_.getConnections()) {
                        if (!c2.getInputPortReference().equals(pr1)) continue;
                        msgs.append(String.format(Messages.BlockDiagramGraphWidget_DuplicatedInputPortConnections, pr1.getBlockName(), pr1.getPortName()));
                        msgs.append("\n");
                        break;
                    }
                    c2 = new Connection();
                    c2.setOutputPortReference(pr0);
                    c2.setInputPortReference(pr1);
                    BlockDiagramGraphWidget.this.blockDiagram_.addConnection(c2);
                    BlockDiagramGraphWidget.this.editor_.updateText();
                    BlockDiagramGraphWidget.this.updateDiagram();
                    Object[] objectArray = BlockDiagramGraphWidget.this.graphView_.getConnectionElements();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object co = objectArray[n2];
                        if (co instanceof ConnectionObject && ((ConnectionObject)co).getConnection() == c2) {
                            BlockDiagramGraphWidget.this.selectObjects(new Object[]{co});
                            break;
                        }
                        ++n2;
                    }
                    if (msgs.length() != 0) {
                        LOG.info((Object)msgs);
                        UIUtil.showMessageDialog(BlockDiagramGraphWidget.this.getShell(), msgs.toString());
                    }
                } else {
                    UIUtil.showMessageDialog(BlockDiagramGraphWidget.this.getShell(), Messages.BlockDiagramGraphWidget_SelectTwoBlocksToConnect);
                }
            }
        });
        ti = new ToolItem(this.toolBar_, 0);
        ti.setText("Del");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)BlockDiagramGraphWidget.this.graphView_.getSelection();
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof IBlockObject) {
                        BlockDiagramGraphWidget.this.remove((IBlockObject)obj);
                    } else if (obj instanceof ConnectionObject) {
                        BlockDiagramGraphWidget.this.remove((ConnectionObject)obj);
                    }
                    ++n2;
                }
                BlockDiagramGraphWidget.this.editor_.updateText();
                BlockDiagramGraphWidget.this.updateDiagram();
            }
        });
        ti = new ToolItem(this.toolBar_, 0);
        ti.setText("Inf");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dlg = new InputDialog(BlockDiagramGraphWidget.this.getShell(), "Edit BD Information", "Comment", BlockDiagramGraphWidget.this.blockDiagram_.getComment(), null);
                if (dlg.open() != 0) {
                    return;
                }
                BlockDiagramGraphWidget.this.blockDiagram_.setComment(dlg.getValue());
                BlockDiagramGraphWidget.this.editor_.updateText();
            }
        });
        this.editor_ = editor;
        this.graphView_ = new GraphViewer((Composite)this, 0);
        this.graphView_.setNodeStyle(256);
        this.graphView_.setConnectionStyle(6);
        fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment(100, -1);
        fd.right = new FormAttachment((Control)this.toolBar_, -1);
        this.graphView_.getGraphControl().setLayoutData((Object)fd);
    }

    public void setBlockDiagram(BlockDiagram bd) {
        this.blockDiagram_ = bd;
        this.buildDiagram();
    }

    public void buildDiagram() {
        this.contentProvider_ = new BlockDiagramContentProvider(this);
        this.labelProvider_ = new BlockDiagramLabelProvider();
        this.graphView_.refresh();
        this.graphView_.setContentProvider((IContentProvider)this.contentProvider_);
        this.graphView_.setLabelProvider((IBaseLabelProvider)this.labelProvider_);
        this.graphView_.setInput((Object)this.blockDiagram_);
        this.graphView_.setLayoutAlgorithm((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1), false);
    }

    public void updateDiagram() {
        this.graphView_.refresh();
        this.graphView_.applyLayout();
    }

    public BlockDiagram getBlockDiagram() {
        return this.blockDiagram_;
    }

    public void updateText() {
        this.editor_.updateText();
    }

    public BlockDiagramContentProvider getContentProvider() {
        return this.contentProvider_;
    }

    public GraphViewer getGraphView() {
        return this.graphView_;
    }

    private void remove(IBlockObject obj) {
        Iterator<AbstractBlock> it = this.blockDiagram_.getBlocks().iterator();
        while (it.hasNext()) {
            AbstractBlock iobj = it.next();
            if (iobj != obj.getBlock()) continue;
            it.remove();
        }
        String blkName = obj.getBlock().getName();
        Iterator<Connection> it2 = this.blockDiagram_.getConnections().iterator();
        while (it2.hasNext()) {
            Connection iobj = it2.next();
            if (iobj.getInputPortReference().getBlockName().equals(blkName)) {
                it2.remove();
                continue;
            }
            if (!iobj.getOutputPortReference().getBlockName().equals(blkName)) continue;
            it2.remove();
        }
    }

    private void remove(ConnectionObject obj) {
        Iterator<Connection> it = this.blockDiagram_.getConnections().iterator();
        while (it.hasNext()) {
            Connection iobj = it.next();
            if (iobj != obj.getConnection()) continue;
            it.remove();
        }
    }

    private void selectObjects(Object ... objs) {
        StructuredSelection sel = new StructuredSelection(objs);
        this.graphView_.setSelection((ISelection)sel, true);
        try {
            PropertySheet ps = (PropertySheet)this.editor_.getSite().getWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet", null, 3);
            if (ps != null) {
                ps.selectionChanged((IWorkbenchPart)this.editor_, (ISelection)sel);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Exception", (Throwable)ex);
        }
    }
}

