/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.ui.views.grapheditor;

import jp.hasc.hasctool.core.blockdiagram.model.BeanBlock;
import jp.hasc.hasctool.core.blockdiagram.model.Connection;
import jp.hasc.hasctool.ui.views.grapheditor.BlockDiagramGraphWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ConnectionObject
implements IPropertySource {
    private static final Log LOG = LogFactory.getLog(ConnectionObject.class);
    private BlockDiagramGraphWidget bdg_;
    private Connection connection_;
    private static final String P_TYPE = "P_TYPE";
    private static final String P_COMMENT = "P_COMMENT";
    private static final String P_OUTPUT_PORT = "P_OUTPUT";
    private static final String P_INPUT_PORT = "P_INPUT";

    public ConnectionObject(BlockDiagramGraphWidget bdg, Connection connection) {
        this.bdg_ = bdg;
        this.connection_ = connection;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] descriptor = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)P_TYPE, "_Type"), new TextPropertyDescriptor((Object)P_COMMENT, "Comment"), new TextPropertyDescriptor((Object)P_OUTPUT_PORT, "OutputPort"), new TextPropertyDescriptor((Object)P_INPUT_PORT, "InputPort")};
        return descriptor;
    }

    public Object getPropertyValue(Object id) {
        if (P_TYPE.equals(id)) {
            return "Connection";
        }
        if (P_COMMENT.equals(id)) {
            return this.connection_.getComment() != null ? this.connection_.getComment() : "";
        }
        if (P_OUTPUT_PORT.equals(id)) {
            return this.connection_.getOutputPortReference().getPortName();
        }
        if (P_INPUT_PORT.equals(id)) {
            return this.connection_.getInputPortReference().getPortName();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        String valueStr;
        LOG.debug((Object)("setPropertyValue: " + id + "=" + value));
        String string = valueStr = value != null ? value.toString() : "";
        if (P_COMMENT.equals(id)) {
            this.connection_.setComment(valueStr.isEmpty() ? null : valueStr);
            this.bdg_.updateText();
        } else if (P_OUTPUT_PORT.equals(id)) {
            if (!valueStr.isEmpty()) {
                BeanBlock blk = (BeanBlock)this.bdg_.getContentProvider().getBlockObjMap().get(this.connection_.getOutputPortReference().getBlockName()).getBlock();
                this.connection_.setOutputPortReference(blk.getPortByName(valueStr));
                this.bdg_.updateText();
            }
        } else if (P_INPUT_PORT.equals(id) && !valueStr.isEmpty()) {
            BeanBlock blk = (BeanBlock)this.bdg_.getContentProvider().getBlockObjMap().get(this.connection_.getInputPortReference().getBlockName()).getBlock();
            this.connection_.setInputPortReference(blk.getPortByName(valueStr));
            this.bdg_.updateText();
        }
    }

    public Connection getConnection() {
        return this.connection_;
    }
}

