/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.weka;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.weka.WekaDataInstance;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class EvaluationFilter
extends AbstractFilter {
    String element_;
    String[] eList_;
    String feature_;
    String[] fList_;
    int fLength_;
    WekaDataInstance wdi_;
    Instances learningDataset_;
    Classifier predictiveModel_;
    String predictElement_;

    public void setup(RuntimeContext context) {
        super.setup(context);
        this.eList_ = this.element_.split(",");
        this.fList_ = this.feature_.split(",");
        this.fLength_ = this.fList_.length;
    }

    public void setElement(String element) {
        this.element_ = element;
    }

    public void setFeature(String feature) {
        this.feature_ = feature;
    }

    private Instance createInstance(Instances associatedDataSet, String[] data) {
        Instance instance = new Instance(this.fLength_ + 1);
        instance.setDataset(associatedDataSet);
        int i = 0;
        while (i < this.fLength_) {
            instance.setValue(i, Double.parseDouble(data[i]));
            ++i;
        }
        instance.setValue(this.fLength_, "stay");
        return instance;
    }

    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof WekaDataInstance) {
            this.wdi_ = (WekaDataInstance)message;
            this.learningDataset_ = this.wdi_.getLearningDataset();
            this.predictiveModel_ = this.wdi_.getPredictiveModel();
        } else if (message instanceof String) {
            try {
                String s = (String)message;
                String[] data = s.split(",");
                int len = data.length;
                String filePath = data[0];
                String[] val = new String[len - 1];
                int i = 0;
                while (i < len - 2) {
                    val[i] = data[i + 2];
                    ++i;
                }
                val[len - 2] = this.eList_[0];
                Instance perdictInstance = this.createInstance(this.learningDataset_, val);
                double prediction = this.predictiveModel_.classifyInstance(perdictInstance);
                this.predictElement_ = perdictInstance.classAttribute().value((int)prediction);
                this.outputMessage(String.valueOf(filePath) + "," + this.predictElement_);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.outputMessage(message);
        }
    }
}

