/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.weka.learning;

import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.weka.learning.MachineLearning;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public abstract class LearningClassifier
extends MachineLearning {
    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
    }

    @Override
    void evaluatepredictiveModel() {
        try {
            Classifier predictiveModel = this.learnPredictiveModel(this.learningDataset_);
            System.out.println("START EVALUATION");
            Evaluation evaluation = this.evaluatePredictiveModel(predictiveModel, this.learningDataset_);
            System.out.println(evaluation.toSummaryString());
            this.wdi_.setLearningDataset(this.learningDataset_);
            this.wdi_.setPredictiveModel(predictiveModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Classifier learnPredictiveModel(Instances learningDataset) throws Exception {
        Classifier classifier = this.getClassifier();
        classifier.buildClassifier(learningDataset);
        return classifier;
    }

    abstract Classifier getClassifier();

    private Evaluation evaluatePredictiveModel(Classifier classifier, Instances learningDataset) throws Exception {
        Evaluation learningSetEvaluation = new Evaluation(learningDataset);
        learningSetEvaluation.evaluateModel(classifier, learningDataset, new Object[0]);
        return learningSetEvaluation;
    }
}

