/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime.filter.weka.learning;

import jp.hasc.hasctool.core.data.EnumCommand;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.filter.AbstractFilter;
import jp.hasc.hasctool.core.runtime.filter.weka.WekaDataInstance;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public abstract class MachineLearning
extends AbstractFilter {
    String element_;
    String[] eList_;
    int eLength_;
    String feature_;
    String[] fList_;
    int fLength_;
    protected WekaDataInstance wdi_;
    protected Instances learningDataset_;

    public void setup(RuntimeContext context) {
        super.setup(context);
        this.eList_ = this.element_.split(",");
        this.eLength_ = this.eList_.length;
        this.fList_ = this.feature_.split(",");
        this.fLength_ = this.fList_.length;
        this.wdi_ = new WekaDataInstance();
    }

    public void setElement(String element) {
        this.element_ = element;
    }

    public void setFeature(String feature) {
        this.feature_ = feature;
    }

    private FastVector createAttributes() {
        Attribute[] attribute_ = new Attribute[this.fLength_ + 1];
        int i = 0;
        while (i < this.fLength_) {
            attribute_[i] = new Attribute(this.fList_[i]);
            ++i;
        }
        FastVector elementAttributeValues = new FastVector(this.eLength_);
        int j = 0;
        while (j < this.eLength_) {
            elementAttributeValues.addElement((Object)this.eList_[j]);
            ++j;
        }
        attribute_[this.fLength_] = new Attribute("element", elementAttributeValues);
        FastVector allAttributes = new FastVector(this.fLength_ + 1);
        int k = 0;
        while (k < this.fLength_ + 1) {
            allAttributes.addElement((Object)attribute_[k]);
            ++k;
        }
        return allAttributes;
    }

    private Instances createLearningDataSet(FastVector allAttributes) {
        Instances trainingDataSet = new Instances("learningData", allAttributes, this.fLength_);
        trainingDataSet.setClassIndex(this.fLength_);
        return trainingDataSet;
    }

    private void addInstance(Instances trainingDataSet, String[] data) {
        Instance instance = this.createInstance(trainingDataSet, data);
        trainingDataSet.add(instance);
    }

    private Instance createInstance(Instances associatedDataSet, String[] data) {
        Instance instance = new Instance(this.fLength_ + 1);
        instance.setDataset(associatedDataSet);
        int i = 0;
        while (i < this.fLength_) {
            instance.setValue(i, Double.parseDouble(data[i]));
            ++i;
        }
        instance.setValue(this.fLength_, data[this.fLength_]);
        return instance;
    }

    abstract void evaluatepredictiveModel();

    public void processMessage(Object message) throws InterruptedException {
        if (message instanceof String) {
            String s = (String)message;
            String[] data = s.split(",");
            this.addInstance(this.learningDataset_, data);
        } else if (message == EnumCommand.BEGIN) {
            try {
                FastVector allAttributes = this.createAttributes();
                this.learningDataset_ = this.createLearningDataSet(allAttributes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (message == EnumCommand.END) {
            try {
                System.out.println("START CREATE CLASSIFIER");
                this.evaluatepredictiveModel();
                this.outputMessage(EnumCommand.BEGIN);
                this.outputMessage(this.wdi_);
                this.outputMessage(EnumCommand.END);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.outputMessage(message);
        }
    }
}

