// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		RendererFactory.java
//	DATE:		2003.5.31
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.view;

import java.awt.Rectangle;
import java.awt.Graphics;

import java.awt.geom.Area;

import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.Renderer;
import jp.gr.java_conf.ktz.puzzle.framework.RenderListener;
import jp.gr.java_conf.ktz.puzzle.framework.RenderEvent;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.*;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

/**
 *	RenderListenero^邽߂̃t@Ng[\bhNX
 */
public class RendererFactory {
	public static DefaultRenderer create(final int inWidth, final int inHeight) {
		DefaultRenderer aRenderer
			 = new DefaultRenderer(inWidth, inHeight, AppColors.BACK_COLOR);

		aRenderer.addRenderListener(HashikakeNumberState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Renderer aRenderer = inEvent.getSource();
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				HashikakeNumberState aState = (HashikakeNumberState)inEvent.getState();
				
				// Ɨאڂ鋴̘A`悷
				for (int i = 0; i < aState.getAdjacentCount(); ++i) {
					HashikakeNumberState.AdjacentState aAdjacent = aState.getAdjacentAt(i);
					
					if (StateManager.getInstance().isSpaceState(aAdjacent.getState())) continue;
					
					java.awt.Shape aOldClip = aGra.getClipBounds();
					Rectangle aNewClip = calcClipRegion(aGra, aBounds, aAdjacent.getDirection());
					
					inEvent.reset(aRenderer, aGra, aNewClip, aAdjacent.getState());
					RenderListener aListener = ((DefaultRenderer)aRenderer).lookup(inEvent.getState());
					aListener.render(inEvent);
					
					aGra.setClip(aOldClip);
				}
				
				RenderListener aListener;
				
				// ̃obN`悷
				inEvent.reset(aRenderer, aGra, aBounds, aState.getColorState());
				aListener = ((DefaultRenderer)aRenderer).lookup(inEvent.getState());
				aListener.render(inEvent);

				// `悷
				inEvent.reset(aRenderer, aGra, aBounds, aState.getNumberState());
				aListener = ((DefaultRenderer)aRenderer).lookup(inEvent.getState());
				aListener.render(inEvent);
			}
			
			/**
			 *	AdjacentState̕`̈vZ
			 *	
			 *	@return `̈
			 */
			private Rectangle calcClipRegion(Graphics inGra, Rectangle inBounds , Direction inDirection) {
				Rectangle aOldClip = inGra.getClipBounds();

				java.awt.Point aDiff = inDirection.getDifference();
				Rectangle aAdjacentBounds = new Rectangle(
					inBounds.x + aDiff.x * inBounds.width / 2, 
					inBounds.y + aDiff.y * inBounds.height / 2, 
					inBounds.width, inBounds.height
				);
				
				return aAdjacentBounds.intersection(aOldClip);
			}
		});
		
		aRenderer.addRenderListener(DefaultColorState.class, new RenderListener() {
			private static final int INSET = 1;
			
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = new Rectangle(inEvent.getBounds());
				
				// ̒`
				aBounds.grow(-INSET, -INSET);
				aGra.setColor(AppColors.ISLAND);			
				aGra.fillOval(aBounds.x, aBounds.y, aBounds.width, aBounds.height);

/*				
				// ̗֊s`
				aGra.setColor(AppColors.ISLAND_NUMBER);			
				aGra.drawOval(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
*/
			}
		});
		
		aRenderer.addRenderListener(NumberState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = new Rectangle(inEvent.getBounds());
				
				// ̐`
				final int aNum = ((NumberState)inEvent.getState()).getValue();
				aGra.setColor(AppColors.ISLAND_NUMBER);
				String aStr = String.valueOf(aNum);
				java.awt.geom.Rectangle2D aStrBounds = aGra.getFontMetrics().getStringBounds(aStr, aGra);

				final int aX = (int)(aBounds.x + (aBounds.width-aStrBounds.getWidth())/2);
				final int aY = (int)(aBounds.y - aStrBounds.getY() + (aBounds.width-aStrBounds.getHeight())/2);
				aGra.drawString(aStr, aX, aY);
			}
		});
		
		aRenderer.addRenderListener(NumberActiveState.class, new RenderListener() {
			public void render(RenderEvent ioEvent) {
				Renderer aRenderer = ioEvent.getSource();
				Graphics aGra = ioEvent.getGraphics();
				Rectangle aBounds = ioEvent.getBounds();
				NumberActiveState aState = (NumberActiveState)ioEvent.getState();
				
				// ɐ`悷B
				ioEvent.reset(aRenderer, aGra, aBounds, aState.getDecorated());
				RenderListener aListener = ((DefaultRenderer)aRenderer).lookup(ioEvent.getState());
				aListener.render(ioEvent);

				aGra.setColor(AppColors.ACTIVE_COLOR);
				
				java.awt.Shape aOldClip = calcClipRegion(aGra, aBounds, aState.getDirection());
				
				aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
				
				// Clip̈ɖ߂
				aGra.setClip(aOldClip);
			}
			
			/**
			 *	NumberActiveState̕`̈vZAw肵GraphicsIuWFNgɐݒ肷
			 *
			 *	@return	ݒ肷O̕`̈
			 */
			private java.awt.Shape calcClipRegion(Graphics inGra, Rectangle inBounds , Direction inDirection) {
				java.awt.Shape aOldClip = inGra.getClip();
				
				Area aClipRegion = new Area();
				{
					aClipRegion.add(new Area(
						new java.awt.geom.Ellipse2D.Double(inBounds.x, inBounds.y, inBounds.width, inBounds.height)
					));
					
					if (Direction.NO != inDirection) {
						java.awt.Point aDiff = inDirection.getDifference();
						aClipRegion.add(new Area(new Rectangle(
							inBounds.x + aDiff.x * inBounds.width / 2, 
							inBounds.y + aDiff.y * inBounds.height / 2, 
							inBounds.width, inBounds.height
						)));
					}
					
					aClipRegion.intersect(new Area(aOldClip));
				}
							
				inGra.setClip(aClipRegion);
				
				return aOldClip;
			}
		});
		
		aRenderer.addRenderListener(SelectionState.class, new RenderListener() {
			public void render(RenderEvent ioEvent) {
				Renderer aRenderer = ioEvent.getSource();
				Graphics aGra = ioEvent.getGraphics();
				Rectangle aBounds = ioEvent.getBounds();
				State aState = ioEvent.getState();
				
				// ɔՖʂ`悷B
				ioEvent.reset(aRenderer, aGra, aBounds, ((SelectionState)aState).getDecorated());
				RenderListener aListener = ((DefaultRenderer)aRenderer).lookup(ioEvent.getState());
				aListener.render(ioEvent);
				
				// IԂ`悷B
				aGra.setColor(AppColors.ACTIVE_COLOR);
				aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		});

		aRenderer.addRenderListener(NSBridgeState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.BRIDGE);
				aGra.fillRect(aBounds.x + aBounds.width*2/5, aBounds.y, aBounds.width/5, aBounds.height);
			}
		});
		
		aRenderer.addRenderListener(BigNSBridgeState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.BRIDGE);
				aGra.fillRect(aBounds.x + aBounds.width/5, aBounds.y, aBounds.width/5, aBounds.height);
				aGra.fillRect(aBounds.x + aBounds.width*3/5, aBounds.y, aBounds.width/5, aBounds.height);
			}
		});

		aRenderer.addRenderListener(WEBridgeState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.BRIDGE);
				aGra.fillRect(aBounds.x, aBounds.y + aBounds.height*2/5, aBounds.width, aBounds.height/5);
			}
		});
		
		aRenderer.addRenderListener(BigWEBridgeState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.BRIDGE);
				aGra.fillRect(aBounds.x, aBounds.y + aBounds.height/5, aBounds.width, aBounds.height/5);
				aGra.fillRect(aBounds.x, aBounds.y + aBounds.height*3/5, aBounds.width, aBounds.height/5);
			}
		});
		
		return aRenderer;
	}
}

