// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		MenuItemBean.java
//	DATE:		2003.8.1
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.PropertyBundle;

abstract class AbstractMenuItemBean implements MenuElementBean {
	static final String MODIFIER_SHIFT = "shift";
	
	private String mName;
	
	private String mShortcut = "";
	private String mShortCutModifier = "";
	
	private String mClassName = "";
	
	public abstract java.awt.MenuItem createMenuItem(MenuManager inManager);
	
	public void setName(String inName) {
		mName = inName;
	}
	
	public String getName() {
		return mName;
	}
	
	public void setShortcut(String inShortcut) {
		mShortcut = inShortcut;
	}
	
	public String getShortcut() {
		return mShortcut;
	}
	
	public void setShortCutModifier(String inModifier) {
		mShortCutModifier = inModifier;
	}
	
	public String getShortCutModifier() {
		return mShortCutModifier;
	}
	
	public void setClassName(String inClassName) {
		mClassName = inClassName;
	}
	
	public String getClassName() {
		return mClassName;
	}
	
	protected final java.util.EventListener createEventListener() 
										throws ActionNotFoundException
	{
		java.util.EventListener aListener = null;
		
		try {
			Class aClass = Class.forName(mClassName);
			
			aListener = (java.util.EventListener)aClass.newInstance();
		}
		catch (ClassNotFoundException e) {
			System.out.println("The specified action class is no existance");
			throw new ActionNotFoundException(mClassName);
		}
		catch (InstantiationException e) {
			System.out.println("The specified action class could not be instantiated");					
			throw new ActionNotFoundException(mClassName);
		}
		catch (IllegalAccessException e) {
			System.out.println("Could not be accessed in the default constructor");
			throw new ActionNotFoundException(mClassName);
		}
		
		return aListener;
	}
	
	public String toString() {
		String aShortcut = "";
		
		if (mShortcut.length() != 0) {
			aShortcut = ", shortcut : CTRL + ";
			if (mShortCutModifier.length() != 0) {
				aShortcut += mShortCutModifier + " + ";
			}
			aShortcut += mShortcut;
		}
		
		return "item name : " + mName + 
				aShortcut + 
				", action class : " + mClassName;
	}
}
	
