/*
 * Comparison.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

/**
 * r@\𐷂荞񂾃[eBeBNXłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class Comparison {

    /** o[WrŊSvlłB */
    public static final int VERSION = 0;
    /** o[Wrňȍ~vlłB */
    public static final int VERSION_SINCE = 1;
    /** o[WrňȑOvlłB */
    public static final int VERSION_BEFORE = 2;
    /** OS rŗp Windows ̎ʒlłB */
    public static final int OS_WINDOWS = 0;
    /** OS rŗp Linux ̎ʒlłB */
    public static final int OS_LINUX = 1;
    // public static final int OS_MAC = 2;

    /**
     * w肳ꂽo[W̔rs܂B
     * o[W̃tH[}bgn.n.nin͐̐A.(hbg)͋؂蕶jƂ܂B
     * o[W̌int^͈̔͂łΉł܂܂񂪁A
     * ro[WmقȂ錅̏ꍇ́A
     * ̑傫قɍ킹ăo[Wr܂B
     * ̍ہȀȂo[W̕sɂ0܂B
     * <br><br>
     * o[W̔rɂ͈ȉ̎ނ܂B
     * <ul>
     * <li>o[WSv
     * <br>w肵Q̃o[WSɈvĂ邩ǂr܂B</li>
     * <li>o[Wȍ~v
     * <br>Ώۂ̃o[Wro[WƊSvA
     * ͔ro[Wł邩ǂr܂B</li>
     * <li>o[WȑOv
     * <br>Ώۂ̃o[Wro[Wł邩ǂr܂B</li>
     * </ul>
     * 
     * @param version ΏۂƂȂo[W
     * @param comparison ro[W
     * @param delim o[W̋؂蕶
     * @param param o[Wr
     * @return r𖞂o[Wł trueAȂ false
     * @throws IllegalArgumentException
     *          version, comparison, delim󕶎Ao[Wrsȏꍇ
     * @throws NullPointerException
     *          version, comparison, delimnull̏ꍇ
     * @throws NumberFormatException
     *          version, comparison؂蕶ĐȊOō\Ăꍇ
     * @since 2.0
     */
    public static boolean version(String version, String comparison, String delim, int param) {
        if(version == null || comparison == null || delim == null){
            throw new NullPointerException("Arguments are null.");
        } else if (version.length() == 0 || comparison.length() == 0 || delim.length() == 0) {
            throw new IllegalArgumentException("Arguments are illegal-values.");        	
        }
        
        if (param != VERSION_SINCE && param != VERSION && param != VERSION_BEFORE) {
            throw new IllegalArgumentException("The param is invalid value.");
        }
        
        // o[W̊eƂɊi[̔z擾
        int[] intVersion = getToIntArray(StringUtil.split(version, delim));
        int[] intComparison = getToIntArray(StringUtil.split(comparison, delim));
        
        // o[W̍ő包擾
        int len = Math.max(intVersion.length, intComparison.length);

        // o[Wr͊eƂɍs
        for(int i = 0; i < len; i++){
            int v = (i < intVersion.length) ? intVersion[i] : 0;
            int s = (i < intComparison.length) ? intComparison[i] : 0;            

            if (param == VERSION_SINCE) {
                if (v < s) {
                    return false;
                } else if (v > s) {
                    return true;
                }
            } else if (param == VERSION_BEFORE) {
                if (v > s) {
                    return false;
                } else if (v < s) {
                    return true;
                }
            } else if (param == VERSION) {
                if (v != s) {
                    return false;
                }            
            }
        }

        // w肵o[WƎۂ̃o[WƂ
        if(param == VERSION_SINCE || param == VERSION){
            return true;
        } else {
            return false;
        }
    }
    

    /**
     * OS̔r܂B
     * OSSystemvpeB擾os.nameڂ𗘗p܂B
     * <br><br>
     * rł OS ȉ̂ƂłB
     * <ul>
     * <li>Windows</li>
     * <li>Linux</li>
     * </ul>
     * ݂̎dlłOS̃o[W▼O܂ł͔rł܂B
     * IɂOS̖O܂ł͑Ή\łB
     * 
     * @param osParam OS ̎ʒl
     * @return vtrueAłȂfalse
     * @throws IllegalArgumentException
     *          OS̎ʒlsȏꍇ
     * @since 2.0
     */
    public static boolean os(int osParam) {
        String osName = System.getProperty("os.name");
        osName = osName.toLowerCase();
        if (osParam == OS_WINDOWS) {
            if (osName.startsWith("windows")) {
                return true;
            }
        } else if (osParam == OS_LINUX) {
            if (osName.startsWith("linux")) {
                return true;
            }
        } else {
            throw new IllegalArgumentException("The osParam is invalid value.");            
        }
        return false;
    }
    
    // String z int zɕϊ
    private static int[] getToIntArray(String[] strArray) throws NumberFormatException {
        int[] intArray = new int[strArray.length];
        for (int i = 0; i < strArray.length; i++) {
            intArray[i] = Integer.parseInt(strArray[i]);
        }
        return intArray;
    }


    /**
     * 𐮐ɕϊđ召̔r܂B
     * 傫Ɨ\Sp̕ƏƗ\Sp̕ꂼꐮlɕϊA
     * 召r܂B
     * 
     * @param big r傫Ɨ\鐔̕
     * @param small r鏬Ɨ\鐔̕
     * @return 傫 >  łtrueA傫 <=  ̏ꍇfalse
     * @throws NumberFormatException lŖꍇ
     * @since 2.0
     */
    public static boolean comparisonInteger(String big, String small) {        
        // `FbN
        if (IntegerUtil.isInteger(big) == false || IntegerUtil.isInteger(small) == false) {
            throw new NumberFormatException("Not a integer.");
        }
        return comparisonIntegerLocal(big, small);
    }


    /**
     * 𐮐ɕϊēǂ𔻒肵܂B
     * 
     * @param str1 r镶P
     * @param str2 r镶Q
     * @return Q̕񂪐ƂētrueAȂfalse
     * @throws NumberFotmatException r镶񂪐ł͂Ȃꍇ
     * @since 2.0
     */
    public static boolean equalsInteger(String str1, String str2) {
        // `FbN
        if (IntegerUtil.isInteger(str1) == false || IntegerUtil.isInteger(str2) == false) {
            throw new NumberFormatException("Not a integer.");
        }

        // VOoCgɕϊ
        str1 = StringUtil.toSingleByteString(str1);
        str2 = StringUtil.toSingleByteString(str2);

        // l`FbN
        if(str1.compareTo(str2) == 0) {
            return true;
        }        
        return false;
    }
    

    // `FbNȂ
    static boolean comparisonIntegerLocal(String big, String small) {
        
        // VOoCgɕϊ
        big = StringUtil.toSingleByteString(big);
        small = StringUtil.toSingleByteString(small);
        
        boolean bigSign = IntegerUtil.isNumber(big);
        boolean smallSign = IntegerUtil.isNumber(small);
    
        // `FbN
        // sv̏ꍇ͌ʂ͌܂
        if (bigSign && !smallSign) {
            return true;
        } else if(!bigSign && smallSign) {
            return false;
        }        
    
        String a = null;
        String b = null;
        
        if(bigSign && smallSign){
            a = big;
            b = small;
        } else {
            b = big.substring(1);
            a = small.substring(1);            
        }
    
        // TCYr
        if (a.length() > b.length()) {
            return true;
        } else if (a.length() < b.length()) {
            return false;
        }
    
        for (int i = 0; i < a.length(); i++) {
            if (IntegerUtil.toNumber(a.charAt(i)) < IntegerUtil.toNumber(b.charAt(i))) {
                return false;
            } else if(IntegerUtil.toNumber(a.charAt(i)) > IntegerUtil.toNumber(b.charAt(i))) {
                return true;
            }
        }
        return false;
    }
}
