package jp.hrtdotnet.java.util;

import junit.framework.TestCase;

public class ComparisonTest extends TestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.util.Comparison#version(java.lang.String, java.lang.String, java.lang.String, int)} ̂߂̃eXgE\bhB
     */
    public void testVersion() {
        assertTrue(Comparison.version("1.0.0", "1.0.0", ".", Comparison.VERSION));
        assertTrue(Comparison.version("1.0", "1.0.0", ".", Comparison.VERSION));
        assertFalse(Comparison.version("1.0", "1.0.4", ".", Comparison.VERSION));
        assertFalse(Comparison.version("1.0.4", "1.0", ".", Comparison.VERSION));

        assertTrue(Comparison.version("1.0.0", "1.0.1", ".", Comparison.VERSION_BEFORE));
        assertTrue(Comparison.version("1.0.0", "1.1.0", ".", Comparison.VERSION_BEFORE));
        assertTrue(Comparison.version("1.0.0", "2.0.0", ".", Comparison.VERSION_BEFORE));
        assertFalse(Comparison.version("1.0.1", "1.0.0", ".", Comparison.VERSION_BEFORE));
        assertFalse(Comparison.version("1.1.0", "1.0.0", ".", Comparison.VERSION_BEFORE));
        assertFalse(Comparison.version("2.0.0", "1.0.0", ".", Comparison.VERSION_BEFORE));

        assertFalse(Comparison.version("1.0.0", "1.0.1", ".", Comparison.VERSION_SINCE));
        assertFalse(Comparison.version("1.0.0", "1.1.0", ".", Comparison.VERSION_SINCE));
        assertFalse(Comparison.version("1.0.0", "2.0.0", ".", Comparison.VERSION_SINCE));
        assertTrue(Comparison.version("1.0.1", "1.0.0", ".", Comparison.VERSION_SINCE));
        assertTrue(Comparison.version("1.1.0", "1.0.0", ".", Comparison.VERSION_SINCE));
        assertTrue(Comparison.version("2.0.0", "1.0.0", ".", Comparison.VERSION_SINCE));
        
        try {
            Comparison.version(null, "1.0.0", ".", Comparison.VERSION);
            fail();
        } catch (NullPointerException e) {
        }
        
        try {
            Comparison.version("1.0.0", null, ".", Comparison.VERSION);
            fail();
        } catch (NullPointerException e) {
        }
        
        try {
            Comparison.version("1.0.0", "1.0.0", null, Comparison.VERSION);
            fail();
        } catch (NullPointerException e) {
        }
        
        try {
            Comparison.version("", "1.0.0", ".", Comparison.VERSION);
            fail();
        } catch (IllegalArgumentException e) {
        }
        
        try {
            Comparison.version("1.0.0", "", ".", Comparison.VERSION);
            fail();
        } catch (IllegalArgumentException e) {
        }
        
        try {
            Comparison.version("1.0.0", "1.0.0", "", Comparison.VERSION);
            fail();
        } catch (IllegalArgumentException e) {
        }
        
        try {
            Comparison.version("1.0.0", "1.0.0", ".", -1);
            fail();
        } catch (IllegalArgumentException e) {
        }

        try {
            Comparison.version("a.0.0", "1.0.0", ".", Comparison.VERSION);
            fail();
        } catch (NumberFormatException e) {
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.Comparison#os(int)} ̂߂̃eXgE\bhB
     */
    public void testOs() {
        System.setProperty("os.name", "Windows xxx");
        assertTrue(Comparison.os(Comparison.OS_WINDOWS));
        System.setProperty("os.name", "Linux xxx");
        assertTrue(Comparison.os(Comparison.OS_LINUX));        
    }

    /**
     * {@link jp.hrtdotnet.java.util.Comparison#comparisonInteger(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testComparisonInteger() {
        assertTrue(Comparison.comparisonInteger("1111111", "222"));        
        assertTrue(Comparison.comparisonInteger("RRQRR", "222"));        
        assertTrue(Comparison.comparisonInteger("1111111111111111111", "2111111122"));        
        assertFalse(Comparison.comparisonInteger("111", "2111111122"));        
        assertTrue(Comparison.comparisonInteger("111", "-2111111122"));        
        assertFalse(Comparison.comparisonInteger("-1111111", "222"));        
        
        try {
            Comparison.comparisonInteger("111111aaa1", "222");        
            fail();
        } catch (NumberFormatException e) {            
        }
        try {
            Comparison.comparisonInteger("1111111", "22qqqq2");        
            fail();
        } catch (NumberFormatException e) {            
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.Comparison#equalsInteger(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testEqualsInteger() {
        assertTrue(Comparison.equalsInteger("1234567890123", "1234567890123"));        
        assertTrue(Comparison.equalsInteger("1234567890123", "PQRSTUVWXOPQR"));        
        assertFalse(Comparison.equalsInteger("1234567890123", "12345678901234"));        

        try {
            Comparison.equalsInteger("1111", "aaaa");
            fail();
        } catch (NumberFormatException e) {            
        }

        try {
            Comparison.equalsInteger("aaaa", "1111");
            fail();
        } catch (NumberFormatException e) {            
        }
    }

    /**
     * {@link jp.hrtdotnet.java.util.Comparison#comparisonIntegerLocal(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testComparisonIntegerLocal() {
        //TODO
//        fail("܂Ă܂");
    }
    
}
