/*
 * BooleanUtil.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

/**
 * Boolean֘Ã[eBeBNXłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class BooleanUtil {

    /**
     * boolean^ɕϊ܂B
     * booleanȊOw肳ꂽꍇ́Aw肵ftHgl擾܂B
     * 
     * @param str boolean^ɕϊ镶
     * @param defaultValue ftHglAboolean^ȊOw肳ꂽꍇɕԂbooleanl
     * @return ϊbooleanl
     * @since 2.0
     */
    public static boolean toBoolean(String str, boolean defaultValue){
        return BooleanUtil.toBool(str, new Boolean(defaultValue)).booleanValue();
    }

    /**
     * ̕boolean^ɕϊ܂B
     * ͏ ́utruev,ufalsev̂ꂩłȂ΂Ȃ܂B
     * ɏboolean^ȊOw肳ꂽꍇ́Aw肵ftHgl擾܂B
     * 
     * @param str boolean^ɕϊ镶
     * @param defaultValue ftHglAboolean^ȊOw肳ꂽꍇɕԂbooleanl
     * @return ϊbooleanl
     * @since 2.0
     */
    public static boolean toBooleanLowerCase(String str, boolean defaultValue){
        return BooleanUtil.toBoolLowerCase(str, new Boolean(defaultValue)).booleanValue();
    }

    /**
     * boolean^ɕϊ܂B
     * ͑啶 ́uTRUEv,uFALSEv̂ꂩłȂ΂Ȃ܂B
     * ɑ啶booleanȊOw肳ꂽꍇ́Aw肵ftHgl擾܂B
     * 
     * @param str boolean^ɕϊ镶
     * @param defaultValue ftHglAboolean^ȊOw肳ꂽꍇɕԂbooleanl
     * @return ϊbooleanl
     * @since 2.0
     */
    public static boolean toBooleanUpperCase(String str, boolean defaultValue){
        return BooleanUtil.toBoolUpperCase(str, new Boolean(defaultValue)).booleanValue();
    }

    /**
     * boolean^ɕϊ܂B
     * 
     * @param str boolean^ɕϊ镶
     * @return ϊbooleanl
     * @throws IllegalArgumentException
     *          booleanlɕϊłȂꍇ
     * @since 2.0
     */
    public static boolean toBoolean(String str) throws IllegalArgumentException {
        return BooleanUtil.toBool(str).booleanValue();
    }

    /**
     * boolean^ɕϊ܂B
     * ͏ ́utruev,ufalsev̂ꂩłȂ΂Ȃ܂B
     * 
     * @param str boolean^ɕϊ镶
     * @return ϊbooleanl
     * @throws IllegalArgumentException
     *          booleanlɕϊłȂꍇ
     * @since 2.0
     */
    public static boolean toBooleanLowerCase(String str) throws IllegalArgumentException {
        return BooleanUtil.toBoolLowerCase(str).booleanValue();
    }

    /**
     * boolean^ɕϊ܂B
     * ͑啶 "TRUE","FALSE"̂ꂩłȂ΂Ȃ܂B
     * 
     * @param str boolean^ɕϊ镶
     * @return ϊbooleanl
     * @throws IllegalArgumentException
     *          booleanlɕϊłȂꍇ
     * @since 2.0
     */
    public static boolean toBooleanUpperCase(String str) throws IllegalArgumentException {
        return BooleanUtil.toBoolUpperCase(str).booleanValue();
    }

    /**
     * Boolean^ɕϊ܂B
     * Boolean^ɕϊłȂꍇ́Aw肵ftHgl擾܂B
     * 
     * @param str Boolean^ɕϊ镶
     * @param defaultValue ftHglABooleanɕϊłȂꍇɕԂBooleanIuWFNg
     * @return ϊBoolean^
     * @since 2.0
     */
    public static Boolean toBool(String str, Boolean defaultValue) throws IllegalArgumentException {
        if(BooleanUtil.isBoolean(str) == false){
            return defaultValue;
        }
        return new Boolean(str.toLowerCase());
    }

    /**
     * Boolean^ɕϊ܂B
     * Boolean^ɕϊłȂꍇ́Aw肵ftHgl擾܂B
     * 
     * @param str Boolean^ɕϊ镶
     * @param defaultValue ftHglABooleanɕϊłȂꍇɕԂBooleanIuWFNg
     * @return ϊBoolean^
     * @since 2.0
     */
    public static Boolean toBoolLowerCase(String str, Boolean defaultValue) throws IllegalArgumentException {
        if(BooleanUtil.isBooleanLowerCase(str) == false){
            return defaultValue;
        }
        return new Boolean(str);
    }

    /**
     * Boolean^ɕϊ܂B
     * Boolean^ɕϊłȂꍇ́Aw肵ftHgl擾܂B
     * 
     * @param str Boolean^ɕϊ镶
     * @param defaultValue ftHglABooleanɕϊłȂꍇɕԂBooleanIuWFNg
     * @return ϊBoolean^
     * @since 2.0
     */
    public static Boolean toBoolUpperCase(String str, Boolean defaultValue) throws IllegalArgumentException {
        if(BooleanUtil.isBooleanUpperCase(str) == false){
            return defaultValue;
        }
        return new Boolean(str.toLowerCase());
    }

    /**
     * Boolean^ɕϊ܂B
     * 
     * @param str Boolean^ɕϊ镶
     * @return ϊBoolean^
     * @throws IllegalArgumentException
     *          Boolean^ɕϊłȂꍇ
     * @since 2.0
     */
    public static Boolean toBool(String str) throws IllegalArgumentException {
        if(BooleanUtil.isBoolean(str) == false){
            throw new IllegalArgumentException("Argument is not a boolean-type : " + str);
        }
        return new Boolean(str.toLowerCase());
    }

    /**
     * Boolean^ɕϊ܂B
     * 
     * @param str Boolean^ɕϊ镶
     * @return ϊBoolean^
     * @throws IllegalArgumentException
     *          Boolean^ɕϊłȂꍇ
     * @since 2.0
     */
    public static Boolean toBoolLowerCase(String str) {
        if(BooleanUtil.isBooleanLowerCase(str) == false){
            throw new IllegalArgumentException("Argument(str) is not a boolean-type.");
        }
        return new Boolean(str);
    }

    /**
     * Boolean^ɕϊ܂B
     * 
     * @param str Boolean^ɕϊ镶
     * @return ϊBoolean^
     * @throws IllegalArgumentException
     *          Boolean^ɕϊłȂꍇ
     * @since 2.0
     */
    public static Boolean toBoolUpperCase(String str) {
        if(BooleanUtil.isBooleanUpperCase(str) == false){
            throw new IllegalArgumentException("Argument(str) is not a boolean-type.");
        }
        return new Boolean(str.toLowerCase());
    }

    /**
     * 召ʂȂŕ񂪁Abooleanllǂ̔肵܂B
     * booleanĺutruev,ufalsev̑召ʂȂ̔płB
     * 
     * @param str 肷镶
     * @return boolean boolean^łtrueAȊOȂfalse
     * @since 2.0
     */
    public static boolean isBoolean(String str) {
        if(str == null){
            return false;
        }
        str = str.toLowerCase();
        if (str.equals("true") || str.equals("false")) {
            return true;
        }        
        return false;
    }

    /**
     * ̕񂪁Abooleanllǂ̔肵܂B
     * booleanĺutruev,ufalsev̏̔płB
     * 
     * @param str 肷镶
     * @return boolean boolean^łtrueAȊOȂfalse
     * @since 2.0
     */
    public static boolean isBooleanLowerCase(String str) {
        if(str == null){
            return false;
        }
        if ("true".equals(str) || "false".equals(str)) {
            return true;
        }        
        return false;
    }

    /**
     * 啶̕񂪁Abooleanllǂ̔肵܂B
     * booleanĺuTRUEv,uFALSEv̑啶̔płB
     * 
     * @param str 肷镶
     * @return boolean boolean^łtrueAȊOȂfalse
     * @since 2.0
     */
    public static boolean isBooleanUpperCase(String str) {
        if(str == null){
            return false;
        }
        if ("TRUE".equals(str) || "FALSE".equals(str)) {
            return true;
        }        
        return false;
    }

}
