/*
 * HResourceBundleResources.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.fw.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * ResourceBudlebvNXłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class HResourceBundleResources extends HResources {

    protected ResourceBundle resources = null;

    protected HResourceBundleResources() {
    }

    /**
     * RXgN^B
     * @param baseName 
     * @since 2.0
     */
    public HResourceBundleResources(String baseName) {
        resources = ResourceBundle.getBundle(baseName);
    }

    /**
     * L[ɑ΂l擾܂B
     * @param key L[
     * @return L[ɑ΂l
     * @since 2.0
     */
    public String getString(String key) {
        String ret = null;
        if (key == null) {
            throw new NullPointerException("key is null.");
        }
        try {
            ret = resources.getString(key);
        } catch (MissingResourceException e) {
            ret = null;
        }
        return ret;
    }

}
