package jp.hrtdotnet.java.net;

import java.net.MalformedURLException;
import java.net.URL;

import junit.framework.TestCase;

public class HttpUtilTest extends TestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#setReferer(java.net.HttpURLConnection, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetReferer() {
        fail("܂Ă܂");
    }

    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#getReferer(java.net.HttpURLConnection)} ̂߂̃eXgE\bhB
     */
    public void testGetReferer() {
        fail("܂Ă܂");
    }
    
    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#setUserAgent(java.net.HttpURLConnection, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetUserAgent() {
        fail("܂Ă܂");
    }

    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#getUserAgent(java.net.HttpURLConnection)} ̂߂̃eXgE\bhB
     */
    public void testGetUserAgent() {
        fail("܂Ă܂");
    }

    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#setAuthentication(java.lang.String, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testSetAuthentication() {
        fail("܂Ă܂");
    }

    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#checkFormat(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testCheckFormat() {
        assertTrue(HttpUtil.checkFormat("hTtp://www.sample.co.jp/"));
        assertTrue(HttpUtil.checkFormat("hTtps://www.sample.co.jp/"));
        assertFalse(HttpUtil.checkFormat("ftp://www.sample.co.jp/"));
    }

    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#checkProtocol(java.net.URL)} ̂߂̃eXgE\bhB
     * @throws MalformedURLException 
     * @throws NullPointerException 
     */
    public void testCheckProtocol_URL() throws NullPointerException, MalformedURLException {
        assertTrue(HttpUtil.checkProtocol(new URL("htTp://www.sample.co.jp/")));        
        assertTrue(HttpUtil.checkProtocol(new URL("htTps://www.sample.co.jp/")));
        assertFalse(HttpUtil.checkProtocol(new URL("ftp://www.sample.co.jp/")));                
    }

    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#checkProtocol(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testCheckProtocol_String() {
        assertTrue(HttpUtil.checkProtocol("hTtp"));
        assertTrue(HttpUtil.checkProtocol("httPs"));        
        assertFalse(HttpUtil.checkProtocol("ftp"));        
    }

    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#getExtension(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetExtension() {
        assertEquals("html", HttpUtil.getExtension("http://www.sample.co.jp/abc.html"));
        assertEquals("txt", HttpUtil.getExtension("https://www.sample.co.jp/abc.txt"));
        try {
            assertEquals("html", HttpUtil.getExtension("ftp://www.sample.co.jp/abc.html"));
            fail();
        } catch (IllegalArgumentException e) {            
        }
    }

    /**
     * {@link jp.hrtdotnet.java.net.HttpUtil#isHttpUrl(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testIsHttpUrl() {
        assertTrue(HttpUtil.isHttpUrl("http://wwww "));
        assertTrue(HttpUtil.isHttpUrl("https://www"));
        assertTrue(HttpUtil.isHttpUrl("htTp://wwww "));
        assertTrue(HttpUtil.isHttpUrl("htTps://www"));
        assertFalse(HttpUtil.isHttpUrl(null));
        assertFalse(HttpUtil.isHttpUrl("aaaa"));
    }    
}
