/*
 * FileFormatTest.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */

package jp.hrtdotnet.java.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import jp.hrtdotnet.java.HTestCase;

/**
 *
 * @version 
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 
 */
public class FileFormatTest extends HTestCase {

    private String[] params1 = new String[]{"","","Ȃɂʂ˂","",""};
    private String lineSep1 = "\r\n";
    private String expected1 = "" + lineSep1 + 
        "" + lineSep1 + 
        "" + lineSep1 + 
        "Ă" + lineSep1 + 
        "Ȃɂʂ˂" + lineSep1 +
        lineSep1 +
        lineSep1;

    private String lineSep2 = "\n";
    private String expected2 = "" + lineSep2 + 
        "" + lineSep2 + 
        "" + lineSep2 + 
        "Ă" + lineSep2 + 
        "Ȃɂʂ˂" + lineSep2 +
        lineSep2 +
        lineSep2;

    private String lineSep3 = "\r\n";
    private String expected3 = lineSep3 + 
        "" + lineSep3 + 
        "" + lineSep3 + 
        "" + lineSep3 + 
        lineSep3 +
        "Ă" + lineSep3 + 
        "Ȃɂʂ˂";
    
    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.text.FileFormat#FileFormat(java.io.File, java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     */
    public void testFileFormat() throws IOException {
        File file = new File(testClassResources.getString("file"));
        String fileCharsetName = testClassResources.getString("fileCharsetName");
        FileFormat format = new FileFormat(file, fileCharsetName);
        assertEquals(expected1,format.format(params1));
        
        try {
            new FileFormat(null, fileCharsetName);
            fail();
        } catch (NullPointerException e) {
        }

        try {
            new FileFormat(file, null);
            fail();
        } catch (NullPointerException e) {
        }

        try {
            new FileFormat(file, "");
            fail();
        } catch (IllegalArgumentException e) {
        }
    
        File file2 = new File(testClassResources.getString("file2"));
        format = new FileFormat(file2, fileCharsetName);
        assertEquals(expected3,format.format(params1));
        
        File directory = new File(testClassResources.getString("directory"));
        try {
            format = new FileFormat(directory, fileCharsetName);
            fail();
        } catch (IOException e) {
        }
    }

    public void testFileFormat2() throws IOException {
        File file = new File(testClassResources.getString("file"));
        String fileCharsetName = testClassResources.getString("fileCharsetName");
        FileFormat format = new FileFormat(file, fileCharsetName, "\n");
        assertEquals(expected2,format.format(params1));

        try {
            new FileFormat(null, fileCharsetName, "\n");
            fail();
        } catch (NullPointerException e) {
        }

        try {
            new FileFormat(file, null, "\n");
            fail();
        } catch (NullPointerException e) {
        }

        try {
            new FileFormat(file, "", "\n");
            fail();
        } catch (IllegalArgumentException e) {
        }
    
        try {
            new FileFormat(file, fileCharsetName, null);
            fail();
        } catch (NullPointerException e) {
        }

        try {
            new FileFormat(file, fileCharsetName, "");
            fail();
        } catch (IllegalArgumentException e) {
        }
    
    
    }
    
    /**
     * {@link jp.hrtdotnet.java.text.FileFormat#format(java.lang.Object, java.lang.StringBuffer, java.text.FieldPosition)} ̂߂̃eXgE\bhB
     */
    public void testFormatObjectStringBufferFieldPosition() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.text.FileFormat#parseObject(java.lang.String, java.text.ParsePosition)} ̂߂̃eXgE\bhB
     */
    public void testParseObjectStringParsePosition() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.text.FileFormat#formatToCharacterIterator(java.lang.Object)} ̂߂̃eXgE\bhB
     */
    public void testFormatToCharacterIteratorObject() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.text.FileFormat#parseObject(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testParseObjectString() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.java.text.FileFormat#clone()} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws FileNotFoundException 
     * @throws UnsupportedEncodingException 
     */
    public void testClone() throws UnsupportedEncodingException, FileNotFoundException, IOException {
        File file = new File(testClassResources.getString("file"));
        String fileCharsetName = testClassResources.getString("fileCharsetName");
        FileFormat format = new FileFormat(file, fileCharsetName);
        format.clone();
    }

}
