/**
 * 
 */
package jp.hrtdotnet.fw.util;

import java.io.FileNotFoundException;
import java.io.IOException;

import jp.hrtdotnet.java.HTestCase;

public class HPropertyResourcesTest extends HTestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HPropertyResources#getString(java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws FileNotFoundException 
     */
    public void testGetString() throws FileNotFoundException, IOException {
        HPropertyResources prop = new HPropertyResources("src/test/resources/jp/hrtdotnet/fw/util/HPropertyResourcesTest.properties");
        assertEquals("eXgP", prop.getString("test1"));
        assertEquals(true, prop.getBoolean("test2"));
        assertEquals(1234, prop.getInt("test3"));
        try {
            prop.getInt(null);
            fail();
        } catch (NullPointerException e) {
            
        }
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HPropertyResources#HPropertyResources()} ̂߂̃eXgE\bhB
     */
    public void testHPropertyResources() {
        //sv
    }

    /**
     * {@link jp.hrtdotnet.fw.util.HPropertyResources#HPropertyResources(java.lang.String)} ̂߂̃eXgE\bhB
     * @throws IOException 
     * @throws FileNotFoundException 
     */
    public void testHPropertyResourcesString() throws FileNotFoundException, IOException {
        new HPropertyResources("src/test/resources/jp/hrtdotnet/fw/util/HPropertyResourcesTest.properties");
        
        try {
            new HPropertyResources("hogehoge");
            fail();
        } catch (FileNotFoundException e) {
        }
    }

}
