<?xml version="1.0" encoding="UTF-8"?>

<!--
 +======================================================================+
 | S3 interface.xsl v0.8                                        XSLT1.0 |
 +======================================================================+
 | Distributed at http://www.arielworks.net/works/codeyard/sdf/s3       |
 +======================================================================+
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:sm="http://www.arielworks.net/works/codeyard/sitemap"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/"
                              exclude-result-prefixes="sdf s3 sm xsi dc dcterms">

<xsl:output omit-xml-declaration="no" version="1.0" method="xml" indent="no" encoding="UTF-8"/>

<xsl:param name="s3:web_domain" select="'ishikawa.arielworks.com'"/>
<xsl:param name="s3:web_root" select="'/'"/>
<xsl:param name="processor_root" select="'/'"/>

<!-- Hack for PHP5.0.0 -->
<xsl:param name="s3:processor_root" select="$processor_root"/>


<!-- head要素内に追加する要素 -->
<xsl:template name="s3:meta_extended">
    <link rel="stylesheet" href="/template/rr103" media="all" type="text/css" title="R.R103"/>
    <link rel="shortcut icon" href="/favicon" type="image/x-icon"/>
</xsl:template>



<!-- 表示するメタデータを指定 -->
<xsl:template name="s3:show_status_item">
    <dl>
        <xsl:if test="/sdf:document/sdf:meta/dcterms:created and not(/sdf:document/sdf:meta/dcterms:created/@s3:visibility = 'hidden')">
            <dt>
                <xsl:choose>
                    <xsl:when test="lang('ja')">制作日</xsl:when>
                    <xsl:otherwise>Created</xsl:otherwise>
                </xsl:choose>
            </dt>
            <dd>
                <xsl:value-of select="substring(/sdf:document/sdf:meta/dcterms:created, 0, 11)"/>
            </dd>
        </xsl:if>
        <xsl:if test="/sdf:document/sdf:meta/dcterms:modified and not(/sdf:document/sdf:meta/dcterms:modified/@s3:visibility = 'hidden')">
            <dt>
                <xsl:choose>
                    <xsl:when test="lang('ja')">最終更新日</xsl:when>
                    <xsl:otherwise>Last Modified</xsl:otherwise>
                </xsl:choose>
            </dt>
            <dd>
                <xsl:value-of select="substring($s3:modifiedDatetime, 0, 11)"/>
            </dd>
        </xsl:if>
        <dt>
            <xsl:choose>
                <xsl:when test="lang('ja')">参照用URI</xsl:when>
                <xsl:otherwise>URI</xsl:otherwise>
            </xsl:choose>
        </dt>
        <dd>
            <xsl:call-template name="s3:show_uri"/>
        </dd>
    </dl>
</xsl:template>


<!-- ヘッダ追加用テンプレート -->
<xsl:template name="s3:show_head">
</xsl:template>

<!-- フッタ追加用テンプレート -->
<xsl:template name="s3:show_foot">
    <address>
        <xsl:choose>
                <xsl:when test="/sdf:document/@xml:lang = 'ja'">連絡先、リンク、転載や複製などについては『<a href="/about">サイト案内</a>』をご覧ください。</xsl:when>
                <xsl:otherwise>Note: Most of the pages in this site are written in Japanese. <a href="/about">About this site.</a></xsl:otherwise>
        </xsl:choose>
        <a href="http://www.arielworks.net/works/codeyard/himmel">
            <img src="/himmel/logo" alt="Powered by HIMMEL"/>
        </a>
    </address>
</xsl:template>


<!-- objectはimgに -->
<xsl:template match="xh:object[starts-with(./@type, 'image') and not(./@type = 'image/svg+xml')]">
    <img src="{./@data}" alt="{.}"/>
</xsl:template>

<!-- set xml:preserve to xh:pre -->
<xsl:template match="xh:pre">
    <pre xml:space="preserve"><xsl:apply-templates select="./@*"/><xsl:apply-templates/></pre>
</xsl:template>



<!-- blockquote要素は引用元を表示 -->
<xsl:template match="xh:blockquote[not(ancestor::xh:blockquote)]">
    <blockquote>
        <xsl:apply-templates select="./@*"/>
        <xsl:apply-templates/>
    </blockquote>
    <xsl:if test="./@title">
        <p class="citation-origin">
            <xsl:text>『</xsl:text>
            <cite>
                <xsl:choose>
                    <xsl:when test="./@cite">
                        <a href="{./@cite}">
                            <xsl:value-of select="./@title"/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="./@title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </cite>
            <xsl:text>』より引用。</xsl:text>
        </p>
    </xsl:if>
</xsl:template>

</xsl:stylesheet>