<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:param name="nidx:targets_dom" select="/nidx:index/nidx:note[@year = $nidx:year]"/>

<xsl:template match="/nidx:index">
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title><xsl:value-of select="$nts:settings/nts:value[@name = 'siteName']"/>
            <xsl:text>::</xsl:text>
            <xsl:value-of select="$nidx:year"/></dc:title>
            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="$nidx:targets_dom"/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="$nidx:targets_dom"/>
            </xsl:call-template>
        </sdf:meta>
        <sdf:body>
            <ul>
                <xsl:for-each select="$nidx:targets_dom[not(@month = preceding-sibling::nidx:note/@month)]">
                    <xsl:sort select="./@month" data-type="number"/>
                    <li>
                        <a>
                            <xsl:attribute name="href">
                                <xsl:value-of select="concat('./', @year, '/', @month)"/>
                            </xsl:attribute>
                            <xsl:value-of select="./@year"/>-<xsl:value-of select="./@month"/>
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
        </sdf:body>
    </sdf:document>
</xsl:template>

</xsl:stylesheet>