<?php
class Xnm_DataController {
    protected $index;
    protected $indexXpath;

    public function __construct($forceClearCahce = FALSE) {
        $this->buildIndex();
        $this->indexXpath = new DomXpath($this->index);
        Hml_Util::registerBasicNs($this->indexXpath);
    }

    public function getIndex() {
        return $this->index; 
    }

    protected function buildIndex() {
        $indexDom = new DomDocument();
        $nodeIndex = $indexDom->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "index"));

        $it = $this->getItratorToBuildIndex();
        while ($it->hasNext()) {
            $currentNote = $it->next();
            $currentNoteDom = $currentNote["dom"];
            $currentNoteXpath = new DomXpath($currentNoteDom);
            hml_Util::registerBasicNs($currentNoteXpath);
            $nodeNote = $nodeIndex->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "note"));
            $dtW3c = $currentNoteXpath->query("/nt:note/dcterms:created/text()")->item(0)->nodeValue;
            $dtTimestamp = Hml_Util::parseW3cdtf($dtW3c);
            $nodeNote->setAttribute("internal_id", $currentNote["internalId"]);
            $nodeNote->setAttribute("timestamp", $dtTimestamp);
            // Hack for date() and gmdate(); we can choose only GMT(UTC) or system local timezone. 
            $dtUserLocalTimestamp = gmmktime(gmdate("H", $dtTimestamp), gmdate("i", $dtTimestamp) + 540, gmdate("s", $dtTimestamp), gmdate("m", $dtTimestamp), gmdate("d", $dtTimestamp), gmdate("Y", $dtTimestamp));
            $nodeNote->setAttribute("year", gmdate("Y", $dtUserLocalTimestamp));
            $nodeNote->setAttribute("month", gmdate("m", $dtUserLocalTimestamp));
            $nodeNote->setAttribute("day", gmdate("d", $dtUserLocalTimestamp));
            $nodeNote->setAttribute("hour", gmdate("H", $dtUserLocalTimestamp));
            $nodeNote->setAttribute("minute", gmdate("i", $dtUserLocalTimestamp));
            $nodeNote->setAttribute("second", gmdate("s", $dtUserLocalTimestamp));
            $otherMetaElements = $currentNoteXpath->query("/nt:note/*[not(namespace-uri(.) = '" . Hml_Util::getNsUri("nt") .  "' and local-name() = 'body')]");
            for($i = 0; $otherMetaElements->item($i); $i++) {
                $nodeNote->appendChild($indexDom->importNode($otherMetaElements->item($i), TRUE));
            }
        }
        $this->index = $indexDom;
    }
}
?>