<?php
class Xnm_DataManager {
    private static $dataControllerInstance = NULL;

    public static function getInstance() {
        if (self::$dataControllerInstance === NULL) {
            self::$dataControllerInstance = new Xnm_DataControllerFileSystemRNote();
        }
        return self::$dataControllerInstance;
    }

    public static function document($internalId) {
        return self::$dataControllerInstance->loadData($internalId);
    }

    public static function getLatestModified($node) {
        $dom = new DomDocument();
        $tgt = $dom->importNode($node[0], TRUE);
        $dom->appendChild($tgt);
        $xp = new DomXpath($dom);
        Hml_Util::registerBasicNS($xp);
        $cDt = $xp->query("/nidx:note/dcterms:created")->item(0)->nodeValue;
        if ($mDt = $xp->query("/nidx:note/dcterms:modified")->item(0)->nodeValue) {
            $latest = max(Hml_Util::parseW3cdtf($cDt), Hml_Util::parseW3cdtf($mDt));
        } else {
            $latest = Hml_Util::parseW3cdtf($cDt);
        }
        
        return $latest;
    }
}
?>