<?php
class Hml_OutputManager {
    private $extensionRuleList = array(
        "html" => array("application/xhtml+xml", "text/html")
    );
    private $acceptRuleList = array(
        "application/xhtml+xml" => "Hml_OutputDefinitionXhtml11",
        "text/html"             => "Hml_OutputDefinitionXhtml10",
        "application/rss+xml"   => "Hml_OutputDefinitionRss10",
        "*/*"                   => "Hml_OutputDefinitionXhtml10"
    );
    private $outputDefinition = NULL;

    public function __construct() {
        if (preg_match('!/[^/]+\.(.+?)$!', $_SERVER["PATH_INFO"], $ext)) {
            if (array_key_exists($ext[1], $this->extensionRuleList)) {
                $acceptList["1.0"] = $this->extensionRuleList[$ext[1]];
            }
        } else {
            $acceptListWithQuality = explode(",", $_SERVER["HTTP_ACCEPT"]);
            $acceptList = array();
            foreach ($acceptListWithQuality as $anAccept) {
                $anAcceptFragments = explode(";", $anAccept);
                if ($anAcceptFragments[1] == "") {
                    $quality = "1.0";
                } else {
                    $quality = substr($anAcceptFragments[1], 2);
                }
                if (! array_key_exists($quality, $acceptList)) {
                    $acceptList[$quality] = array($anAcceptFragments[0]);
                } else {
                    $acceptList[$quality][] = $anAcceptFragments[0];
                }
            }
        }
        krsort($acceptList);
        $this->outputDefinition = new Hml_OutputDefinitionXhtml10();
        foreach ($acceptList as $aQuality) {
            foreach ($this->acceptRuleList as $mimeName => $className) {
                if (in_array($mimeName, $aQuality)) {
                    $this->outputDefinition = new $className();
                    break 2;
                }
            }
        }
    }

    public function output($dataContainer, $statusCode = 200) {
        $hou = new Hml_HttpOutputUnit();
        $hou->setHeader("Vary", "Accept");
        $hou->setStatusCode($statusCode);
        try {
            if ($modified = Hml_Util::parseW3cdtf($dataContainer->getModifiedDatetime())) {
                $hou->setHeader("Last-Modified", gmdate("D, d M Y H:i:s", $modified) . " GMT");
            }
        } catch (Hml_DateFormatNotW3cdtfException $e) {
            // ERRORRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR
        }
        $this->outputDefinition->setSource($dataContainer);
        $this->outputDefinition->outputToHttp($hou);
        $hod = new Hml_HttpOutputDirector();
        $hod->output($hou);
    }
}
?>