<?php
/**
 * @author  Arielworks
 * @access public
 * @version 1.2.0
 * @license Public Domain
 */
class Hml_OutputDefinitionXhtml11 extends Hml_OutputDefinition {
    protected $encoding              = "UTF-8";
    protected $xmlBeautifier         = TRUE;
    protected $xhtmlHacks            = TRUE;
    protected $ie6XmlDeclarationHack = TRUE;
    protected $validXslPath          = "Hml_OutputDefinitionXhtml11/valid11.xsl";
    protected $mimeType              = "application/xhtml+xml";

    public function outputToHttp($outputUnit) {
        $msgBody = $this->makeMassageBody();
        $outputUnit->setMassageBody($msgBody);
        $outputUnit->setHeader("Content-Type", $this->mimeType . "; " . $this->encoding);
        $outputUnit->setHeader("Content-Style-Type", "text/css");
        $outputUnit->setHeader("Content-Script-Type", "text/javascript");
    }

    protected function makeMassageBody() {
        $resultDom = $this->transformSdf($this->sourceContainer);
        $resultStr = $resultDom->saveXML();
        if ($this->xmlBeautifier) {
            $resultStr = $this->applyBeautifier($resultStr);
        }
        if ($this->xhtmlHacks) {
            $resultStr = $this->hackXhtml($resultStr);
        }
        if ($this->ie6XmlDeclarationHack) {
            $resultStr = $this->hackIe6($resultStr);
        }
        return $resultStr;
    }

    protected function transformSdf($sourceContainer) {
        $nsS3 = "http://www.arielworks.net/works/codeyard/sdf/s3";

        $paramForXslt = array(
            array($nsS3, "processorRoot", ""),
            array($nsS3, "modifiedDatetime", $sourceContainer->getModifiedDatetime()),
            array($nsS3, "debugMode", ini_get("error_reporting") ? "yes" : "no") //Error reporting in XSLT
        );
        $result = $this->xsltDomAndFile($sourceContainer->getData(), "Hml_OutputDefinitionXhtml11/s3/s3.xsl", $paramForXslt);
        return $result;
    }

    protected function applyBeautifier($source) {
        // indent
        $indentDom = new DomDocument();
        $indentDom->preserveWhiteSpace = FALSE;
        $indentDom->loadXML($source);
        $indentDom = $this->xsltDomAndFile($indentDom, "Hml_OutputDefinitionXhtml11/indent.xsl");
        // clean up namespace
        $cnsDom = $this->xsltDomAndFile($indentDom, $this->validXslPath);
        return $cnsDom->saveXML();
    }

    protected function xsltDomAndFile($xmlDom, $xslFilePath, $parameters = array()) {
        $domXsl = new Domdocument();
        $domXsl->load(dirname(__FILE__) . "/" . $xslFilePath);

        $xsltp = new XsltProcessor();
        $xsltp->importStyleSheet($domXsl);
        foreach ($parameters as $aParam) {
            $xsltp->setParameter($aParam[0], $aParam[1], $aParam[2]);
        }
        return $xsltp->transformToDoc($xmlDom);
    }

    protected function hackXhtml($source) {
        $result = preg_replace("/<textarea([^>]*?)\/>/is", "<textarea$1></textarea>", $source);
        $result = preg_replace("/<script([^>]*?)\/>/is", "<script$1></script>", $result);
        $result = preg_replace("/(<[^>]*?[^ ])\/>/is", "$1 />", $result);
        return $result;
    }

    protected function hackIe6($source) {
        if (preg_match("/MSIE 6.0/", $_SERVER["HTTP_USER_AGENT"])) {
            $result = preg_replace("/<\?xml.*?\?>(\n)?/", "", $source);
        } else {
            $result = $source;
        }
        return $result;
    }
}
?>