<?php
class Hml_HttpOutputDirector {

    function output($outputUnit) {
        foreach ($outputUnit->getHeaderList() as $fieldName => $fieldValue) {
            header($fieldName . ": " . $fieldValue);
        }

        $flagOutputBody = TRUE;
        $httpHeaderList = apache_request_headers();
        if ($httpHeaderList["If-Modified-Since"] && $outputUnit->getHeader("Last-Modified")) {
            $timestampIms = $this->parseHttpDate($httpHeaderList["If-Modified-Since"]);
            $timestampLm = $this->parseHttpDate($outputUnit->getHeader("Last-Modified"));
            if ($timestampIms == $timestampLm) {
                header("HTTP/1.1 304 Not Modified");
                $flagOutputBody = FALSE;
            }
        }

        if ($flagOutputBody) {
            ob_start("ob_gzhandler");
            print $outputUnit->getMassageBody();
            ob_end_flush();
        }
    }

    protected function parseHttpDate($dateStr) {
        $defMonth = array(
            "01" => "Jan", "02" => "Feb", "03" => "Mar",
            "04" => "Apr", "05" => "May", "06" => "Jun",
            "07" => "Jul", "08" => "Aug", "09" => "Sep",
            "10" => "Oct", "11" => "Nov", "12" => "Dec"
        );

        if (preg_match('/^(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun), ([0-3][0-9]) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ([0-9]{4}) ([0-2][0-9]):([0-5][0-9]):([0-5][0-9]) GMT$/', $dateStr, $dateFragments)) {
            $date["hour"] = $dateFragments[4];
            $date["minute"] = $dateFragments[5];
            $date["second"] = $dateFragments[6];
            $date["month"] = array_search($dateFragments[2], $defMonth);
            $date["day"] = $dateFragments[1];
            $date["year"] = $dateFragments[3];
        } elseif (preg_match('/^(?:Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), ([0-3][0-9])-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-([0-9]{2}) ([0-2][0-9]):([0-5][0-9]):([0-5][0-9]) GMT$/', $dateStr, $dateFragments)) {
            $date["hour"] = $dateFragments[4];
            $date["minute"] = $dateFragments[5];
            $date["second"] = $dateFragments[6];
            $date["month"] = array_search($dateFragments[2], $defMonth);
            $date["day"] = $dateFragments[1];
            $date["year"] = 1900 + $dateFragments[3];
        } elseif (preg_match('/^(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ([0-3 ][0-9]) ([0-2][0-9]):([0-5][0-9]):([0-5][0-9]) ([0-9]{4})$/', $dateStr, $dateFragments)) {
            $date["hour"] = $dateFragments[3];
            $date["minute"] = $dateFragments[4];
            $date["second"] = $dateFragments[5];
            $date["month"] = array_search($dateFragments[1], $defMonth);
            $date["day"] = str_replace(" ", 0, $dateFragments[2]);
            $date["year"] = $dateFragments[6];
        } else {
            return FALSE;
        }
        $timestamp = gmmktime($date["hour"], $date["minute"], $date["second"], $date["month"], $date["day"], $date["year"]);
        return $timestamp;
    }
}
?>