
SET client_encoding = 'SQL_ASCII';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- cc_snmp_trap_info
--
ALTER TABLE cc_snmp_trap_info ADD COLUMN check_mode smallint;

--
-- cc_monitor_snmp_info
--
ALTER TABLE cc_monitor_snmp_info ADD COLUMN snmp_prot integer;
ALTER TABLE cc_monitor_snmp_info ADD COLUMN snmp_version varchar(64);

UPDATE ONLY cc_monitor_snmp_info SET snmp_port = 161;
UPDATE ONLY cc_monitor_snmp_info SET snmp_version = 2c;

ALTER TABLE cc_monitor_snmp_info ALTER snmp_port SET NOT NULL;
ALTER TABLE cc_mmonitor_snmp_info ALTER snmp_version SET NOT NULL;

--
-- cc_event_log
--
DROP INDEX idx_event_log_1;
DROP INDEX idx_event_log_2;

CREATE INDEX idx_event_log_2 on cc_event_log(monitor_id,plugin_id,generation_date,facility_id,inhibited_flg);
CREATE INDEX idx_event_log_3 on cc_event_log(output_date);
CREATE INDEX idx_event_log_4 on cc_event_log(confirm_flg,priority,facility_id,output_date);

--
-- cc_crun_param_mst
--
INSERT INTO cc_crun_param_mst(param_id, name_id, param_type)VALUES('ARCHITECTURE','os.architecture',2);

--
-- cc_crun_param_select_mst
--
INSERT INTO cc_crun_param_select_mst(param_id,order_no,name_id,param_value) VALUES('ARCHITECTURE',0,'RHEL4','rhel4');
INSERT INTO cc_crun_param_select_mst(param_id,order_no,name_id,param_value) VALUES('ARCHITECTURE',1,'RHEL4(64bit)','rhel4_64');

UPDATE ONLY cc_crum_cmd_param_mst SET param_id='ARCHITECTURE',param_prefix='-o' where command_id='AGENT_INSTALL' and order_no = 0;
UPDATE ONLY cc_crum_cmd_param_mst SET param_id='MANAGER_IP',param_prefix='-i' where command_id='AGENT_INSTALL' and order_no = 1;
UPDATE ONLY cc_crum_cmd_param_mst SET param_id='MANAGER_ROOT_PASSWORD',param_prefix='-p' where command_id='AGENT_INSTALL' and order_no = 2;
UPDATE ONLY cc_crum_cmd_param_mst SET param_id='AGENT_PATH',param_prefix='-a' where command_id='AGENT_INSTALL' and order_no = 3;
UPDATE ONLY cc_crum_cmd_param_mst SET param_id='AGENT_PLACE',param_prefix='-w' where command_id='AGENT_INSTALL' and order_no = 4;
UPDATE ONLY cc_crum_cmd_param_mst SET param_id='JRE_LICENCE',param_prefix='-j' where command_id='AGENT_INSTALL' and order_no = 5;

INSERT INTO cc_crum_cmd_param_mst (command_id,param_id,order_no,param_prefix)VALUES('AGENT_INSTALL,'COLLECTICERUN_MEAN',6,'-c');

