#!/usr/bin/perl

use strict;
use warnings;
use DBI;

my $dbname   = "hinemos";
my $host     = $ARGV[0];
my $port     = $ARGV[1];
my $username = $ARGV[2];
my $password = $ARGV[3];

my $interval   = $ARGV[4];
my $confirmed  = $ARGV[5];
my @facilityid = splice(@ARGV , 6);

my @now = localtime(time);
my $nowstr = sprintf("%04d%02d%02d%02d%02d%02d", 
                     $now[5]+1900, $now[4]+1, $now[3], $now[2], $now[1], 0);

my $dbh = DBI->connect("dbi:Pg:dbname=$dbname;host=$host;port=$port;", 
                       $username, $password);
if(!$dbh){
  print "info:U warning:U critical:U unknown:U total:U\n";
  exit 1;
}

eval {
  &getValue();
};
if ( $@ ){
  print "info:U warning:U critical:U unknown:U total:U\n";
}

$dbh->disconnect;

exit 0;


sub getValue ()
{
  my $sql = "SELECT priority, COUNT(output_date) FROM cc_event_log ";

  if ($interval >= 0) {
    $sql .= "WHERE output_date BETWEEN to_timestamp('$nowstr', 'yyyymmddhh24miss') - interval '$interval second' ".
            "AND to_timestamp('$nowstr', 'yyyymmddhh24miss') "
  }
  
  if($#facilityid >= 0) {
    my $where = "";
    
    if ($sql =~ /.*WHERE.*/) {
      $where .= "AND facility_id IN (";
    }
    else{
      $where .= "WHERE facility_id IN (";
    }

    foreach my $id (@facilityid){
      if ($where =~ /.*'/) {
        $where .= ", ";
      }
      $where .= "'$id'";
    }
    $sql .= $where.") ";
  }
  
  if($confirmed == 0 || $confirmed == 1){
    if ($sql =~ /.*WHERE.*/) {
      $sql .= "AND confirm_flg = $confirmed ";
    } else {
      $sql .= "WHERE confirm_flg = $confirmed ";
    }
  }

  $sql .= "GROUP BY priority;";

  my $sth = $dbh->prepare($sql);
  $sth->execute;

  my $info     = 0;
  my $warning  = 0;
  my $critical = 0;
  my $unknown  = 0;
  my $total    = 0;

  while ( my @rows = $sth->fetchrow_array ) {
    if ($rows[0] == 0){
      $critical += $rows[1];
    } elsif($rows[0] == 1) {
      $unknown += $rows[1];
    } elsif($rows[0] == 2) {
      $warning += $rows[1];
    } elsif($rows[0] == 3) {
      $info += $rows[1];
    }
    $total += $rows[1];
  }
  print "info:$info warning:$warning critical:$critical unknown:$unknown total:$total\n";
}
