#!/usr/bin/perl

use strict;
use warnings;
use DBI;

my $dbname   = "hinemos";
my $host     = $ARGV[0];
my $port     = $ARGV[1];
my $username = $ARGV[2];
my $password = $ARGV[3];

my $collectorid = $ARGV[4];
my $interval    = $ARGV[5];
my $offset      = $ARGV[6];
my $facilityid  = $ARGV[7];
my @itemcode    = splice(@ARGV , 8);

my @now = localtime(time);
my $nowstr = sprintf("%04d%02d%02d%02d%02d%02d", 
                     $now[5]+1900, $now[4]+1, $now[3], $now[2], $now[1], 0);

sleep($offset);

my $dbh = DBI->connect("dbi:Pg:dbname=$dbname;host=$host;port=$port;", 
                       $username, $password);
if(!$dbh){
  for(my $i = 0; $i <= $#itemcode; $i++){
    print "value",$i+1,":U ";
  }
  print "\n";
  exit 1;
}

for(my $i = 0; $i <= $#itemcode; $i++){
  eval {
    my $value = &getValue($itemcode[$i]);
    print "value",$i+1,":$value ";
  };
  if ( $@ ){
    print "value",$i+1,":U ";
  }
}
print "\n";

$dbh->disconnect;

exit 0;


sub getValue ()
{
  my $itemcode = $_[0];

  my $sql = "SELECT value FROM calculated_data ".
            "WHERE date_time BETWEEN to_timestamp('$nowstr', 'yyyymmddhh24miss') - interval '$interval second' ".
            "AND to_timestamp('$nowstr', 'yyyymmddhh24miss') ".
            "AND facilityid = '$facilityid' ".
            "AND item_code = '$itemcode' ".
            "AND collectorid like '$collectorid' ".
            "ORDER BY date_time DESC LIMIT 1 ;";

  my $sth = $dbh->prepare($sql);
  $sth->execute;

  if ( my @rows = $sth->fetchrow_array ) {
    if (defined $rows[0]) {
      return $rows[0];
    } else {
      return "U";
    }
  }
  else {
    return "U";
  }
}
