/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.composite;

import com.clustercontrol.accesscontrol.action.GetUserList;
import com.clustercontrol.accesscontrol.action.GetUserListTableDefine;
import com.clustercontrol.accesscontrol.composite.action.UserDoubleClickListener;
import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class UserListComposite
extends Composite {
    protected CommonTableViewer m_viewer = null;
    protected Label m_labelType = null;
    protected Label m_labelCount = null;
    protected String m_uid = null;

    public UserListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_labelType = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelType.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetUserListTableDefine.get(), 0, 1);
        this.m_viewer.addDoubleClickListener(new UserDoubleClickListener(this));
    }

    public void update() {
        ArrayList userInfo = null;
        GetUserList getUserList = new GetUserList();
        userInfo = getUserList.getAll();
        if (userInfo == null) {
            userInfo = new ArrayList();
        }
        this.m_viewer.setInput(userInfo);
        this.m_labelType.setText("");
        Object[] args = new Object[]{new Integer(userInfo.size())};
        this.m_labelCount.setText(Messages.getString("records", args));
    }

    public void update(Property condition) {
        ArrayList userInfo = null;
        GetUserList getUserList = new GetUserList();
        userInfo = getUserList.get(condition);
        this.m_viewer.setInput(userInfo);
        this.m_labelType.setText(Messages.getString("filtered.list"));
        Object[] args = new Object[]{new Integer(userInfo.size())};
        this.m_labelCount.setText(Messages.getString("filtered.records", args));
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getUid() {
        return this.m_uid;
    }

    public void setUid(String uid) {
        this.m_uid = uid;
    }
}

