/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.priority.composite;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PatternComposite
extends Composite {
    protected Combo comboPriority = null;
    protected boolean info = false;
    protected boolean warning = false;
    protected boolean critical = false;
    protected boolean unknown = false;
    protected int priority = 3;

    public PatternComposite(Composite parent, int style, boolean info, boolean warning, boolean critical, boolean unknown, int priority) {
        super(parent, style);
        this.info = info;
        this.warning = warning;
        this.critical = critical;
        this.unknown = unknown;
        this.priority = priority;
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 2;
        layout.marginWidth = 5;
        layout.numColumns = 11;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        if (this.info) {
            label.setText(Messages.getString("info"));
            label.setBackground(PriorityColorConstant.COLOR_INFO);
        } else {
            label.setText(" - ");
        }
        label = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        if (this.warning) {
            label.setText(Messages.getString("warning"));
            label.setBackground(PriorityColorConstant.COLOR_WARNING);
        } else {
            label.setText(" - ");
        }
        label = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        if (this.critical) {
            label.setText(Messages.getString("critical"));
            label.setBackground(PriorityColorConstant.COLOR_CRITICAL);
        } else {
            label.setText(" - ");
        }
        label = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        if (this.unknown) {
            label.setText(Messages.getString("unknown"));
            label.setBackground(PriorityColorConstant.COLOR_UNKNOWN);
        } else {
            label.setText(" - ");
        }
        label = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(" : ");
        this.comboPriority = new Combo((Composite)this, 0x1000008);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboPriority.setLayoutData((Object)gridData);
        if (this.critical) {
            this.comboPriority.add(PriorityConstant.STRING_CRITICAL);
        }
        if (this.warning) {
            this.comboPriority.add(PriorityConstant.STRING_WARNING);
        }
        if (this.info) {
            this.comboPriority.add(PriorityConstant.STRING_INFO);
        }
        if (this.unknown) {
            this.comboPriority.add(PriorityConstant.STRING_UNKNOWN);
        }
        this.comboPriority.setText(PriorityConstant.typeToString(this.priority));
    }

    public int getPriority() {
        return PriorityConstant.stringToType(this.comboPriority.getText());
    }
}

