/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String RESOURCE_BUNDLE = "com.clustercontrol.util.messages";
    private static ResourceBundle m_bundle = ResourceBundle.getBundle("com.clustercontrol.util.messages");

    private Messages() {
    }

    public static ResourceBundle getBundle() {
        return m_bundle;
    }

    public static String getString(String key, Object[] args) {
        return MessageFormat.format(Messages.getString(key), args);
    }

    public static String getString(String key) {
        try {
            return m_bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key, String def) {
        try {
            return m_bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return def;
        }
    }

    public static String getString(String key, Object[] args, Locale locale) {
        return MessageFormat.format(Messages.getString(key, locale), args);
    }

    public static String getString(String key, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key, String def, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return def;
        }
    }
}

