/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.bean;

import com.clustercontrol.performanceMGR.bean.CollectorItemPK;
import com.clustercontrol.performanceMGR.bean.DeviceData;
import com.clustercontrol.performanceMGR.bean.Facility;
import com.clustercontrol.performanceMGR.bean.OIDInfo;
import com.clustercontrol.performanceMGR.util.CalculationMethod;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.performanceMGR.util.Repository;
import com.clustercontrol.sharedtable.bean.ValueObject;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Node
extends Facility {
    protected static Log m_log = LogFactory.getLog(Node.class);
    private HashMap<String, HashMap<Integer, long[]>> m_mibValueSet = new HashMap();
    private long lastCollectTime;

    Node(String facilityID, String faclityName) {
        super(facilityID, faclityName, 2);
    }

    public double calcValue(String itemCode, int deviceIndex, String deviceName) {
        int devIndex = 0;
        if (deviceName != null) {
            Repository repository = new Repository();
            DeviceData device2 = null;
            List<DeviceData> deviceList = repository.getDeviceList(this.m_facilityID);
            for (DeviceData device2 : deviceList) {
                if (deviceName.compareTo(device2.getDeviceName()) != 0) continue;
                devIndex = device2.getDeviceIndex();
                break;
            }
        }
        double value = CalculationMethod.getPerformance(itemCode, devIndex, this.m_mibValueSet);
        m_log.debug((Object)("calcValue() : " + this.m_facilityID + " " + itemCode + " " + deviceName + " " + devIndex + "  " + value));
        if (!Double.isNaN(value)) {
            this.setCalcValueBuffer(new CollectorItemPK(itemCode, devIndex), value);
        }
        return value;
    }

    public long fetchMibValue(OIDInfo[] oids, int interval) {
        m_log.debug((Object)"fetchMibValue() start :");
        HashSet<String> checkOid = new HashSet<String>();
        SnmpSharedTable sst = null;
        try {
            InitialContext iniCtx = JNDIConnectionManager.getInitialContext();
            Object obj = iniCtx.lookup("SnmpPerf");
            sst = (SnmpSharedTable)PortableRemoteObject.narrow((Object)obj, SnmpSharedTable.class);
        }
        catch (NamingException e) {
            throw new EJBException(e.getMessage());
        }
        for (int i = 0; i < oids.length; ++i) {
            if (!oids[i].isAllIndex()) {
                String oid = oids[i].getOID();
                ValueObject value = sst.getValue(this.getFacilityID(), interval, oid);
                if (value == null) {
                    m_log.debug((Object)("Node : " + this.getFacilityID() + " can't get value " + oids[i].getOID()));
                    if (checkOid.contains(oid)) continue;
                    Long defaultValue = oids[i].getDefaultValue();
                    if (defaultValue != null) {
                        this.setMibValueSet(oids[i].getBaseOid(), oids[i].getOidIndex(), defaultValue);
                        if (m_log.isTraceEnabled()) {
                            m_log.trace((Object)("fetchMibValue() : " + this.getFacilityID() + " set default value " + oid + " = " + defaultValue));
                        }
                    } else {
                        this.m_mibValueSet.put(oids[i].getBaseOid(), null);
                        if (m_log.isTraceEnabled()) {
                            m_log.trace((Object)("fetchMibValue() : " + this.getFacilityID() + " set default value " + oid + " = " + defaultValue));
                        }
                    }
                    checkOid.add(oid);
                    continue;
                }
                String mibValueString = (String)value.getValue();
                m_log.debug((Object)("Node : " + this.getFacilityID() + " " + oids[i].getOID() + " " + value));
                if (checkOid.contains(oid)) continue;
                this.setMibValueSet(oids[i].getBaseOid(), oids[i].getOidIndex(), Long.parseLong(mibValueString));
                checkOid.add(oid);
                this.lastCollectTime = Math.max(this.lastCollectTime, value.getDate());
                continue;
            }
            Set set = sst.getValueSet(this.getFacilityID(), interval, oids[i].getBaseOid());
            if (set == null) break;
            Iterator itr = set.iterator();
            if (set.size() != 0) {
                long total = 0L;
                int index = 0;
                long value = 0L;
                while (itr.hasNext()) {
                    ValueObject vo = (ValueObject)itr.next();
                    try {
                        String oidStr = vo.getKey();
                        index = Integer.parseInt(oidStr.substring(oidStr.lastIndexOf(".") + 1));
                        value = Long.parseLong((String)vo.getValue());
                        if (!checkOid.contains(oidStr)) {
                            this.setMibValueSet(oids[i].getBaseOid(), index, value);
                            checkOid.add(oidStr);
                        }
                    }
                    catch (Exception e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    total += value;
                }
                String oidStr = oids[i].getBaseOid() + ".0";
                if (checkOid.contains(oidStr)) continue;
                this.setMibValueSet(oids[i].getBaseOid(), 0, total);
                checkOid.add(oidStr);
                continue;
            }
            m_log.debug((Object)("Node : " + this.getFacilityID() + " can't get value " + oids[i].getBaseOid() + ".*"));
            this.m_mibValueSet.put(oids[i].getBaseOid(), null);
        }
        m_log.debug((Object)"fetchMibValue() end :");
        return this.lastCollectTime;
    }

    private void setMibValueSet(String baseOid, Integer tableIndex, long mibValue) {
        m_log.trace((Object)("setMibValueSet() :" + baseOid + " " + tableIndex + "  " + mibValue));
        HashMap<Integer, Object> mibValueSetList = this.m_mibValueSet.get(baseOid);
        if (mibValueSetList == null) {
            mibValueSetList = new HashMap();
            this.m_mibValueSet.put(baseOid, mibValueSetList);
        }
        if (mibValueSetList.get(tableIndex) == null) {
            long[] buffer = new long[2];
            mibValueSetList.put(tableIndex, buffer);
            this.m_mibValueSet.put(baseOid, mibValueSetList);
        }
        ((long[])mibValueSetList.get((Object)tableIndex))[0] = ((long[])mibValueSetList.get(tableIndex))[1];
        ((long[])mibValueSetList.get((Object)tableIndex))[1] = mibValue;
    }

    public HashSet getNode(HashSet nodeSet) {
        nodeSet.add(this);
        return nodeSet;
    }

    public int getNodeCount() {
        return 1;
    }
}

