/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.snmptrap.bean.SnmpTrapOidInfo;
import com.clustercontrol.snmptrap.factory.TrapSnmpManager;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;
import org.opennms.protocols.snmp.SnmpVarBind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrapSnmp
implements SnmpTrapHandler {
    protected static Log m_log = LogFactory.getLog(TrapSnmp.class);
    private static final String SNMP_SYSUPTIME_OID = ".1.3.6.1.2.1.1.3.0";
    private static final String EXTREME_SNMP_SYSUPTIME_OID = ".1.3.6.1.2.1.1.3";
    private static final String SNMP_TRAP_OID = ".1.3.6.1.6.3.1.1.4.1.0";
    private static final String SNMP_TRAP_ENTERPRISE_ID = ".1.3.6.1.6.3.1.1.4.3.0";
    private static final String SNMP_TRAPS = ".1.3.6.1.6.3.1.1.5";
    private static final ArrayList<SnmpObjectId> GENERIC_TRAPS = new ArrayList();
    private static final int SNMP_TRAP_OID_INDEX = 1;
    private static final char DOT_CHAR = '.';
    protected TrapSnmpManager m_manager = null;
    protected SnmpTrapSession m_trapSession = null;

    public TrapSnmp(TrapSnmpManager manager) {
        this.m_manager = manager;
    }

    public void exec() {
        try {
            this.m_trapSession = new SnmpTrapSession((SnmpTrapHandler)new TrapSnmp(this.m_manager));
            m_log.debug((Object)"SNMP Trap Receiver Started");
        }
        catch (Exception e) {
            m_log.error((Object)("exec : " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void terminate() {
        try {
            if (this.m_trapSession != null) {
                this.m_trapSession.close();
            }
            this.m_trapSession = null;
            m_log.debug((Object)"SNMP Trap Receiver Exiting");
        }
        catch (Exception e) {
            m_log.error((Object)("terminate : " + e.getMessage()));
        }
    }

    public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduPacket pdu) {
        SnmpTrapOidInfo oidInfo;
        ArrayList<String> facilityIdList;
        Date now = new Date();
        m_log.debug((Object)("V2 Trap from agent " + agent.toString() + " on port " + port));
        m_log.debug((Object)("V2 Trap PDU command......... " + pdu.getCommand()));
        m_log.debug((Object)("V2 Trap PDU ID.............. " + pdu.getRequestId()));
        m_log.debug((Object)("V2 Trap PDU Length.......... " + pdu.getLength()));
        if (pdu instanceof SnmpPduRequest) {
            m_log.debug((Object)("V2 Trap PDU Error Status.... " + ((SnmpPduRequest)pdu).getErrorStatus()));
            m_log.debug((Object)("V2 Trap PDU Error Index..... " + ((SnmpPduRequest)pdu).getErrorIndex()));
        }
        if ((facilityIdList = this.getFacilityIdList(agent)) == null || facilityIdList.size() <= 0) {
            m_log.debug((Object)("snmpReceivedTrap() : This is not target Agent. Address:" + agent.getHostAddress() + ", HostName:" + agent.getHostName()));
            facilityIdList = new ArrayList();
            facilityIdList.add("UNREGISTERED");
        }
        if ((oidInfo = this.process(agent, pdu)) != null) {
            String[] varBindValue = new String[pdu.getLength() - 2];
            for (int index = 2; index < pdu.getLength(); ++index) {
                try {
                    varBindValue[index - 2] = pdu.getVarBindAt(index).getValue().toString();
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    m_log.error((Object)("snmpReceivedTrap() V2 : PDU Length:" + pdu.getLength() + " " + e.getMessage()));
                    return;
                }
            }
            this.m_manager.find(now, community.toString(), oidInfo.getTrapOid(), oidInfo.getGenericId(), oidInfo.getSpecificId(), varBindValue, facilityIdList, agent.getHostAddress());
        }
    }

    public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduTrap pdu) {
        Date now = new Date();
        m_log.debug((Object)("V1 Trap from agent " + agent.toString() + " on port " + port));
        m_log.debug((Object)("Ip Address................. " + pdu.getAgentAddress()));
        m_log.debug((Object)("Enterprise Id.............. " + pdu.getEnterprise()));
        m_log.debug((Object)("Generic ................... " + pdu.getGeneric()));
        m_log.debug((Object)("Specific .................. " + pdu.getSpecific()));
        m_log.debug((Object)("TimeStamp ................. " + pdu.getTimeStamp()));
        m_log.debug((Object)("Length..................... " + pdu.getLength()));
        ArrayList<String> facilityIdList = this.getFacilityIdList(agent);
        if (facilityIdList == null || facilityIdList.size() <= 0) {
            m_log.debug((Object)("snmpReceivedTrap() : This is not target Agent. Address:" + agent.getHostAddress() + ", HostName:" + agent.getHostName()));
            facilityIdList = new ArrayList();
            facilityIdList.add("UNREGISTERED");
        }
        int length = pdu.getLength();
        String[] varBindValue = new String[length];
        for (int index = 0; index < length; ++index) {
            SnmpVarBind vb = pdu.getVarBindAt(index);
            varBindValue[index] = vb.getValue().toString();
            m_log.debug((Object)("Varbind[" + index + "] := " + vb.getName().toString() + " --> " + vb.getValue().toString()));
        }
        this.m_manager.find(now, community.toString(), pdu.getEnterprise().toString(), pdu.getGeneric(), pdu.getSpecific(), varBindValue, facilityIdList, agent.getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTrapSessionError(SnmpTrapSession session, int error, Object ref) {
        m_log.error((Object)("snmpTrapSessionError() : An error occured in the trap session. Session error code = " + error));
        if (ref != null) {
            m_log.error((Object)("snmpTrapSessionError() : Session error reference: " + ref.toString()));
        }
        if (error == -1) {
            SnmpTrapSession snmpTrapSession = session;
            synchronized (snmpTrapSession) {
                session.notify();
            }
        }
    }

    private ArrayList<String> getFacilityIdList(InetAddress agent) {
        ArrayList<String> facilityIdList = null;
        String address = agent.getHostAddress();
        m_log.debug((Object)("getFacilityIdList() : Address:" + address));
        if (address != null && !"".equals(address)) {
            facilityIdList = this.m_manager.getFacilityIdListByIpAddress(address);
        }
        if (facilityIdList == null || facilityIdList.size() <= 0) {
            String hostName = agent.getHostName();
            m_log.debug((Object)("getFacilityIdList() : HostName:" + hostName));
            if (hostName != null && !"".equals(hostName)) {
                facilityIdList = this.m_manager.getFacilityIdListByHostName(hostName);
            }
        }
        return facilityIdList;
    }

    private SnmpTrapOidInfo process(InetAddress agent, SnmpPduPacket pdu) {
        SnmpTrapOidInfo snmpInfo = new SnmpTrapOidInfo();
        if (pdu.typeId() != -89) {
            m_log.debug((Object)("process() : Recieved not SNMPv2 Trap from host " + agent.getHostAddress()));
            m_log.debug((Object)("process() : PDU Type = " + pdu.getCommand()));
            return null;
        }
        int numVars = pdu.getLength();
        m_log.debug((Object)("process() : V2 trap numVars or pdu length: " + numVars));
        if (numVars >= 2) {
            String varBindName0 = pdu.getVarBindAt(0).getName().toString();
            String varBindName1 = pdu.getVarBindAt(1).getName().toString();
            if (varBindName0.equals(EXTREME_SNMP_SYSUPTIME_OID)) {
                m_log.info((Object)("process() : V2 trap from " + agent.toString() + " has been corrected due to the sysUptime.0 varbind not having been sent with a trailing 0.\n\tVarbinds received are : " + varBindName0 + " and " + varBindName1));
                varBindName0 = SNMP_SYSUPTIME_OID;
            }
            if (!varBindName0.equals(SNMP_SYSUPTIME_OID) || !varBindName1.equals(SNMP_TRAP_OID)) {
                m_log.info((Object)("process() : V2 trap from " + agent.toString() + " IGNORED due to not having the required varbinds.\n\tThe first varbind must be sysUpTime.0 and the second snmpTrapOID.0\n\tVarbinds received are : " + varBindName0 + " and " + varBindName1));
                return null;
            }
            m_log.debug((Object)("process() : V2 trap first varbind value: " + pdu.getVarBindAt(0).getValue().toString()));
            SnmpObjectId snmpTrapOid = (SnmpObjectId)pdu.getVarBindAt(1).getValue();
            String snmpTrapOidValue = snmpTrapOid.toString();
            if (!snmpTrapOidValue.startsWith(".")) {
                snmpTrapOidValue = "." + snmpTrapOidValue;
            }
            m_log.debug((Object)("process() : snmpTrapOID: " + snmpTrapOidValue));
            int length = snmpTrapOidValue.length();
            int lastIndex = snmpTrapOidValue.lastIndexOf(46);
            String lastSubIdStr = snmpTrapOidValue.substring(lastIndex + 1);
            int lastSubId = -1;
            try {
                lastSubId = Integer.parseInt(lastSubIdStr);
            }
            catch (NumberFormatException nfe) {
                lastSubId = -1;
            }
            if (GENERIC_TRAPS.contains(snmpTrapOid)) {
                snmpInfo.setGenericId(lastSubId - 1);
                snmpInfo.setSpecificId(0);
                String varBindName = pdu.getVarBindAt(numVars - 1).getName().toString();
                if (varBindName.equals(SNMP_TRAP_ENTERPRISE_ID)) {
                    snmpInfo.setTrapOid(pdu.getVarBindAt(numVars - 1).getValue().toString());
                } else {
                    snmpInfo.setTrapOid(".1.3.6.1.6.3.1.1.5." + snmpTrapOidValue.charAt(length - 1));
                }
            } else {
                snmpInfo.setGenericId(6);
                snmpInfo.setSpecificId(lastSubId);
                int nextToLastIndex = snmpTrapOidValue.lastIndexOf(46, lastIndex - 1);
                String nextToLastSubIdStr = snmpTrapOidValue.substring(nextToLastIndex + 1, lastIndex);
                if (nextToLastSubIdStr.equals("0")) {
                    snmpInfo.setTrapOid(snmpTrapOidValue.substring(0, nextToLastIndex));
                } else {
                    snmpInfo.setTrapOid(snmpTrapOidValue.substring(0, lastIndex));
                }
            }
            m_log.debug((Object)("process() : snmp specific/generic/eid: " + snmpInfo.getSpecificId() + "\t" + snmpInfo.getGenericId() + "\t" + snmpInfo.getTrapOid()));
        }
        return snmpInfo;
    }

    static {
        GENERIC_TRAPS.add(new SnmpObjectId("1.3.6.1.6.3.1.1.5.1"));
        GENERIC_TRAPS.add(new SnmpObjectId("1.3.6.1.6.3.1.1.5.2"));
        GENERIC_TRAPS.add(new SnmpObjectId("1.3.6.1.6.3.1.1.5.3"));
        GENERIC_TRAPS.add(new SnmpObjectId("1.3.6.1.6.3.1.1.5.4"));
        GENERIC_TRAPS.add(new SnmpObjectId("1.3.6.1.6.3.1.1.5.5"));
        GENERIC_TRAPS.add(new SnmpObjectId("1.3.6.1.6.3.1.1.5.6"));
    }
}

