/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.internal.misc.Policy;

final class HandlerAuthority
implements ISourceProviderListener {
    private static final boolean DEBUG = Policy.DEBUG_HANDLERS;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
    private static final String DEBUG_VERBOSE_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    private final Set[] activationsBySourcePriority = new Set[33];
    private final CommandManager commandManager;
    private final IEvaluationContext context;
    private final Map handlerActivationsByCommandId = new HashMap();
    private final Collection providers = new ArrayList();

    HandlerAuthority(CommandManager commandManager) {
        if (commandManager == null) {
            throw new NullPointerException("The handler authority needs a command manager");
        }
        this.commandManager = commandManager;
        this.context = new EvaluationContext(null, (Object)this);
    }

    final void activateHandler(IHandlerActivation activation) {
        ArrayList<IHandlerActivation> handlerActivations;
        String commandId = activation.getCommandId();
        Object value = this.handlerActivationsByCommandId.get(commandId);
        if (value instanceof Collection) {
            handlerActivations = (ArrayList<IHandlerActivation>)value;
            if (!handlerActivations.contains(activation)) {
                handlerActivations.add(activation);
                this.updateCurrentState();
                this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations));
            }
        } else if (value instanceof IHandlerActivation) {
            if (value != activation) {
                handlerActivations = new ArrayList<IHandlerActivation>(2);
                handlerActivations.add((IHandlerActivation)value);
                handlerActivations.add(activation);
                this.handlerActivationsByCommandId.put(commandId, handlerActivations);
                this.updateCurrentState();
                this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations));
            }
        } else {
            this.handlerActivationsByCommandId.put(commandId, activation);
            this.updateCurrentState();
            this.updateCommand(commandId, activation.isActive(this.context) ? activation : null);
        }
        int sourcePriority = activation.getSourcePriority();
        int i = 1;
        while (i <= 32) {
            if ((sourcePriority & 1 << i) != 0) {
                HashSet<IHandlerActivation> activations = this.activationsBySourcePriority[i];
                if (activations == null) {
                    this.activationsBySourcePriority[i] = activations = new HashSet<IHandlerActivation>(1);
                }
                activations.add(activation);
            }
            ++i;
        }
    }

    final void addSourceProvider(ISourceProvider provider) {
        provider.addSourceProviderListener(this);
        this.providers.add(provider);
        this.updateCurrentState();
    }

    final void deactivateHandler(IHandlerActivation activation) {
        String commandId = activation.getCommandId();
        Object value = this.handlerActivationsByCommandId.get(commandId);
        if (value instanceof Collection) {
            Collection handlerActivations = (Collection)value;
            if (handlerActivations.contains(activation)) {
                handlerActivations.remove(activation);
                if (handlerActivations.isEmpty()) {
                    this.handlerActivationsByCommandId.remove(commandId);
                    this.updateCurrentState();
                    this.updateCommand(commandId, null);
                } else if (handlerActivations.size() == 1) {
                    IHandlerActivation remainingActivation = (IHandlerActivation)handlerActivations.iterator().next();
                    this.handlerActivationsByCommandId.put(commandId, remainingActivation);
                    this.updateCurrentState();
                    this.updateCommand(commandId, remainingActivation.isActive(this.context) ? remainingActivation : null);
                } else {
                    this.updateCurrentState();
                    this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations));
                }
            }
        } else if (value instanceof IHandlerActivation && value == activation) {
            this.handlerActivationsByCommandId.remove(commandId);
            this.updateCurrentState();
            this.updateCommand(commandId, null);
        }
        int sourcePriority = activation.getSourcePriority();
        int i = 1;
        while (i <= 32) {
            Set activations;
            if ((sourcePriority & 1 << i) != 0 && (activations = this.activationsBySourcePriority[i]) != null) {
                activations.remove(activation);
                if (activations.isEmpty()) {
                    this.activationsBySourcePriority[i] = null;
                }
            }
            ++i;
        }
    }

    private final void fillInCurrentState(IEvaluationContext context) {
        Iterator providerItr = this.providers.iterator();
        while (providerItr.hasNext()) {
            ISourceProvider provider = (ISourceProvider)providerItr.next();
            Map currentState = provider.getCurrentState();
            Iterator variableItr = currentState.entrySet().iterator();
            while (variableItr.hasNext()) {
                Map.Entry entry = variableItr.next();
                String variableName = (String)entry.getKey();
                Object variableValue = entry.getValue();
                if (variableName == null) continue;
                if (variableValue == null) {
                    context.removeVariable(variableName);
                    continue;
                }
                context.addVariable(variableName, variableValue);
            }
        }
    }

    final Shell getActiveShell() {
        return (Shell)this.context.getVariable("activeShell");
    }

    final IEvaluationContext getCurrentState() {
        EvaluationContext context = new EvaluationContext(null, (Object)this);
        this.fillInCurrentState((IEvaluationContext)context);
        return context;
    }

    final void removeSourceProvider(ISourceProvider provider) {
        provider.removeSourceProviderListener(this);
        this.providers.remove(provider);
        this.updateCurrentState();
    }

    private final IHandlerActivation resolveConflicts(String commandId, Collection handlerActivations) {
        Collection activations = this.trimInactive(handlerActivations);
        if (activations.isEmpty()) {
            return null;
        }
        Iterator activationItr = activations.iterator();
        IHandlerActivation bestActivation = (IHandlerActivation)activationItr.next();
        int bestSourcePriority = bestActivation.getSourcePriority();
        boolean conflict = false;
        while (activationItr.hasNext()) {
            IHandlerActivation currentActivation = (IHandlerActivation)activationItr.next();
            if (currentActivation.getSourcePriority() > bestSourcePriority) {
                bestActivation = currentActivation;
                bestSourcePriority = bestActivation.getSourcePriority();
                conflict = false;
                continue;
            }
            if (currentActivation.getSourcePriority() != bestSourcePriority || currentActivation.getHandler() == bestActivation.getHandler()) continue;
            conflict = true;
        }
        if (DEBUG) {
            if (conflict) {
                System.out.println("HANDLERS >>> Unresolved conflict detected for '" + commandId + '\'');
            } else if (DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                System.out.println("HANDLERS >>> Resolved conflict detected.  The following activation won: ");
                System.out.println("HANDLERS >>>     " + bestActivation);
            }
        }
        if (conflict) {
            return null;
        }
        return bestActivation;
    }

    private final void sourceChanged(int sourcePriority) {
        HashSet activationsToRecompute = new HashSet();
        int i = 1;
        while (i <= 32) {
            Set activations;
            if ((sourcePriority & 1 << i) != 0 && (activations = this.activationsBySourcePriority[i]) != null) {
                Iterator activationItr = activations.iterator();
                while (activationItr.hasNext()) {
                    activationsToRecompute.add(activationItr.next());
                }
            }
            ++i;
        }
        ArrayList<String> changedCommandIds = new ArrayList<String>(activationsToRecompute.size());
        Iterator activationItr = activationsToRecompute.iterator();
        while (activationItr.hasNext()) {
            IHandlerActivation activation = (IHandlerActivation)activationItr.next();
            boolean currentActive = activation.isActive(this.context);
            activation.clearActive();
            boolean newActive = activation.isActive(this.context);
            if (newActive == currentActive) continue;
            changedCommandIds.add(activation.getCommandId());
        }
        Iterator changedCommandIdItr = changedCommandIds.iterator();
        while (changedCommandIdItr.hasNext()) {
            IHandlerActivation activation;
            String commandId = (String)changedCommandIdItr.next();
            Object value = this.handlerActivationsByCommandId.get(commandId);
            if (value instanceof IHandlerActivation) {
                activation = (IHandlerActivation)value;
                this.updateCommand(commandId, activation.isActive(this.context) ? activation : null);
                continue;
            }
            if (value instanceof Collection) {
                activation = this.resolveConflicts(commandId, (Collection)value);
                this.updateCommand(commandId, activation);
                continue;
            }
            this.updateCommand(commandId, null);
        }
    }

    public final void sourceChanged(int sourcePriority, Map sourceValuesByName) {
        Iterator entryItr = sourceValuesByName.entrySet().iterator();
        while (entryItr.hasNext()) {
            Map.Entry entry = entryItr.next();
            String sourceName = (String)entry.getKey();
            Object sourceValue = entry.getValue();
            if (sourceName == null) continue;
            if (sourceValue == null) {
                this.context.removeVariable(sourceName);
                continue;
            }
            this.context.addVariable(sourceName, sourceValue);
        }
        this.sourceChanged(sourcePriority);
    }

    public final void sourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
        if (sourceName != null) {
            if (sourceValue == null) {
                this.context.removeVariable(sourceName);
            } else {
                this.context.addVariable(sourceName, sourceValue);
            }
        }
        this.sourceChanged(sourcePriority);
    }

    private final Collection trimInactive(Collection activations) {
        ArrayList<IHandlerActivation> trimmed = new ArrayList<IHandlerActivation>(activations.size());
        Iterator activationItr = activations.iterator();
        while (activationItr.hasNext()) {
            IHandlerActivation activation = (IHandlerActivation)activationItr.next();
            if (!activation.isActive(this.context)) continue;
            trimmed.add(activation);
        }
        return trimmed;
    }

    private final void updateCommand(String commandId, IHandlerActivation activation) {
        Command command = this.commandManager.getCommand(commandId);
        if (activation == null) {
            command.setHandler(null);
        } else {
            command.setHandler(activation.getHandler());
        }
    }

    private final void updateCurrentState() {
        this.fillInCurrentState(this.context);
    }

    final void updateShellKludge() {
        this.updateCurrentState();
        this.sourceChanged(1024);
    }
}

