/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part.services;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.IDisposable;
import org.eclipse.ui.internal.components.framework.IServiceProvider;
import org.eclipse.ui.internal.part.Part;
import org.eclipse.ui.internal.part.components.services.IActionBarContributor;
import org.eclipse.ui.internal.part.components.services.IActionBarContributorFactory;
import org.eclipse.ui.internal.part.components.services.IPartDescriptor;
import org.eclipse.ui.internal.part.multiplexer.INestedComponent;
import org.eclipse.ui.internal.part.multiplexer.ISharedContext;

public class ChildActionBarContributorFactory
implements INestedComponent,
IActionBarContributorFactory,
IDisposable {
    private IActionBarContributorFactory parent;
    private Map activeBars = new HashMap();
    private boolean active = false;
    private IPartDescriptor descriptor;
    private IActionBarContributor defaultContributor;
    static /* synthetic */ Class class$0;

    public ChildActionBarContributorFactory(IPartDescriptor descr, ISharedContext shared) throws ComponentException {
        IServiceProvider sharedContainer = shared.getSharedComponents();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.part.components.services.IActionBarContributorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.parent = (IActionBarContributorFactory)sharedContainer.getService(clazz);
        this.descriptor = descr;
        this.defaultContributor = this.parent.getContributor(descr);
    }

    public void activate(Part activePart) {
        Iterator iter = this.activeBars.values().iterator();
        while (iter.hasNext()) {
            PartMap next = (PartMap)iter.next();
            this.parent.activateBars(next.contributor, next.part);
        }
        this.parent.activateBars(this.defaultContributor, activePart);
        this.active = true;
    }

    public void deactivate(Object newActive) {
        ChildActionBarContributorFactory factory = null;
        if (newActive instanceof ChildActionBarContributorFactory) {
            factory = (ChildActionBarContributorFactory)newActive;
        }
        Iterator iter = this.activeBars.values().iterator();
        while (iter.hasNext()) {
            PartMap next = (PartMap)iter.next();
            String nextId = next.contributor.getDescriptor().getId();
            if (factory != null && (factory.activeBars.get(nextId) != null || factory.defaultContributor.getDescriptor().getId().equals(nextId))) continue;
            this.parent.deactivateBars(next.contributor);
        }
        String nextId = this.defaultContributor.getDescriptor().getId();
        if (factory == null || factory.activeBars.get(nextId) == null && !factory.defaultContributor.getDescriptor().getId().equals(nextId)) {
            this.parent.deactivateBars(this.defaultContributor);
        }
        this.active = false;
    }

    public void activateBars(IActionBarContributor toActivate, Part actualPart) {
        String key = toActivate.getDescriptor().getId();
        PartMap existing = (PartMap)this.activeBars.get(key);
        if (existing == null) {
            existing = new PartMap(toActivate, actualPart);
            this.activeBars.put(key, existing);
        } else {
            existing.contributor = toActivate;
            existing.part = actualPart;
        }
        if (this.active) {
            this.parent.activateBars(toActivate, actualPart);
        }
    }

    public void deactivateBars(IActionBarContributor toDeactivate) {
        String key = toDeactivate.getDescriptor().getId();
        PartMap existing = (PartMap)this.activeBars.get(key);
        if (existing == null) {
            return;
        }
        this.activeBars.remove(key);
        if (this.active) {
            this.parent.deactivateBars(toDeactivate);
        }
    }

    public IActionBarContributor getContributor(IPartDescriptor descriptor) {
        return this.parent.getContributor(descriptor);
    }

    public void dispose() {
        this.defaultContributor.dispose();
    }

    private final class PartMap {
        IActionBarContributor contributor;
        Part part;

        PartMap(IActionBarContributor contributor, Part part) {
            this.contributor = contributor;
            this.part = part;
        }
    }
}

