/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.composite;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.snmptrap.action.GetMaster;
import com.clustercontrol.snmptrap.action.GetOidTableDefine;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.dialog.SnmpTrapMasterDialog;
import com.clustercontrol.snmptrap.dialog.SnmpTrapModifyDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OidListComposite
extends Composite {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private ArrayList<MonitorSnmpTrapOidInfo> oidList = null;
    private CommonTableViewer tableViewer = null;
    private Combo comboMib = null;
    private Text textFilter = null;
    private Button buttonClearFilter = null;
    private Button buttonShowOidTable = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private String monitorId = null;
    private Table table = null;
    private Button radioSpecific = null;
    private Button radioAll = null;
    private Button radioUnregistered = null;

    public OidListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        Label label = null;
        this.radioSpecific = new Button((Composite)this, 16);
        this.radioSpecific.setText(Messages.getString((String)"OidListComposite.SpecificOid"));
        GridData gridDataRadio = new GridData();
        gridDataRadio.horizontalSpan = 5;
        gridDataRadio.horizontalAlignment = 4;
        gridDataRadio.grabExcessHorizontalSpace = true;
        this.radioSpecific.setLayoutData((Object)gridDataRadio);
        this.radioAll = new Button((Composite)this, 16);
        this.radioAll.setText(Messages.getString((String)"OidListComposite.AllMaterOid"));
        this.radioAll.setLayoutData((Object)gridDataRadio);
        this.radioUnregistered = new Button((Composite)this, 16);
        this.radioUnregistered.setText(Messages.getString((String)"OidListComposite.NoMasterOid"));
        this.radioUnregistered.setLayoutData((Object)gridDataRadio);
        this.radioSpecific.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OidListComposite.this.radioSpecific.getSelection()) {
                    OidListComposite.this.comboMib.setEnabled(true);
                    OidListComposite.this.textFilter.setEnabled(true);
                    OidListComposite.this.buttonClearFilter.setEnabled(true);
                    OidListComposite.this.buttonShowOidTable.setEnabled(true);
                    OidListComposite.this.table.setEnabled(true);
                    OidListComposite.this.buttonAdd.setEnabled(true);
                    OidListComposite.this.buttonModify.setEnabled(true);
                    OidListComposite.this.buttonDelete.setEnabled(true);
                } else {
                    OidListComposite.this.comboMib.setEnabled(false);
                    OidListComposite.this.textFilter.setEnabled(false);
                    OidListComposite.this.buttonClearFilter.setEnabled(false);
                    OidListComposite.this.buttonShowOidTable.setEnabled(false);
                    OidListComposite.this.table.setEnabled(false);
                    OidListComposite.this.buttonAdd.setEnabled(false);
                    OidListComposite.this.buttonModify.setEnabled(false);
                    OidListComposite.this.buttonDelete.setEnabled(false);
                }
            }
        });
        Group groupFilter = new Group((Composite)this, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupFilter.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupFilter.setLayoutData((Object)gridData);
        groupFilter.setText(String.valueOf(Messages.getString((String)"filter")) + " : ");
        label = new Label((Composite)groupFilter, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"mib")) + " : ");
        this.comboMib = new Combo((Composite)groupFilter, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboMib.setLayoutData((Object)gridData);
        this.comboMib.setVisibleItemCount(10);
        ArrayList<String> mibList = new GetMaster().getMibList();
        this.comboMib.add("");
        int i = 0;
        while (i < mibList.size()) {
            this.comboMib.add(mibList.get(i));
            ++i;
        }
        this.comboMib.select(0);
        this.comboMib.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OidListComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)groupFilter, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupFilter, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"trap.name")) + " : ");
        this.textFilter = new Text((Composite)groupFilter, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textFilter.setLayoutData((Object)gridData);
        this.textFilter.addVerifyListener((VerifyListener)new StringVerifyListener(256));
        this.buttonClearFilter = new Button((Composite)groupFilter, 0);
        this.buttonClearFilter.setText(Messages.getString((String)"clear"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonClearFilter.setLayoutData((Object)gridData);
        this.buttonClearFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OidListComposite.this.textFilter.setText("");
            }
        });
        this.buttonShowOidTable = new Button((Composite)groupFilter, 0);
        this.buttonShowOidTable.setText(Messages.getString((String)"show"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonShowOidTable.setLayoutData((Object)gridData);
        this.buttonShowOidTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OidListComposite.this.update();
            }
        });
        this.table = new Table((Composite)this, 68354);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.minimumHeight = 90;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 9;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonAdd = new Button((Composite)this, 0);
        this.buttonAdd.setText(Messages.getString((String)"add"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonAdd.setLayoutData((Object)gridData);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<SnmpTrapMasterInfo> list;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SnmpTrapMasterDialog dialog = new SnmpTrapMasterDialog(shell);
                dialog.setOidList(OidListComposite.this.oidList);
                if (dialog.open() == 0 && (list = dialog.getInputData()) != null) {
                    int i = 0;
                    while (i < list.size()) {
                        SnmpTrapMasterInfo master = list.get(i);
                        MonitorSnmpTrapOidInfo info = new MonitorSnmpTrapOidInfo();
                        info.setMonitorId(OidListComposite.this.monitorId);
                        info.setMib(master.getMib());
                        info.setTrapName(master.getUei());
                        info.setTrapOid(master.getTrapOid());
                        info.setGenericId(master.getGenericId());
                        info.setSpecificId(master.getSpecificId());
                        info.setValidFlg(1);
                        info.setPriority(master.getPriority());
                        info.setLogmsg(master.getLogmsg());
                        info.setDescr(master.getDescr());
                        OidListComposite.this.oidList.add(info);
                        ++i;
                    }
                }
                OidListComposite.this.update();
            }
        });
        this.buttonModify = new Button((Composite)this, 0);
        this.buttonModify.setText(Messages.getString((String)"modify"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonModify.setLayoutData((Object)gridData);
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ArrayList<MonitorSnmpTrapOidInfo> list = OidListComposite.this.getSelectionData();
                if (list != null && list.size() > 0) {
                    int index = 0;
                    while (index < list.size()) {
                        MonitorSnmpTrapOidInfo oidInfo = list.get(index);
                        SnmpTrapModifyDialog dialog = new SnmpTrapModifyDialog(shell);
                        dialog.setInputData(oidInfo);
                        dialog.open();
                        ++index;
                    }
                    OidListComposite.this.update();
                }
            }
        });
        this.buttonDelete = new Button((Composite)this, 0);
        this.buttonDelete.setText(Messages.getString((String)"delete"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonDelete.setLayoutData((Object)gridData);
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<MonitorSnmpTrapOidInfo> list = OidListComposite.this.getSelectionData();
                if (list != null && list.size() > 0) {
                    StringBuilder trapNames = new StringBuilder();
                    int index = 0;
                    while (index < list.size()) {
                        MonitorSnmpTrapOidInfo oidInfo = list.get(index);
                        if (index == 0) {
                            trapNames.append(oidInfo.getTrapName());
                        } else {
                            trapNames.append(", " + oidInfo.getTrapName());
                        }
                        ++index;
                    }
                    Object[] args = new String[]{trapNames.toString()};
                    String message = Messages.getString((String)"message.snmptrap.2", (Object[])args);
                    if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)message)) {
                        int index2 = 0;
                        while (index2 < list.size()) {
                            MonitorSnmpTrapOidInfo oidInfo = list.get(index2);
                            OidListComposite.this.oidList.remove(oidInfo);
                            ++index2;
                        }
                        OidListComposite.this.update();
                    }
                }
            }
        });
        this.tableViewer = new CommonTableViewer(this.table);
        this.tableViewer.createTableColumn(GetOidTableDefine.get(), 2, 1);
        this.update();
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public ArrayList<MonitorSnmpTrapOidInfo> getOidList() {
        return this.oidList;
    }

    public void setOidList(ArrayList<MonitorSnmpTrapOidInfo> oidList) {
        this.oidList = oidList;
    }

    public String getMonitorId() {
        return this.monitorId;
    }

    public void setMonitorId(String monitorId) {
        this.monitorId = monitorId;
    }

    public void update() {
        ArrayList list = this.collectionToArray(this.oidList);
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean select = true;
                ArrayList info = (ArrayList)element;
                String mib = (String)info.get(1);
                if (!OidListComposite.this.comboMib.getText().equals("") && !mib.equals(OidListComposite.this.comboMib.getText())) {
                    select = false;
                }
                String trapName = (String)info.get(2);
                if (!OidListComposite.this.textFilter.getText().equals("") && !trapName.matches(OidListComposite.this.textFilter.getText())) {
                    select = false;
                }
                return select;
            }
        });
        this.tableViewer.setInput(list);
    }

    public ArrayList collectionToArray(ArrayList<MonitorSnmpTrapOidInfo> oidList) {
        ArrayList list = new ArrayList();
        if (oidList != null) {
            for (MonitorSnmpTrapOidInfo oid : oidList) {
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(oid.getMonitorId());
                info.add(oid.getMib());
                info.add(oid.getTrapName());
                info.add(oid.getTrapOid());
                info.add(new Integer(oid.getGenericId()));
                info.add(new Integer(oid.getSpecificId()));
                info.add(new Integer(oid.getValidFlg()));
                info.add(new Integer(oid.getPriority()));
                info.add(oid.getLogmsg());
                list.add(info);
            }
        }
        return list;
    }

    public int getCheckMode() {
        if (this.radioAll.getSelection()) {
            return 1;
        }
        if (this.radioUnregistered.getSelection()) {
            return 2;
        }
        return 0;
    }

    public void setCheckMode(int mode) {
        switch (mode) {
            case 1: {
                this.radioAll.setSelection(true);
                this.comboMib.setEnabled(false);
                this.textFilter.setEnabled(false);
                this.buttonClearFilter.setEnabled(false);
                this.buttonShowOidTable.setEnabled(false);
                this.table.setEnabled(false);
                this.buttonAdd.setEnabled(false);
                this.buttonModify.setEnabled(false);
                this.buttonDelete.setEnabled(false);
                break;
            }
            case 2: {
                this.radioUnregistered.setSelection(true);
                this.comboMib.setEnabled(false);
                this.textFilter.setEnabled(false);
                this.buttonClearFilter.setEnabled(false);
                this.buttonShowOidTable.setEnabled(false);
                this.table.setEnabled(false);
                this.buttonAdd.setEnabled(false);
                this.buttonModify.setEnabled(false);
                this.buttonDelete.setEnabled(false);
                break;
            }
            default: {
                this.radioSpecific.setSelection(true);
            }
        }
    }

    protected ArrayList<MonitorSnmpTrapOidInfo> getSelectionData() {
        ArrayList<MonitorSnmpTrapOidInfo> data = new ArrayList<MonitorSnmpTrapOidInfo>();
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        List list = selection.toList();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                ArrayList info = (ArrayList)list.get(index);
                if (info != null && info.size() > 0) {
                    String mib = (String)info.get(1);
                    String oid = (String)info.get(3);
                    Integer genericId = (Integer)info.get(4);
                    Integer specificId = (Integer)info.get(5);
                    if (this.oidList != null) {
                        int i = 0;
                        while (i < this.oidList.size()) {
                            MonitorSnmpTrapOidInfo oidInfo = this.oidList.get(i);
                            if (mib.equals(oidInfo.getMib()) && oid.equals(oidInfo.getTrapOid()) && genericId.equals(oidInfo.getGenericId()) && specificId.equals(oidInfo.getSpecificId())) {
                                data.add(oidInfo);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                ++index;
            }
        }
        return data;
    }
}

