/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.composite;

import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class RecordGraphSetItemComposite
extends Composite {
    private GridLayout gridLayoutButton = null;
    private Group group = null;
    private Combo combo = null;
    private Button radioButton1;
    private Button radioButton2;
    private Button radioButton3;
    private Button radioButton4;
    private String categoryCode;
    private List itemList;
    private ArrayList availableItems = new ArrayList();
    private int selectItemID;
    private int graphType;

    public RecordGraphSetItemComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void setTitle(String title) {
        this.group.setText(title);
    }

    public void setData(String categoryCode, List itemList, int selectItemID, int graphType) {
        this.categoryCode = categoryCode;
        this.itemList = itemList;
        this.selectItemID = selectItemID;
        this.graphType = graphType;
        this.setComboData();
        this.setButtonSelection();
    }

    private void createGroup() {
        this.group = new Group((Composite)this, 0);
        this.gridLayoutButton = new GridLayout();
        this.gridLayoutButton.numColumns = 3;
        this.group.setLayout((Layout)this.gridLayoutButton);
        this.createCombo();
        this.radioButton1 = new Button((Composite)this.group, 16);
        this.radioButton1.setText(Messages.getString("HIDDEN"));
        GridData gridDataButton = new GridData(2);
        gridDataButton.horizontalSpan = 3;
        this.radioButton1.setLayoutData((Object)gridDataButton);
        this.radioButton2 = new Button((Composite)this.group, 16);
        this.radioButton2.setText(Messages.getString("SCOPE_REPRESENTING_VALUE"));
        gridDataButton = new GridData(2);
        this.radioButton2.setLayoutData((Object)gridDataButton);
        this.radioButton3 = new Button((Composite)this.group, 16);
        this.radioButton3.setText(Messages.getString("DETAIL_SCOPE_REPRESENTING_VALUE"));
        gridDataButton = new GridData(2);
        this.radioButton3.setLayoutData((Object)gridDataButton);
        this.radioButton4 = new Button((Composite)this.group, 16);
        this.radioButton4.setText(Messages.getString("SUB_SCOPE_REP_VAL"));
        gridDataButton = new GridData(2);
        this.radioButton4.setLayoutData((Object)gridDataButton);
    }

    private void createCombo() {
        this.combo = new Combo((Composite)this.group, 8);
        GridData gridDataCombo = new GridData(2);
        gridDataCombo.horizontalSpan = 3;
        this.combo.setLayoutData((Object)gridDataCombo);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RecordGraphSetItemComposite.this.checkItemList(RecordGraphSetItemComposite.this.getSelectItem());
            }
        });
        this.combo.setBounds(new Rectangle(5, 15, 200, 20));
    }

    private void checkItemList(CollectorItemInfo itemInfo) {
        if (CollectorItemCodeFactory.checkItemList(itemInfo, this.availableItems)) {
            this.setDetailButtonEnabled(true);
        } else {
            if (this.getGraphType() == 2) {
                this.graphType = 1;
                this.setButtonSelection();
            }
            this.setDetailButtonEnabled(false);
        }
    }

    public void setDetailButtonEnabled(boolean enabled) {
        this.radioButton3.setEnabled(enabled);
    }

    public void setSubScopeButtonEnabled(boolean enabled) {
        this.radioButton4.setEnabled(enabled);
    }

    private void setComboData() {
        Iterator itr = this.itemList.iterator();
        int i = 0;
        int selectIndex = 0;
        while (itr.hasNext()) {
            CollectorItemInfo itemInfo = (CollectorItemInfo)itr.next();
            if (!CollectorItemCodeFactory.getCategoryCode(itemInfo.getCollectorItemCode()).equals(this.categoryCode)) continue;
            this.combo.add(CollectorItemCodeFactory.getFullItemName(itemInfo.getCollectorItemCode(), itemInfo.getDeviceName()));
            this.availableItems.add(itemInfo);
            if (itemInfo.getCollectorItemID() == this.selectItemID) {
                selectIndex = i;
            }
            ++i;
        }
        this.combo.select(selectIndex);
        this.checkItemList((CollectorItemInfo)this.availableItems.get(selectIndex));
    }

    private void setButtonSelection() {
        switch (this.graphType) {
            case 0: {
                this.radioButton1.setSelection(true);
                this.radioButton2.setSelection(false);
                this.radioButton3.setSelection(false);
                this.radioButton4.setSelection(false);
                break;
            }
            case 1: {
                this.radioButton1.setSelection(false);
                this.radioButton2.setSelection(true);
                this.radioButton3.setSelection(false);
                this.radioButton4.setSelection(false);
                break;
            }
            case 2: {
                this.radioButton1.setSelection(false);
                this.radioButton2.setSelection(false);
                this.radioButton3.setSelection(true);
                this.radioButton4.setSelection(false);
                break;
            }
            case 3: {
                this.radioButton1.setSelection(false);
                this.radioButton2.setSelection(false);
                this.radioButton3.setSelection(false);
                this.radioButton4.setSelection(true);
                break;
            }
            default: {
                this.radioButton1.setSelection(true);
                this.radioButton2.setSelection(false);
                this.radioButton3.setSelection(false);
                this.radioButton4.setSelection(false);
            }
        }
    }

    private void initialize() {
        this.createGroup();
        this.setLayout((Layout)new FillLayout());
    }

    public int getGraphType() {
        if (this.radioButton1.getSelection()) {
            this.graphType = 0;
        } else if (this.radioButton2.getSelection()) {
            this.graphType = 1;
        } else if (this.radioButton3.getSelection()) {
            this.graphType = 2;
        } else if (this.radioButton4.getSelection()) {
            this.graphType = 3;
        }
        return this.graphType;
    }

    public CollectorItemInfo getSelectItem() {
        return (CollectorItemInfo)this.availableItems.get(this.combo.getSelectionIndex());
    }

    public void setGraphType(int graphType) {
        this.graphType = graphType;
        this.setButtonSelection();
    }
}

