/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.detection.jndi;

import java.net.InetAddress;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.detection.AbstractDetector;
import org.jboss.remoting.detection.Detection;
import org.jboss.remoting.detection.jndi.JNDIDetectorMBean;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.transport.PortUtil;
import org.jnp.server.Main;

public class JNDIDetector
extends AbstractDetector
implements JNDIDetectorMBean {
    private int port;
    private String host;
    private String contextFactory = (class$org$jnp$interfaces$NamingContextFactory == null ? (class$org$jnp$interfaces$NamingContextFactory = JNDIDetector.class$("org.jnp.interfaces.NamingContextFactory")) : class$org$jnp$interfaces$NamingContextFactory).getName();
    private String urlPackage = "org.jboss.naming:org.jnp.interfaces";
    private Identity id;
    private Context context;
    private int cleanDetectionCount = 0;
    public static final String DETECTION_SUBCONTEXT_NAME = "detection";
    private int detectionNumber = 5;
    protected final Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$org$jnp$interfaces$NamingContextFactory;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getURLPackage() {
        return this.urlPackage;
    }

    public void setURLPackage(String urlPackage) {
        this.urlPackage = urlPackage;
    }

    public void start() throws Exception {
        this.createContext();
        this.id = Identity.get(this.mbeanserver);
        super.start();
    }

    protected void heartbeat() {
        try {
            if (this.context == null) {
                this.createContext();
            }
            this.checkRemoteDetectionMsg();
        }
        catch (NamingException nex) {
            this.log.error("Can not connect to JNDI server to register local connectors.", nex);
        }
    }

    public int getCleanDetectionNumber() {
        return this.detectionNumber;
    }

    public void setCleanDetectionNumber(int cleanDetectionNumber) {
        this.detectionNumber = cleanDetectionNumber;
    }

    private void checkRemoteDetectionMsg() {
        try {
            boolean localFound = false;
            ++this.cleanDetectionCount;
            boolean cleanDetect = this.cleanDetectionCount > this.detectionNumber;
            String bindName = "";
            NamingEnumeration<Binding> enumeration = this.context.listBindings(bindName);
            while (enumeration.hasMore()) {
                Binding binding = enumeration.next();
                Detection regMsg = (Detection)binding.getObject();
                if (this.isRemoteDetection(regMsg)) {
                    this.log.debug("Detected id: " + regMsg.getIdentity().getInstanceId() + ", message: " + regMsg);
                    if (cleanDetect) {
                        ClassLoader cl;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Doing clean detection.");
                        }
                        if (this.checkInvokerServer(regMsg, cl = this.getClass().getClassLoader())) continue;
                        this.unregisterDetection(regMsg.getIdentity().getInstanceId());
                        continue;
                    }
                    this.detect(regMsg);
                    continue;
                }
                if (!this.verifyLocalDetectionMsg(regMsg)) {
                    this.addLocalDetectionMsg();
                }
                localFound = true;
            }
            if (cleanDetect) {
                this.cleanDetectionCount = 0;
            }
            if (!localFound) {
                this.addLocalDetectionMsg();
            }
        }
        catch (NamingException e) {
            this.log.error("Exception getting detection messages from JNDI server.", e);
        }
    }

    private boolean verifyLocalDetectionMsg(Detection regMsg) throws NamingException {
        boolean verified = false;
        InvokerLocator[] locators = InvokerRegistry.getRegisteredServerLocators();
        Detection msg = this.createDetection();
        String sId = this.id.getInstanceId();
        InvokerLocator[] invokers = regMsg.getLocators();
        if (sId.equals(regMsg.getIdentity().getInstanceId())) {
            boolean changed = false;
            if (locators.length != invokers.length) {
                changed = true;
            } else {
                boolean found = false;
                for (int i = 0; i < locators.length; ++i) {
                    found = false;
                    for (int x = 0; x < invokers.length; ++x) {
                        if (!locators[i].equals(invokers[x])) continue;
                        found = true;
                        break;
                    }
                    if (!found) break;
                }
                if (!found) {
                    changed = true;
                }
            }
            if (changed) {
                this.registerDetectionMsg(sId, msg);
            }
            verified = true;
        }
        return verified;
    }

    private void addLocalDetectionMsg() throws NamingException {
        Detection msg = this.createDetection();
        String sId = this.id.getInstanceId();
        this.registerDetectionMsg(sId, msg);
    }

    private void registerDetectionMsg(String sId, Detection msg) throws NamingException {
        block2: {
            try {
                this.context.bind(sId, (Object)msg);
                this.log.info("Added " + sId + " to registry.");
            }
            catch (NameAlreadyBoundException nabex) {
                if (!this.log.isTraceEnabled()) break block2;
                this.log.trace(sId + " already bound to server.");
            }
        }
    }

    private void verifyJNDIServer() {
        if (this.host == null || this.host.length() == 0) {
            try {
                this.log.info("JNDI Server configuration information not present so will create a local server.");
                this.port = PortUtil.findFreePort();
                this.host = InetAddress.getLocalHost().getHostName();
                this.log.info("Remoting JNDI detector starting JNDI server instance since none where specified via configuration.");
                this.log.info("Remoting JNDI server started on host + " + this.host + " and port " + this.port);
                Main server = new Main();
                server.setPort(this.port);
                server.setBindAddress(this.host);
                server.start();
                this.contextFactory = (class$org$jnp$interfaces$NamingContextFactory == null ? (class$org$jnp$interfaces$NamingContextFactory = JNDIDetector.class$("org.jnp.interfaces.NamingContextFactory")) : class$org$jnp$interfaces$NamingContextFactory).getName();
                this.urlPackage = "org.jboss.naming:org.jnp.interfaces";
            }
            catch (Exception e) {
                this.log.error("Error starting up JNDI server since none was specified via configuration.", e);
            }
        }
    }

    private void createContext() throws NamingException {
        this.verifyJNDIServer();
        Properties env = new Properties();
        env.put("java.naming.factory.initial", this.contextFactory);
        env.put("java.naming.provider.url", this.host + ":" + this.port);
        env.put("java.naming.factory.url.pkgs", this.urlPackage);
        InitialContext initialContext = new InitialContext(env);
        try {
            this.context = (Context)initialContext.lookup(DETECTION_SUBCONTEXT_NAME);
        }
        catch (NamingException e) {
            try {
                this.context = initialContext.createSubcontext(DETECTION_SUBCONTEXT_NAME);
            }
            catch (NameAlreadyBoundException e1) {
                this.log.debug("The sub context detection was created before we could.");
                this.context = (Context)initialContext.lookup(DETECTION_SUBCONTEXT_NAME);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        String sId2;
        try {
            super.stop();
            Object var2_1 = null;
            sId2 = this.id.getInstanceId();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            String sId2 = this.id.getInstanceId();
            try {
                this.unregisterDetection(sId2);
            }
            catch (NamingException e) {
                this.log.warn("Could not unregister " + sId2 + " before shutdown.  " + "Root cause is " + e.getMessage());
            }
            throw throwable;
        }
        try {
            this.unregisterDetection(sId2);
        }
        catch (NamingException e) {
            this.log.warn("Could not unregister " + sId2 + " before shutdown.  " + "Root cause is " + e.getMessage());
        }
    }

    private void unregisterDetection(String sId) throws NamingException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("unregistering detector " + sId);
        }
        this.context.unbind(sId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

