/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite.action;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.jobmanagement.action.GetSessionJobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.dialog.JobDialog;
import java.util.ArrayList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class SessionJobDoubleClickListener
implements IDoubleClickListener {
    protected Composite m_composite;

    public SessionJobDoubleClickListener(Composite composite) {
        this.m_composite = composite;
    }

    public void doubleClick(DoubleClickEvent event) {
        CommonTableTreeItem item;
        String sessionId = null;
        String jobId = null;
        if (this.m_composite instanceof HistoryComposite) {
            if (((StructuredSelection)event.getSelection()).getFirstElement() != null) {
                ArrayList info = (ArrayList)((StructuredSelection)event.getSelection()).getFirstElement();
                sessionId = (String)info.get(3);
                jobId = (String)info.get(4);
            }
        } else if (this.m_composite instanceof DetailComposite && ((StructuredSelection)event.getSelection()).getFirstElement() != null) {
            item = (CommonTableTreeItem)((StructuredSelection)event.getSelection()).getFirstElement();
            ArrayList info = item.getData();
            sessionId = ((DetailComposite)this.m_composite).getSessionId();
            jobId = (String)info.get(4);
        }
        if (sessionId != null && sessionId.length() > 0 && jobId != null && jobId.length() > 0 && (item = new GetSessionJobInfo().getJobTree(sessionId, jobId)) != null) {
            JobDialog dialog = new JobDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true);
            dialog.setJobTreeItem((JobTreeItem)item);
            dialog.open();
        }
    }
}

