/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.factory;

import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoPK;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoUtil;
import com.clustercontrol.process.util.ProcessProperties;
import com.clustercontrol.process.util.SnmpProcConnectionManager;
import com.clustercontrol.sharedtable.bean.ValueObject;
import com.clustercontrol.snmppoller.SnmpSharedTable;
import com.clustercontrol.util.Messages;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorProcess
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorProcess.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected MonitorProcessInfoLocal m_process = null;
    protected String m_command = "";
    protected String m_param = "";
    protected SnmpSharedTable m_sst = null;
    protected String m_message = null;
    protected String m_messageOrg = null;
    protected NumberFormat m_numberFormat = NumberFormat.getNumberInstance();
    private final int MAX_RETRY_COUNT = 1;

    public RunMonitorProcess() throws NamingException, JMSException, CreateException {
        this.setSnmpSharedTable();
    }

    public boolean collect(String facilityId) {
        int count = 0;
        this.m_nodeDate = this.m_now.getTime();
        this.m_value = 0.0;
        this.m_message = "";
        this.m_messageOrg = Messages.getString((String)"command") + " : " + this.m_command + ", " + Messages.getString((String)"param") + " : " + this.m_param;
        Pattern pCommand = null;
        Pattern pParam = null;
        Matcher m = null;
        long mostOldPollingTime = Long.MAX_VALUE;
        try {
            pCommand = Pattern.compile(this.m_command);
            pParam = Pattern.compile(this.m_param);
        }
        catch (PatternSyntaxException e) {
            m_log.error((Object)("collect(): \u30b3\u30de\u30f3\u30c9,\u30d1\u30e9\u30e1\u30fc\u30bf\u6b63\u898f\u8868\u73fe\u30d1\u30bf\u30fc\u30f3\u69cb\u6587\u30a8\u30e9\u30fc\u3002" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.process.4");
            return false;
        }
        int runInterval = this.m_monitor.getRunInterval();
        for (int retryCount = 0; retryCount <= 1; ++retryCount) {
            Set valueSetName = this.m_sst.getValueSet(facilityId, runInterval, ".1.3.6.1.2.1.25.4.2.1.2");
            Set valueSetParam = this.m_sst.getValueSet(facilityId, runInterval, ".1.3.6.1.2.1.25.4.2.1.5");
            Set valueSetCommand = this.m_sst.getValueSet(facilityId, runInterval, ".1.3.6.1.2.1.25.4.2.1.4");
            if (valueSetName == null || valueSetParam == null || valueSetCommand == null) {
                m_log.warn((Object)("collect()  FacilityID : " + facilityId + ", " + "valueSetName(Set) or valueSetParam(Set) or valueSetPath(Set) is null , SNMP Polling failed"));
                if (retryCount >= true) break;
                m_log.warn((Object)("collect() retry polling. FacilityID : " + facilityId));
                this.m_sst.polling(facilityId, 3000L);
                continue;
            }
            ValueObject valueObjCommand = null;
            ValueObject valueObjParam = null;
            ValueObject valueObjName = null;
            String valueCommand = null;
            String valueParam = null;
            String valueName = null;
            Iterator itr = valueSetName.iterator();
            boolean errorFlg = false;
            while (itr.hasNext()) {
                valueObjName = (ValueObject)itr.next();
                if (valueObjName != null) {
                    if (mostOldPollingTime > valueObjName.getDate()) {
                        mostOldPollingTime = valueObjName.getDate();
                    }
                    if ((valueName = (String)valueObjName.getValue()) == null) {
                        m_log.warn((Object)("collect()  FacilityID : " + facilityId + ", " + "valueName(String) is null. What happened?"));
                        this.m_message = Messages.getString((String)"message.process.6");
                        errorFlg = true;
                        break;
                    }
                } else {
                    m_log.debug((Object)("collect()  FacilityID : " + facilityId + ", " + "valueObjName(ValueObject) is null. What happened?"));
                    continue;
                }
                String key = valueObjName.getKey();
                String index = key.substring(key.lastIndexOf("."));
                valueObjCommand = this.m_sst.getValue(facilityId, runInterval, ".1.3.6.1.2.1.25.4.2.1.4" + index);
                if (valueObjCommand != null) {
                    valueCommand = (String)valueObjCommand.getValue();
                    if (valueCommand == null) {
                        m_log.warn((Object)("collect()  FacilityID : " + facilityId + ", " + "valueCommand(String) is null. What happened?"));
                        this.m_message = Messages.getString((String)"message.process.6");
                        errorFlg = true;
                        break;
                    }
                } else {
                    m_log.debug((Object)("collect()  FacilityID : " + facilityId + ", " + "valueObjCommand(ValueObject) is null. What happened?"));
                    continue;
                }
                if (valueCommand.length() == 0) {
                    valueCommand = valueName;
                } else if (!valueCommand.startsWith("/") && valueCommand.endsWith("\\") && !valueCommand.equals(valueName)) {
                    valueCommand = valueCommand + valueName;
                }
                if (!(m = pCommand.matcher(valueCommand)).matches()) continue;
                m_log.debug((Object)("collect()   FacilityID : " + facilityId + ", " + "valueObjCommand: " + valueObjCommand));
                valueObjParam = this.m_sst.getValue(facilityId, runInterval, ".1.3.6.1.2.1.25.4.2.1.5" + index);
                m_log.debug((Object)("collect()  FacilityID : " + facilityId + ", " + " valueObjParam: " + valueObjParam));
                if (valueObjParam != null) {
                    valueParam = (String)valueObjParam.getValue();
                    if (valueParam == null) {
                        m_log.warn((Object)("collect()  FacilityID : " + facilityId + ", " + "valueParam(String) is null. What happened?"));
                        this.m_message = Messages.getString((String)"message.process.6");
                        errorFlg = true;
                        break;
                    }
                } else {
                    m_log.debug((Object)("collect()  FacilityID : " + facilityId + ", " + "valueObjCommand(Object) is null. What happened?"));
                    continue;
                }
                m = pParam.matcher(valueParam);
                if (!m.matches()) continue;
                m_log.debug((Object)("collect()  FacilityID : " + facilityId + ", " + "valueObjParam : " + valueObjParam));
                Date pollingDate = new Date(valueObjCommand.getDate());
                int tolerance = ProcessProperties.getProperties().getStartSecond() + ProcessProperties.getProperties().getValidSecond();
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.m_now);
                cal.add(13, -tolerance);
                if (cal.getTime().compareTo(pollingDate) > 0) {
                    this.m_nodeDate = this.m_now.getTime();
                    Object[] args = new String[]{DateFormat.getDateTimeInstance().format(pollingDate)};
                    this.m_message = Messages.getString((String)"message.process.7", (Object[])args);
                    errorFlg = true;
                    break;
                }
                this.m_nodeDate = valueObjCommand.getDate();
                ++count;
            }
            if (errorFlg) {
                if (retryCount < 1) {
                    m_log.warn((Object)("collect() retry polling. FacilityID : " + facilityId + " " + this.m_message));
                    this.m_sst.polling(facilityId, 10000L);
                    continue;
                }
                return false;
            }
            if (count == 0) {
                long tolerance = (ProcessProperties.getProperties().getStartSecond() + ProcessProperties.getProperties().getValidSecond()) * 1000;
                if (this.m_now.getTime() - mostOldPollingTime - tolerance > 0L) {
                    this.m_nodeDate = this.m_now.getTime();
                    Date mostOldPollingDate = new Date(mostOldPollingTime);
                    Object[] args = new String[]{DateFormat.getDateTimeInstance().format(mostOldPollingDate)};
                    this.m_message = Messages.getString((String)"message.process.7", (Object[])args);
                    return false;
                }
            }
            this.m_value = count;
            this.m_message = Messages.getString((String)"process.number") + " : " + this.m_numberFormat.format(this.m_value);
            return true;
        }
        this.m_message = Messages.getString((String)"message.process.6");
        return false;
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorProcessInfoPK pk = new MonitorProcessInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_process = MonitorProcessInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_command = this.m_process.getCommand().trim();
        if (this.m_process.getParam() != null) {
            this.m_param = this.m_process.getParam().trim();
        }
    }

    public String getMessageId(int id) {
        if (id == 3) {
            return MESSAGE_ID_INFO;
        }
        if (id == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (id == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int id) {
        return this.m_message;
    }

    public String getMessageOrg(int id) {
        return this.m_messageOrg;
    }

    public String getMessageIdForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_ID_INFO;
        }
        if (priority == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    private void setSnmpSharedTable() throws NamingException {
        this.m_sst = SnmpProcConnectionManager.getConnectionManager().getSnmpSharedTable();
    }
}

