/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.monitor.syslogng;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.export.monitor.ExportMonitor;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.IntegerListComparator;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorSyslogng
extends ExportMonitor {
    private static Log log = LogFactory.getLog(ExportMonitorSyslogng.class);

    public void exportSyslogng() {
        log.info((Object)Messages.getMsg("ExportTool.Syslogng.Start"));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<LogFilterInfo> arrayList2 = this.getSyslogngList();
        if (arrayList2 instanceof ArrayList) {
            for (LogFilterInfo logFilterInfo : arrayList2) {
                Object[] objectArray = new Object[]{logFilterInfo.getMonitorId()};
                log.info((Object)Messages.getMsg("ExportTool.MonitorID", objectArray));
                arrayList.add(this.createCsvFormat((MonitorInfo)logFilterInfo));
            }
            Collections.sort(arrayList, new IntegerListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Output.Dir") + "/SYSLOGNG_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("ExportTool.Syslogng.End"));
    }

    @Override
    public ArrayList<String> createCsvFormat(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.createMonitorBase(monitorInfo));
        arrayList.addAll(this.createMonitorRule(monitorInfo));
        arrayList.addAll(this.createMonitorInfo(monitorInfo));
        arrayList.addAll(this.createMonitorNotify(monitorInfo));
        if (monitorInfo.getApplication() != null) {
            arrayList.add(monitorInfo.getApplication());
        } else {
            arrayList.add("");
        }
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        arrayList.add(PriorityConstant.typeToString((int)logFilterInfo.getPriority()));
        if (logFilterInfo.getMessageId() != null) {
            arrayList.add(logFilterInfo.getMessageId());
        } else {
            arrayList.add("");
        }
        if (logFilterInfo.getMessage() != null) {
            arrayList.add(logFilterInfo.getMessage());
        } else {
            arrayList.add("");
        }
        arrayList.add(ValidConstant.typeToString((int)monitorInfo.getValid()));
        return arrayList;
    }

    @Override
    protected ArrayList<String> createMonitorBase(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        arrayList.add(String.valueOf(logFilterInfo.getOrderNo()));
        arrayList.add(monitorInfo.getMonitorId());
        if (monitorInfo.getDescription() != null) {
            arrayList.add(monitorInfo.getDescription());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    @Override
    protected ArrayList<String> createMonitorRule(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (monitorInfo.getCalendarId() != null) {
            arrayList.add(monitorInfo.getCalendarId());
        } else {
            arrayList.add("");
        }
        arrayList.add(monitorInfo.getFacilityId());
        return arrayList;
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LogFilterInfo logFilterInfo = (LogFilterInfo)monitorInfo;
        if (logFilterInfo.getPattern() != null) {
            arrayList.add(logFilterInfo.getPattern());
        } else {
            arrayList.add("");
        }
        arrayList.add(ProcessConstant.typeToString((int)logFilterInfo.getProcessType()));
        return arrayList;
    }

    protected ArrayList<LogFilterInfo> getSyslogngList() {
        SyslogNGController syslogNGController = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();
        ArrayList arrayList = null;
        try {
            arrayList = syslogNGController.getFilterInfoList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

