/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import jp.co.intellilink.hinemos.export.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteCsvFile {
    private static Log log = LogFactory.getLog(WriteCsvFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCsvFile(String string, ArrayList<ArrayList<String>> arrayList) {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        FileChannel fileChannel = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            fileOutputStream = new FileOutputStream(string);
            fileChannel = fileOutputStream.getChannel();
            if (fileChannel.tryLock() == null) {
                log.error((Object)Messages.getMsg("ExportTool.LockFileFailed"));
                System.exit(51);
            }
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            for (ArrayList<String> arrayList2 : arrayList) {
                stringBuffer.delete(0, stringBuffer.length());
                int n = 0;
                for (String string2 : arrayList2) {
                    if (n > 0) {
                        stringBuffer.append("\t");
                    }
                    stringBuffer.append(string2);
                    ++n;
                }
                stringBuffer.append("\n");
                bufferedOutputStream.write(stringBuffer.toString().getBytes());
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ExportTool.WriteFileFailed"), (Throwable)exception);
            System.exit(51);
        }
        finally {
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)Messages.getMsg("ExportTool.WriteFileFailed"), (Throwable)iOException);
                System.exit(51);
            }
        }
    }
}

