/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.view;

import com.clustercontrol.calendar.composite.CalendarListComposite;
import com.clustercontrol.calendar.composite.CalendarScheduleComposite;
import com.clustercontrol.view.CommonViewPart;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class CalendarListView
extends CommonViewPart {
    public static final String ID = "com.clustercontrol.calendar.view.CalendarListView";
    private SashForm m_sash = null;
    private CalendarListComposite m_calendarList = null;
    private CalendarScheduleComposite m_schedule = null;
    protected Date m_base = null;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_sash = new SashForm(parent, 256);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.m_sash.setLayoutData((Object)gridData);
        this.m_calendarList = new CalendarListComposite((Composite)this.m_sash, 0);
        Calendar baseCalendar = Calendar.getInstance();
        baseCalendar.setTime(new Date());
        baseCalendar.add(4, -1);
        this.m_base = new Date();
        this.m_schedule = new CalendarScheduleComposite((Composite)this.m_sash, 0, baseCalendar.getTime());
        this.createContextMenu();
        this.update();
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CalendarListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_calendarList.getTable());
        this.m_calendarList.getTable().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem add = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarAddAction");
        ActionContributionItem modify = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarModifyAction");
        ActionContributionItem delete = (ActionContributionItem)toolbar.find("com.clustercontrol.calendar.view.action.CalendarDeleteAction");
        manager.add(add.getAction());
        manager.add(modify.getAction());
        manager.add(delete.getAction());
    }

    public void update() {
        this.m_calendarList.update();
        Calendar now = Calendar.getInstance();
        Calendar baseCalendar = Calendar.getInstance();
        baseCalendar.setTime(this.m_base);
        baseCalendar.set(10, now.get(10));
        baseCalendar.set(12, now.get(12));
        baseCalendar.set(13, now.get(13));
        this.m_base = baseCalendar.getTime();
        if (!this.m_base.equals(this.m_schedule.getBaseDate())) {
            this.CreateScheduleComposite();
        }
        this.m_schedule.update();
    }

    public void CreateScheduleComposite() {
        this.m_schedule.dispose();
        this.m_schedule = new CalendarScheduleComposite((Composite)this.m_sash, 0, this.m_base);
        this.m_sash.layout(true, true);
    }

    public CalendarListComposite getListComposite() {
        return this.m_calendarList;
    }

    public CalendarScheduleComposite getScheduleComposite() {
        return this.m_schedule;
    }

    public void showSchedule() {
        this.m_sash.setMaximizedControl(null);
    }

    public void hideSchedule() {
        this.m_sash.setMaximizedControl((Control)this.m_calendarList);
    }

    public Date getBaseDate() {
        return this.m_base;
    }

    public void setBaseDate(Date base) {
        this.m_base = base;
    }
}

