/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.dialog;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScopeTreeDialog
extends CommonDialog {
    protected FacilityTreeComposite treeComposite = null;
    protected boolean scopeOnly;

    public ScopeTreeDialog(Shell parent) {
        super(parent);
        this.scopeOnly = false;
    }

    public ScopeTreeDialog(Shell parent, boolean scopeOnly) {
        super(parent);
        this.scopeOnly = scopeOnly;
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected void customizeDialog(Composite parent) {
        parent.getShell().setText(Messages.getString((String)"select.scope"));
        GridLayout layout = new GridLayout(5, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.treeComposite = new FacilityTreeComposite(parent, 0, this.scopeOnly);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        this.treeComposite.setLayoutData(gridData);
        this.treeComposite.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ScopeTreeDialog.this.okPressed();
            }
        });
    }

    public FacilityTreeItem getSelectItem() {
        return this.treeComposite.getSelectItem();
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        FacilityTreeItem item = this.getSelectItem();
        if (item instanceof FacilityTreeItem) {
            if (item.getData().getType() == 2) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.hinemos.3"));
            }
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.hinemos.3"));
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

