/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.logtransfer.action.AddLogTransfer;
import com.clustercontrol.logtransfer.action.DeleteLogTransfer;
import com.clustercontrol.logtransfer.action.GetLogTransfer;
import com.clustercontrol.logtransfer.action.ModifyLogTransfer;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.composite.LogTransferListComposite;
import com.clustercontrol.logtransfer.dialog.LogTransferCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LogTransferListDialog
extends CommonDialog {
    private LogTransferListComposite logTransferList = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private Button buttonValid = null;
    private Button buttonInvalid = null;

    public LogTransferListDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(800, 350);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.logtransfer.list"));
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.logTransferList = new LogTransferListComposite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.logTransferList.setLayoutData(gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogTransferInfo info;
                LogTransferCreateDialog dialog = new LogTransferCreateDialog(LogTransferListDialog.this.getParentShell());
                if (dialog.open() == 0 && (info = dialog.getInputData()) != null) {
                    boolean result = new AddLogTransfer().add(info);
                    Object[] args = new String[]{info.getTransferId()};
                    if (result) {
                        MessageBox box = new MessageBox(LogTransferListDialog.this.getShell(), 34);
                        box.setText(Messages.getString((String)"successful"));
                        box.setMessage(Messages.getString((String)"message.logtransfer.1", (Object[])args));
                        box.open();
                        LogTransferListDialog.this.logTransferList.update();
                    } else {
                        MessageBox box = new MessageBox(LogTransferListDialog.this.getShell(), 33);
                        box.setText(Messages.getString((String)"failed"));
                        box.setMessage(Messages.getString((String)"message.logtransfer.2", (Object[])args));
                        box.open();
                    }
                }
            }
        });
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String transferId = null;
                Table table = LogTransferListDialog.this.logTransferList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        transferId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (transferId != null) {
                    LogTransferCreateDialog dialog = new LogTransferCreateDialog(LogTransferListDialog.this.getParentShell(), transferId);
                    if (dialog.open() == 0) {
                        boolean result = new ModifyLogTransfer().modify(dialog.getInputData());
                        Object[] args = new String[]{transferId};
                        if (result) {
                            MessageBox box = new MessageBox(LogTransferListDialog.this.getShell(), 34);
                            box.setText(Messages.getString((String)"successful"));
                            box.setMessage(Messages.getString((String)"message.logtransfer.3", (Object[])args));
                            box.open();
                            int selectIndex = table.getSelectionIndex();
                            LogTransferListDialog.this.logTransferList.update();
                            table.setSelection(selectIndex);
                        } else {
                            MessageBox box = new MessageBox(LogTransferListDialog.this.getShell(), 33);
                            box.setText(Messages.getString((String)"failed"));
                            box.setMessage(Messages.getString((String)"message.logtransfer.4", (Object[])args));
                            box.open();
                        }
                    }
                } else {
                    MessageBox box = new MessageBox(LogTransferListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.logtransfer.8"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String transferId = null;
                Table table = LogTransferListDialog.this.logTransferList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        transferId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (transferId != null) {
                    MessageBox confirmBox = new MessageBox(LogTransferListDialog.this.getShell(), 296);
                    confirmBox.setText(Messages.getString((String)"confirmed"));
                    Object[] args = new String[]{transferId};
                    String message = Messages.getString((String)"message.logtransfer.7", (Object[])args);
                    confirmBox.setMessage(message);
                    if (confirmBox.open() == 32) {
                        boolean result = new DeleteLogTransfer().delete(transferId);
                        if (result) {
                            MessageBox box = new MessageBox(LogTransferListDialog.this.getShell(), 34);
                            box.setText(Messages.getString((String)"successful"));
                            box.setMessage(Messages.getString((String)"message.logtransfer.5", (Object[])args));
                            box.open();
                            LogTransferListDialog.this.logTransferList.update();
                        } else {
                            MessageBox box = new MessageBox(LogTransferListDialog.this.getShell(), 33);
                            box.setText(Messages.getString((String)"failed"));
                            box.setMessage(Messages.getString((String)"message.logtransfer.6", (Object[])args));
                            box.open();
                        }
                    }
                } else {
                    MessageBox box = new MessageBox(LogTransferListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.logtransfer.8"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        new Label(composite, 0);
        this.buttonValid = this.createButton(composite, Messages.getString((String)"valid"));
        this.buttonValid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogTransferListDialog.this.setValid(1);
            }
        });
        this.buttonInvalid = this.createButton(composite, Messages.getString((String)"invalid"));
        this.buttonInvalid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogTransferListDialog.this.setValid(0);
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    public void setValid(int valid) {
        ArrayList<String> list = this.logTransferList.getSelectionData();
        if (list != null && list.size() > 0) {
            StringBuilder transferIds = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    transferIds.append(", ");
                }
                transferIds.append(list.get(i));
                ++i;
            }
            MessageBox confirmBox = new MessageBox(this.getShell(), 296);
            confirmBox.setText(Messages.getString((String)"confirmed"));
            Object[] confirmArgs = new String[]{transferIds.toString()};
            if (valid == 1) {
                confirmBox.setMessage(Messages.getString((String)"message.logtransfer.16", (Object[])confirmArgs));
            } else {
                confirmBox.setMessage(Messages.getString((String)"message.logtransfer.17", (Object[])confirmArgs));
            }
            if (confirmBox.open() == 256) {
                return;
            }
            int i2 = 0;
            while (i2 < list.size()) {
                String transferId = list.get(i2);
                if (transferId != null && !transferId.equals("")) {
                    LogTransferInfo info = new GetLogTransfer().getLogTransfer(transferId);
                    info.setValid(valid);
                    boolean result = new ModifyLogTransfer().modify(info);
                    if (!result) {
                        MessageBox box = new MessageBox(this.getShell(), 33);
                        box.setText(Messages.getString((String)"failed"));
                        Object[] args = new String[]{transferId};
                        box.setMessage(Messages.getString((String)"message.logtransfer.4", (Object[])args));
                        box.open();
                    }
                }
                ++i2;
            }
            int selectIndex = this.logTransferList.getTableViewer().getTable().getSelectionIndex();
            this.logTransferList.update();
            this.logTransferList.getTableViewer().getTable().setSelection(selectIndex);
        } else {
            MessageBox box = new MessageBox(this.getShell(), 40);
            box.setText(Messages.getString((String)"warning"));
            box.setMessage(Messages.getString((String)"message.logtransfer.8"));
            box.open();
        }
    }
}

