/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.help.internal.HelpPlugin;
import org.osgi.framework.Bundle;

public class ResourceLocator {
    public static final String CONTENTPRODUCER_XP_NAME = "contentProducer";
    public static final String CONTENTPRODUCER_XP_FULLNAME = "org.eclipse.help.contentProducer";
    private static Hashtable zipCache = new Hashtable();
    private static final Object ZIP_NOT_FOUND;
    private static final Object STATIC_DOCS_ONLY;
    private static Map contentProducers;

    static {
        STATIC_DOCS_ONLY = ZIP_NOT_FOUND = new Object();
        contentProducers = new HashMap(2, 0.5f);
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void registryChanged(IRegistryChangeEvent event) {
                IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.help", ResourceLocator.CONTENTPRODUCER_XP_NAME);
                int i = 0;
                while (i < deltas.length) {
                    IExtension extension = deltas[i].getExtension();
                    String affectedPlugin = extension.getNamespace();
                    Map map = contentProducers;
                    synchronized (map) {
                        contentProducers.remove(affectedPlugin);
                    }
                    ++i;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IHelpContentProducer getContentProducer(String pluginId) {
        Map map = contentProducers;
        synchronized (map) {
            Object producer = contentProducers.get(pluginId);
            if (producer == null) {
                producer = ResourceLocator.createContentProducer(pluginId);
                if (producer == null) {
                    producer = STATIC_DOCS_ONLY;
                }
                contentProducers.put(pluginId, producer);
            }
            if (producer == STATIC_DOCS_ONLY) {
                return null;
            }
            return (IHelpContentProducer)producer;
        }
    }

    private static IHelpContentProducer createContentProducer(String pluginId) {
        IExtensionPoint xp = Platform.getExtensionRegistry().getExtensionPoint(CONTENTPRODUCER_XP_FULLNAME);
        if (xp == null) {
            return null;
        }
        IExtension[] extensions = xp.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getNamespace().equals(pluginId)) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (CONTENTPRODUCER_XP_NAME.equals(elements[j].getName())) {
                        try {
                            Object o = elements[j].createExecutableExtension("producer");
                            if (o instanceof IHelpContentProducer) {
                                return (IHelpContentProducer)o;
                            }
                        }
                        catch (CoreException ce) {
                            HelpPlugin.logError("Exception occurred creating help content producer for plug-in " + pluginId + ".", ce);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static InputStream openFromProducer(Bundle pluginDesc, String file, String locale) {
        IHelpContentProducer producer = ResourceLocator.getContentProducer(pluginDesc.getSymbolicName());
        if (producer == null) {
            return null;
        }
        if (locale == null || locale.length() <= 0) {
            locale = Platform.getNL();
        }
        Locale l = locale.length() >= 5 ? new Locale(locale.substring(0, 2), locale.substring(3, 5)) : (locale.length() >= 2 ? new Locale(locale.substring(0, 2), "") : Locale.getDefault());
        return producer.getInputStream(pluginDesc.getSymbolicName(), file, l);
    }

    public static InputStream openFromPlugin(String pluginId, String file, String locale) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            return ResourceLocator.openFromPlugin(bundle, file, locale);
        }
        return null;
    }

    public static InputStream openFromZip(Bundle pluginDesc, String zip, String file, String locale) {
        String pluginID = pluginDesc.getSymbolicName();
        Hashtable cache = zipCache;
        ArrayList pathPrefix = ResourceLocator.getPathPrefix(locale);
        int i = 0;
        while (i < pathPrefix.size()) {
            Object cached = cache.get(String.valueOf(pluginID) + '/' + pathPrefix.get(i) + zip);
            if (cached == null) {
                try {
                    URL url = Platform.find((Bundle)pluginDesc, (IPath)new Path(pathPrefix.get(i) + zip));
                    if (url != null) {
                        URL realZipURL = Platform.asLocalURL((URL)Platform.resolve((URL)url));
                        cached = realZipURL.toExternalForm();
                    } else {
                        cached = ZIP_NOT_FOUND;
                    }
                }
                catch (IOException iOException) {
                    cached = ZIP_NOT_FOUND;
                }
                cache.put(String.valueOf(pluginID) + '/' + pathPrefix.get(i) + zip, cached);
            }
            if (cached != ZIP_NOT_FOUND && !cached.toString().startsWith("jar:")) {
                try {
                    URL jurl = new URL("jar", "", String.valueOf((String)cached) + "!/" + file);
                    URLConnection jconnection = jurl.openConnection();
                    jconnection.setDefaultUseCaches(false);
                    jconnection.setUseCaches(false);
                    return jconnection.getInputStream();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return null;
    }

    public static InputStream openFromPlugin(Bundle pluginDesc, String file, String locale) {
        ArrayList pathPrefix = ResourceLocator.getPathPrefix(locale);
        URL flatFileURL = ResourceLocator.find(pluginDesc, (IPath)new Path(file), pathPrefix);
        if (flatFileURL != null) {
            try {
                return flatFileURL.openStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    private static URL find(Bundle pluginDesc, IPath flatFilePath, ArrayList pathPrefix) {
        int i = 0;
        while (i < pathPrefix.size()) {
            URL url = Platform.find((Bundle)pluginDesc, (IPath)new Path(String.valueOf((String)pathPrefix.get(i)) + flatFilePath));
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    public static void clearZipCache() {
        zipCache = new Hashtable();
    }

    public static ArrayList getPathPrefix(String locale) {
        ArrayList<String> pathPrefix = new ArrayList<String>(5);
        String ws = Platform.getWS();
        String os = Platform.getOS();
        if (locale == null) {
            locale = Platform.getNL();
        }
        if (ws != null) {
            pathPrefix.add("ws/" + ws + '/');
        }
        if (os != null && !os.equals("OS_UNKNOWN")) {
            pathPrefix.add("os/" + os + '/');
        }
        if (locale != null && locale.length() >= 5) {
            pathPrefix.add("nl/" + locale.substring(0, 2) + '/' + locale.substring(3, 5) + '/');
        }
        if (locale != null && locale.length() >= 2) {
            pathPrefix.add("nl/" + locale.substring(0, 2) + '/');
        }
        pathPrefix.add("");
        return pathPrefix;
    }

    public static Set findTopicPaths(Bundle pluginDesc, String directory, String locale) {
        HashSet ret = new HashSet();
        ResourceLocator.findTopicPaths(pluginDesc, directory, locale, ret);
        return ret;
    }

    private static void findTopicPaths(Bundle pluginDesc, String directory, String locale, Set paths) {
        if (directory.endsWith("/")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        ArrayList pathPrefix = ResourceLocator.getPathPrefix(locale);
        int i = 0;
        while (i < pathPrefix.size()) {
            Enumeration entries;
            String path = pathPrefix.get(i) + directory;
            if (path.length() == 0) {
                path = "/";
            }
            if ((entries = pluginDesc.getEntryPaths(path)) != null) {
                while (entries.hasMoreElements()) {
                    String topicPath = (String)entries.nextElement();
                    if (topicPath.endsWith("/")) {
                        ResourceLocator.findTopicPaths(pluginDesc, topicPath, locale, paths);
                        continue;
                    }
                    paths.add(topicPath);
                }
            }
            ++i;
        }
    }
}

