/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.process.action.AddProcess;
import com.clustercontrol.process.action.DeleteProcess;
import com.clustercontrol.process.action.GetProcess;
import com.clustercontrol.process.action.ModifyProcess;
import com.clustercontrol.process.composite.ProcessListComposite;
import com.clustercontrol.process.dialog.ProcessCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ProcessListDialog
extends CommonDialog {
    private ProcessListComposite processList = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private Button buttonValid = null;
    private Button buttonInvalid = null;

    public ProcessListDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(800, 400);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.process.list"));
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.processList = new ProcessListComposite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.processList.setLayoutData(gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MonitorInfo info;
                ProcessCreateDialog dialog = new ProcessCreateDialog(ProcessListDialog.this.getParentShell());
                if (dialog.open() == 0 && (info = dialog.getInputData()) != null) {
                    boolean result = new AddProcess().add(info);
                    Object[] args = new String[]{info.getMonitorId()};
                    if (result) {
                        MessageBox box = new MessageBox(ProcessListDialog.this.getShell(), 34);
                        box.setText(Messages.getString((String)"successful"));
                        box.setMessage(Messages.getString((String)"message.monitor.33", (Object[])args));
                        box.open();
                        ProcessListDialog.this.processList.update();
                    } else {
                        MessageBox box = new MessageBox(ProcessListDialog.this.getShell(), 33);
                        box.setText(Messages.getString((String)"failed"));
                        box.setMessage(Messages.getString((String)"message.monitor.34", (Object[])args));
                        box.open();
                    }
                }
            }
        });
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                Table table = ProcessListDialog.this.processList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    ProcessCreateDialog dialog = new ProcessCreateDialog(ProcessListDialog.this.getParentShell(), monitorId);
                    if (dialog.open() == 0) {
                        boolean result = new ModifyProcess().modify(dialog.getInputData());
                        Object[] args = new String[]{monitorId};
                        if (result) {
                            MessageBox box = new MessageBox(ProcessListDialog.this.getShell(), 34);
                            box.setText(Messages.getString((String)"successful"));
                            box.setMessage(Messages.getString((String)"message.monitor.35", (Object[])args));
                            box.open();
                            int selectIndex = table.getSelectionIndex();
                            ProcessListDialog.this.processList.update();
                            table.setSelection(selectIndex);
                        } else {
                            MessageBox box = new MessageBox(ProcessListDialog.this.getShell(), 33);
                            box.setText(Messages.getString((String)"failed"));
                            box.setMessage(Messages.getString((String)"message.monitor.36", (Object[])args));
                            box.open();
                        }
                    }
                } else {
                    MessageBox box = new MessageBox(ProcessListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.1"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String monitorId = null;
                Table table = ProcessListDialog.this.processList.getTableViewer().getTable();
                TableItem[] item = table.getSelection();
                if (item != null && item.length > 0) {
                    try {
                        monitorId = (String)((ArrayList)item[0].getData()).get(0);
                    }
                    catch (Exception exception) {}
                }
                if (monitorId != null) {
                    MessageBox confirmBox = new MessageBox(ProcessListDialog.this.getShell(), 296);
                    confirmBox.setText(Messages.getString((String)"confirmed"));
                    Object[] args = new String[]{monitorId};
                    String message = Messages.getString((String)"message.monitor.39", (Object[])args);
                    confirmBox.setMessage(message);
                    if (confirmBox.open() == 32) {
                        boolean result = new DeleteProcess().delete(monitorId);
                        if (result) {
                            MessageBox box = new MessageBox(ProcessListDialog.this.getShell(), 34);
                            box.setText(Messages.getString((String)"successful"));
                            box.setMessage(Messages.getString((String)"message.monitor.37", (Object[])args));
                            box.open();
                            ProcessListDialog.this.processList.update();
                        } else {
                            MessageBox box = new MessageBox(ProcessListDialog.this.getShell(), 33);
                            box.setText(Messages.getString((String)"failed"));
                            box.setMessage(Messages.getString((String)"message.monitor.38", (Object[])args));
                            box.open();
                        }
                    }
                } else {
                    MessageBox box = new MessageBox(ProcessListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.1"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        new Label(composite, 0);
        this.buttonValid = this.createButton(composite, Messages.getString((String)"valid"));
        this.buttonValid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessListDialog.this.setValid(1);
            }
        });
        this.buttonInvalid = this.createButton(composite, Messages.getString((String)"invalid"));
        this.buttonInvalid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessListDialog.this.setValid(0);
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, Messages.getString((String)"close"), false);
    }

    public void setValid(int valid) {
        ArrayList<String> list = this.processList.getSelectionData();
        if (list != null && list.size() > 0) {
            StringBuilder monitorIds = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    monitorIds.append(", ");
                }
                monitorIds.append(list.get(i));
                ++i;
            }
            MessageBox confirmBox = new MessageBox(this.getShell(), 296);
            confirmBox.setText(Messages.getString((String)"confirmed"));
            Object[] confirmArgs = new String[]{monitorIds.toString()};
            if (valid == 1) {
                confirmBox.setMessage(Messages.getString((String)"message.monitor.47", (Object[])confirmArgs));
            } else {
                confirmBox.setMessage(Messages.getString((String)"message.monitor.48", (Object[])confirmArgs));
            }
            if (confirmBox.open() == 256) {
                return;
            }
            int i2 = 0;
            while (i2 < list.size()) {
                String monitorId = list.get(i2);
                if (monitorId != null && !monitorId.equals("")) {
                    MonitorInfo info = new GetProcess().getProcess(monitorId);
                    info.setValid(valid);
                    boolean result = new ModifyProcess().modify(info);
                    if (!result) {
                        MessageBox box = new MessageBox(this.getShell(), 33);
                        box.setText(Messages.getString((String)"failed"));
                        Object[] args = new String[]{monitorId};
                        box.setMessage(Messages.getString((String)"message.monitor.36", (Object[])args));
                        box.open();
                    }
                }
                ++i2;
            }
            int selectIndex = this.processList.getTableViewer().getTable().getSelectionIndex();
            this.processList.update();
            this.processList.getTableViewer().getTable().setSelection(selectIndex);
        } else {
            MessageBox box = new MessageBox(this.getShell(), 40);
            box.setText(Messages.getString((String)"warning"));
            box.setMessage(Messages.getString((String)"message.monitor.1"));
            box.open();
        }
    }
}

